/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public final class URLDecoder {
    private static final byte[] hexChars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 65, 66, 67, 68, 69, 70};
    private static final byte[] hexCharValues;

    static {
        byte[] byArray = new byte[22];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 10;
        byArray[17] = 11;
        byArray[18] = 12;
        byArray[19] = 13;
        byArray[20] = 14;
        byArray[21] = 15;
        hexCharValues = byArray;
    }

    private URLDecoder() {
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(new URL(string)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            String string3 = null;
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(35);
            if (n2 - n > 1 && n2 < string.length() - 1) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1, string.length());
            } else {
                string2 = string;
            }
            return URLDecoder.decode(string2, string3);
        }
    }

    public static String decode(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("/")) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(URLDecoder.decodeSegment(string3));
        }
        if (string2 != null) {
            stringBuffer.append('#');
            stringBuffer.append(URLDecoder.decodeSegment(string2));
        }
        return stringBuffer.toString();
    }

    public static URL decode(URL uRL) {
        String string = uRL.getFile();
        String string2 = uRL.getRef();
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), URLDecoder.decode(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static String decodeSegment(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            try {
                if (by == 37) {
                    byte by2 = byArray[++n2];
                    byte by3 = byArray[++n2];
                    by = (byte)((URLDecoder.hexToByte(by2) << 4) + URLDecoder.hexToByte(by3));
                }
                byArray2[n++] = by;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Assert.isTrue(false, Policy.bind("assert.decodeSegment"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.isTrue(false, Policy.bind("assert.decodeSegment"));
            }
            ++n2;
        }
        try {
            return new String(byArray2, 0, n, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    private static final byte hexToByte(byte by) {
        int n = 0;
        while (n < hexChars.length) {
            if (hexChars[n] == by) {
                return hexCharValues[n];
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }
}

