/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(new URL(string)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            String string3 = null;
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(35);
            if (n2 - n > 1 && n2 < string.length() - 1) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1, string.length());
            } else {
                string2 = string;
            }
            return URLEncoder.encode(string2, string3);
        }
    }

    public static String encode(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("/")) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(URLEncoder.encodeSegment(string3));
        }
        if (string2 != null) {
            stringBuffer.append('#');
            stringBuffer.append(URLEncoder.encodeSegment(string2));
        }
        return stringBuffer.toString();
    }

    public static URL encode(URL uRL) {
        String string = uRL.getFile();
        String string2 = uRL.getRef();
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), URLEncoder.encode(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    private static String encodeSegment(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (URLEncoder.mustEncode(c)) {
                byte[] byArray = null;
                try {
                    byArray = new Character(c).toString().getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                int n2 = 0;
                while (n2 < byArray.length) {
                    stringBuffer.append('%');
                    stringBuffer.append(Integer.toHexString(byArray[n2] >> 4 & 0xF));
                    stringBuffer.append(Integer.toHexString(byArray[n2] & 0xF));
                    ++n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean mustEncode(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        if (c >= '\'' && c <= '.') {
            return false;
        }
        return c != '!' && c != '$' && c != '_';
    }
}

