/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.guvnor.tools.GuvnorLocationManager;
import org.guvnor.tools.Messages;
import org.guvnor.tools.ResourceChangeListener;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.drools.guvnor";
    private static Activator plugin;
    private static GuvnorLocationManager locManager;
    private static ImageDescriptor GUVCONTROLLED_IMG;
    private static ImageDescriptor GUVLOCADD_IMG;
    private static ImageDescriptor GUVREPWIZBAN_IMG;
    public static final String IMG_GUVCONTROLLED = "guvnor_controlled.gif";
    public static final String IMG_GUVLOCADD = "guvnor_rep_add.gif";
    public static final String IMG_GUVREPWIZBAN = "guvnor_rep_wizban.gif";

    public static GuvnorLocationManager getLocationManager() {
        if (locManager == null) {
            locManager = new GuvnorLocationManager();
        }
        return locManager;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IStatus createStatus(int n, String string, Throwable throwable) {
        return new Status(n, PLUGIN_ID, string, throwable);
    }

    public void writeLog(int n, String string, Throwable throwable) {
        super.getLog().log(this.createStatus(n, string, throwable));
    }

    public void writeLog(IStatus iStatus) {
        super.getLog().log(iStatus);
    }

    public void displayMessage(final int n, final String string) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                switch (n) {
                    case 4: {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.getString("error"), (String)string);
                        break;
                    }
                    case 2: {
                        MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.getString("warning"), (String)string);
                    }
                }
            }
        });
    }

    public void displayError(int n, String string, Throwable throwable, boolean bl) {
        final IStatus iStatus = this.createStatus(n, string, throwable);
        if (bl) {
            this.writeLog(iStatus);
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)display.getActiveShell(), null, (String)Messages.getString("error"), (IStatus)iStatus);
            }
        });
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = Activator.getCachedImageDescriptor(string);
        if (imageDescriptor == null) {
            imageDescriptor = Activator.loadImageDescriptor(string);
        }
        return imageDescriptor;
    }

    private static ImageDescriptor loadImageDescriptor(String string) {
        String string2 = "icons/";
        try {
            URL uRL = Activator.getDefault().getBundle().getEntry("/");
            URL uRL2 = new URL(uRL, String.valueOf(string2) + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor getCachedImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = null;
        if (string.equals(IMG_GUVCONTROLLED)) {
            if (GUVCONTROLLED_IMG == null) {
                GUVCONTROLLED_IMG = Activator.loadImageDescriptor(IMG_GUVCONTROLLED);
            }
            imageDescriptor = GUVCONTROLLED_IMG;
        }
        if (string.equals(IMG_GUVLOCADD)) {
            if (GUVLOCADD_IMG == null) {
                GUVLOCADD_IMG = Activator.loadImageDescriptor(IMG_GUVLOCADD);
            }
            imageDescriptor = GUVLOCADD_IMG;
        }
        if (string.equals(IMG_GUVREPWIZBAN)) {
            if (GUVREPWIZBAN_IMG == null) {
                GUVREPWIZBAN_IMG = Activator.loadImageDescriptor(IMG_GUVREPWIZBAN);
            }
            imageDescriptor = GUVREPWIZBAN_IMG;
        }
        return imageDescriptor;
    }

    public boolean useDebugHttpClient() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)"org.guvnor.tools/debugHttpClient"));
    }
}

