/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.guvnor.tools.Activator;
import org.guvnor.tools.preferences.GuvnorPreferencePage;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;

public class GuvnorDecorator
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.guvnor.tools.decorator";

    private boolean isGuvnorResource(Object object) {
        if (object instanceof IResource) {
            return GuvnorMetadataUtils.findGuvnorMetadata((IResource)object) != null;
        }
        return false;
    }

    private void decorateResource(IResource iResource, IDecoration iDecoration) {
        try {
            if (iResource instanceof IFile) {
                this.addGuvnorOverlay(iDecoration);
                this.addChangeIndicator(iResource, iDecoration);
                this.addResourceDetails(iResource, iDecoration);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
    }

    private void addGuvnorOverlay(IDecoration iDecoration) {
        int n = GuvnorPreferencePage.getOverlayLocationPref();
        if (n != 4) {
            iDecoration.addOverlay(Activator.getImageDescriptor("guvnor_controlled.gif"), n);
        }
    }

    private void addResourceDetails(IResource iResource, IDecoration iDecoration) throws Exception {
        GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata(iResource);
        if (guvnorMetadataProps.getVersion() != null) {
            boolean bl = GuvnorPreferencePage.shouldShowRevision();
            boolean bl2 = GuvnorPreferencePage.shouldShowTimeDateStamp();
            if (bl || bl2) {
                iDecoration.addSuffix(" ");
            }
            if (bl) {
                iDecoration.addSuffix(guvnorMetadataProps.getRevision());
            }
            if (bl2) {
                if (bl) {
                    iDecoration.addSuffix(", " + guvnorMetadataProps.getVersion());
                } else {
                    iDecoration.addSuffix(guvnorMetadataProps.getVersion());
                }
            }
        }
    }

    private void addChangeIndicator(IResource iResource, IDecoration iDecoration) throws CoreException {
        if (!GuvnorMetadataUtils.isGuvnorResourceCurrent(iResource) && GuvnorPreferencePage.shouldShowChangeIndicator()) {
            iDecoration.addSuffix(" >");
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        if (this.isGuvnorResource(object)) {
            if (object instanceof IResource) {
                this.decorateResource((IResource)object, iDecoration);
            } else {
                Activator.getDefault().writeLog(4, "Called to decorate unknown: " + object.getClass().toString(), new Exception());
            }
        }
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

