/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorLocationManager {
    private static final String REP_CACHE_NAME = ".replist";
    private ArrayList<GuvnorRepository> repList = new ArrayList();
    private List<IRepositorySetListener> repsetListeners = new ArrayList<IRepositorySetListener>();

    GuvnorLocationManager() {
        try {
            this.load();
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
    }

    public void addRespository(String string) throws Exception {
        this.addRepository(new GuvnorRepository(string));
    }

    public void addRepository(GuvnorRepository guvnorRepository) throws Exception {
        if (this.findRepository(guvnorRepository.getLocation()) != null) {
            throw new Exception("Duplicate repository: " + guvnorRepository.getLocation());
        }
        this.repList.add(guvnorRepository);
        this.notifyListeners(0);
        try {
            this.commit();
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    public List<GuvnorRepository> getRepositories() {
        return this.repList;
    }

    public boolean removeRepository(String string) {
        GuvnorRepository guvnorRepository;
        boolean bl;
        block3: {
            bl = false;
            guvnorRepository = this.findRepository(string);
            if (guvnorRepository != null) break block3;
            return false;
        }
        try {
            bl = this.repList.remove(guvnorRepository);
            Platform.flushAuthorizationInfo((URL)new URL(string), (String)"", (String)"basic");
            Activator.getLocationManager().removeRepository(guvnorRepository.getLocation());
            this.notifyListeners(0);
            this.commit();
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
        return bl;
    }

    public GuvnorRepository findRepository(String string) {
        GuvnorRepository guvnorRepository = null;
        int n = 0;
        while (n < this.repList.size()) {
            if (this.repList.get(n).getLocation().equals(string)) {
                guvnorRepository = this.repList.get(n);
                break;
            }
            ++n;
        }
        return guvnorRepository;
    }

    private void commit() throws Exception {
        File file = Activator.getDefault().getStateLocation().append(REP_CACHE_NAME).toFile();
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            int n = 0;
            while (n < this.repList.size()) {
                GuvnorRepository guvnorRepository = this.repList.get(n);
                printWriter.println(guvnorRepository.getLocation());
                ++n;
            }
            printWriter.flush();
            fileOutputStream.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private void load() throws Exception {
        this.repList.clear();
        File file = Activator.getDefault().getStateLocation().append(REP_CACHE_NAME).toFile();
        if (!file.exists()) {
            return;
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = null;
            do {
                if ((string = bufferedReader.readLine()) == null || string.trim().length() <= 0) continue;
                this.repList.add(new GuvnorRepository(string));
            } while (string != null);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public boolean addRepositorySetListener(IRepositorySetListener iRepositorySetListener) {
        return this.repsetListeners.add(iRepositorySetListener);
    }

    public boolean removeRepositorySetListener(IRepositorySetListener iRepositorySetListener) {
        return this.repsetListeners.remove(iRepositorySetListener);
    }

    private void notifyListeners(int n) {
        int n2 = 0;
        while (n2 < this.repsetListeners.size()) {
            try {
                this.repsetListeners.get(n2).repositorySetChanged(n, this.repList);
            }
            catch (Throwable throwable) {
                Activator.getDefault().writeLog(4, throwable.getMessage(), throwable);
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRepositorySetListener {
        public static final int REP_ADDED = 0;
        public static final int REP_REMOVED = 1;

        public void repositorySetChanged(int var1, List<GuvnorRepository> var2);
    }
}

