/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        final ArrayList<IResource> arrayList = new ArrayList<IResource>();
        try {
            if (iResourceChangeEvent.getDelta() != null) {
                iResourceChangeEvent.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                        block7: {
                            if (iResourceDelta.getResource() != null && iResourceDelta.getResource().isAccessible()) break block7;
                            return false;
                        }
                        try {
                            if (iResourceDelta.getKind() == 1) {
                                ResourceChangeListener.this.handleResourceAdded(iResourceDelta.getResource());
                            }
                            if (iResourceDelta.getKind() == 4) {
                                ResourceChangeListener.this.handleResourceChanged(iResourceDelta.getResource());
                            }
                            if (iResourceDelta.getKind() == 2) {
                                ResourceChangeListener.this.handleResourceDelete(iResourceDelta.getResource(), arrayList);
                            }
                            if (iResourceDelta.getMovedFromPath() != null) {
                                ResourceChangeListener.this.handleResourceMoved(iResourceDelta.getResource(), iResourceDelta.getMovedFromPath());
                            }
                        }
                        catch (Exception exception) {
                            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
                        }
                        return true;
                    }
                });
                this.deleteResources(arrayList);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
    }

    private void handleResourceAdded(IResource iResource) throws Exception {
        if (GuvnorMetadataUtils.isGuvnorMetadata(iResource)) {
            IFile iFile = GuvnorMetadataUtils.getGuvnorControlledResource(iResource);
            if (iFile != null) {
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)iFile);
            }
        } else if (GuvnorMetadataUtils.isGuvnorControlledResource(iResource)) {
            GuvnorMetadataUtils.markCurrentGuvnorResource(iResource);
        }
    }

    private void handleResourceChanged(IResource iResource) throws CoreException {
        if (GuvnorMetadataUtils.getGuvnorResourceProperty(iResource) != null) {
            GuvnorMetadataUtils.markExpiredGuvnorResource(iResource);
            PlatformUtils.updateDecoration();
        }
    }

    private void deleteResources(final List<IResource> list) throws CoreException {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkspace iWorkspace = Activator.getDefault().getWorkspace();
                try {
                    IResource[] iResourceArray = new IResource[list.size()];
                    list.toArray(iResourceArray);
                    iWorkspace.delete(iResourceArray, true, null);
                }
                catch (CoreException coreException) {
                    Activator.getDefault().writeLog(4, coreException.getMessage(), coreException);
                }
            }
        });
    }

    private void handleResourceDelete(IResource iResource, List<IResource> list) {
        IFile iFile = GuvnorMetadataUtils.findGuvnorMetadata(iResource);
        if (iFile == null) {
            return;
        }
        list.add((IResource)iFile);
    }

    private void handleResourceMoved(final IResource iResource, IPath iPath) throws Exception {
        IFile iFile = GuvnorMetadataUtils.findGuvnorMetadata(iPath);
        if (iFile == null) {
            return;
        }
        final GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.loadGuvnorMetadata(iFile);
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    GuvnorMetadataUtils.setGuvnorMetadataProps(iResource.getFullPath(), guvnorMetadataProps);
                }
                catch (Exception exception) {
                    Activator.getDefault().writeLog(4, exception.getMessage(), exception);
                }
            }
        });
    }
}

