/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.actions.DisconnectAction;
import org.guvnor.tools.utils.ActionUtils;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;

public class DeleteAction
implements IObjectActionDelegate {
    private IStructuredSelection selectedItems;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        if (this.selectedItems == null) {
            return;
        }
        String string = null;
        string = this.selectedItems.size() == 1 ? MessageFormat.format(Messages.getString("delete.singlefile.confirmation"), ((IFile)this.selectedItems.getFirstElement()).getName()) : MessageFormat.format(Messages.getString("delete.multifile.confirmation"), String.valueOf(this.selectedItems.size()));
        if (!MessageDialog.openConfirm((Shell)this.targetPart.getSite().getShell(), (String)Messages.getString("delete.confirmation.dialog.caption"), (String)string)) {
            return;
        }
        for (Object e : this.selectedItems) {
            if (!(e instanceof IFile)) continue;
            this.processDelete((IFile)e);
        }
        DisconnectAction disconnectAction = new DisconnectAction();
        disconnectAction.disconnect(this.selectedItems);
        PlatformUtils.updateDecoration();
        PlatformUtils.refreshRepositoryView();
    }

    private void processDelete(IFile iFile) {
        try {
            GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
            assert (guvnorMetadataProps != null);
            IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(guvnorMetadataProps.getRepository());
            if (iWebDavClient == null) {
                iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorMetadataProps.getRepository()));
                WebDavServerCache.cacheWebDavClient(guvnorMetadataProps.getRepository(), iWebDavClient);
            }
            try {
                iWebDavClient.deleteResource(guvnorMetadataProps.getFullpath());
            }
            catch (WebDavException webDavException) {
                if (webDavException.getErrorCode() != 401) {
                    throw webDavException;
                }
                boolean bl = PlatformUtils.getInstance().authenticateForServer(guvnorMetadataProps.getRepository(), iWebDavClient);
                if (bl) {
                    iWebDavClient.deleteResource(guvnorMetadataProps.getFullpath());
                }
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl = ActionUtils.checkResourceSet(iSelection, true);
        if (bl) {
            iAction.setEnabled(true);
            this.selectedItems = (IStructuredSelection)iSelection;
        } else {
            iAction.setEnabled(false);
            this.selectedItems = null;
        }
    }
}

