/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.guvnor.tools.Activator;
import org.guvnor.tools.views.model.TreeObject;

public class OpenGuvnorWebConsoleAction
implements IObjectActionDelegate {
    private TreeObject selectedNode;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.selectedNode == null) {
            return;
        }
        IWorkbenchBrowserSupport iWorkbenchBrowserSupport = Activator.getDefault().getWorkbench().getBrowserSupport();
        try {
            URL uRL = new URL(this.extractGuvnorConsoleUrl(this.selectedNode.getGuvnorRepository().getLocation()));
            if (iWorkbenchBrowserSupport.isInternalWebBrowserAvailable()) {
                iWorkbenchBrowserSupport.createBrowser(null).openURL(uRL);
            } else {
                iWorkbenchBrowserSupport.getExternalBrowser().openURL(uRL);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    private String extractGuvnorConsoleUrl(String string) {
        String string2 = "/webdav";
        int n = string.indexOf(string2);
        if (n == -1) {
            return String.valueOf(string) + "/Guvnor.html";
        }
        return String.valueOf(string.substring(0, n)) + "/Guvnor.html";
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(false);
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return;
        }
        if (iStructuredSelection.getFirstElement() instanceof TreeObject && ((TreeObject)iStructuredSelection.getFirstElement()).getNodeType() == TreeObject.Type.REPOSITORY) {
            this.selectedNode = (TreeObject)iStructuredSelection.getFirstElement();
            iAction.setEnabled(true);
        }
    }
}

