/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.ResourceHistoryView;
import org.guvnor.tools.views.model.TreeObject;

public class ShowHistoryAction
implements IObjectActionDelegate {
    private IFile selectedFile;
    private TreeObject selectedNode;
    private GuvnorMetadataProps props;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        block22: {
            String string = null;
            String string2 = null;
            if (this.selectedNode != null) {
                string = this.selectedNode.getGuvnorRepository().getLocation();
                string2 = this.selectedNode.getFullPath();
            } else {
                if (this.selectedFile == null || this.props == null) {
                    return;
                }
                string = this.props.getRepository();
                string2 = this.props.getFullpath();
            }
            IResponse iResponse = null;
            try {
                try {
                    InputStream inputStream;
                    block21: {
                        IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(string);
                        if (iWebDavClient == null) {
                            iWebDavClient = WebDavClientFactory.createClient(new URL(string));
                            WebDavServerCache.cacheWebDavClient(string, iWebDavClient);
                        }
                        inputStream = null;
                        try {
                            iResponse = iWebDavClient.getResourceVersions(string2);
                            inputStream = iResponse.getInputStream();
                        }
                        catch (WebDavException webDavException) {
                            if (webDavException.getErrorCode() != 401) {
                                throw webDavException;
                            }
                            boolean bl = PlatformUtils.getInstance().authenticateForServer(string, iWebDavClient);
                            if (!bl) break block21;
                            iResponse = iWebDavClient.getResourceVersions(string2);
                            inputStream = iResponse.getInputStream();
                        }
                    }
                    if (inputStream != null) {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        ResourceHistoryView resourceHistoryView = PlatformUtils.getResourceHistoryView();
                        if (resourceHistoryView != null) {
                            resourceHistoryView.setEntries(string, string2, properties);
                        }
                    }
                }
                catch (Exception exception) {
                    Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
                    if (iResponse == null) break block22;
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
            finally {
                if (iResponse != null) {
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selectedFile = null;
        this.selectedNode = null;
        this.props = null;
        iAction.setEnabled(false);
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return;
        }
        if (iStructuredSelection.getFirstElement() instanceof IFile) {
            try {
                this.props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)iStructuredSelection.getFirstElement()));
                if (this.props != null) {
                    this.selectedFile = (IFile)iStructuredSelection.getFirstElement();
                    iAction.setEnabled(true);
                }
            }
            catch (Exception exception) {
                Activator.getDefault().writeLog(4, exception.getMessage(), exception);
            }
        }
        if (iStructuredSelection.getFirstElement() instanceof TreeObject && ((TreeObject)iStructuredSelection.getFirstElement()).getNodeType() == TreeObject.Type.RESOURCE) {
            this.selectedNode = (TreeObject)iStructuredSelection.getFirstElement();
            iAction.setEnabled(true);
        }
    }
}

