/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.VersionChooserDialog;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class SwitchVersionAction
implements IObjectActionDelegate {
    private IFile selectedFile;
    private GuvnorMetadataProps props;
    private IWorkbenchPart targetPart;
    private IWebDavClient client;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        if (this.selectedFile == null || this.props == null || this.targetPart == null) {
            return;
        }
        VersionChooserDialog versionChooserDialog = new VersionChooserDialog(this.targetPart.getSite().getShell(), this.selectedFile.getName(), this.getVersionEntries());
        if (versionChooserDialog.open() == 0) {
            this.updateSelectedFile(versionChooserDialog.getSelectedEntry());
            PlatformUtils.updateDecoration();
        }
    }

    private void updateSelectedFile(ResourceHistoryEntry resourceHistoryEntry) {
        block13: {
            IResponse iResponse = null;
            try {
                try {
                    iResponse = this.client.getResourceVersionInputStream(this.props.getFullpath(), resourceHistoryEntry.getRevision());
                    InputStream inputStream = iResponse.getInputStream();
                    if (inputStream != null) {
                        this.selectedFile.setContents(inputStream, true, true, null);
                        GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)this.selectedFile);
                        GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)this.selectedFile);
                        guvnorMetadataProps.setVersion(resourceHistoryEntry.getDate());
                        guvnorMetadataProps.setRevision(resourceHistoryEntry.getRevision());
                        GuvnorMetadataUtils.setGuvnorMetadataProps(this.selectedFile.getFullPath(), guvnorMetadataProps);
                    }
                }
                catch (Exception exception) {
                    Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
                    if (iResponse == null) break block13;
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
            finally {
                if (iResponse != null) {
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }

    private ResourceHistoryEntry[] getVersionEntries() {
        ResourceHistoryEntry[] resourceHistoryEntryArray;
        block18: {
            resourceHistoryEntryArray = new ResourceHistoryEntry[]{};
            IResponse iResponse = null;
            try {
                try {
                    InputStream inputStream;
                    block17: {
                        this.client = WebDavServerCache.getWebDavClient(this.props.getRepository());
                        if (this.client == null) {
                            this.client = WebDavClientFactory.createClient(new URL(this.props.getRepository()));
                            WebDavServerCache.cacheWebDavClient(this.props.getRepository(), this.client);
                        }
                        inputStream = null;
                        try {
                            iResponse = this.client.getResourceVersions(this.props.getFullpath());
                            inputStream = iResponse.getInputStream();
                        }
                        catch (WebDavException webDavException) {
                            if (webDavException.getErrorCode() != 401) {
                                throw webDavException;
                            }
                            boolean bl = PlatformUtils.getInstance().authenticateForServer(this.props.getRepository(), this.client);
                            if (!bl) break block17;
                            iResponse = this.client.getResourceVersions(this.props.getFullpath());
                            inputStream = iResponse.getInputStream();
                        }
                    }
                    if (inputStream != null) {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        resourceHistoryEntryArray = GuvnorMetadataUtils.parseHistoryProperties(properties);
                    }
                }
                catch (Exception exception) {
                    Activator.getDefault().writeLog(4, exception.getMessage(), exception);
                    if (iResponse == null) break block18;
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
            finally {
                if (iResponse != null) {
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
        }
        return resourceHistoryEntryArray;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selectedFile = null;
        this.props = null;
        iAction.setEnabled(false);
        try {
            IStructuredSelection iStructuredSelection;
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof IFile && iStructuredSelection.size() == 1) {
                this.props = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)iStructuredSelection.getFirstElement()));
                if (this.props != null) {
                    this.selectedFile = (IFile)iStructuredSelection.getFirstElement();
                    iAction.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
    }
}

