/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.webdav.IResponse;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.ActionUtils;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;

public class UpdateAction
implements IObjectActionDelegate {
    private IStructuredSelection selectedItems;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        assert (this.selectedItems != null);
        for (Object e : this.selectedItems) {
            if (!(e instanceof IFile)) continue;
            this.processUpdate((IFile)e);
        }
        PlatformUtils.updateDecoration();
    }

    private void processUpdate(IFile iFile) {
        block18: {
            IResponse iResponse = null;
            try {
                try {
                    InputStream inputStream;
                    IWebDavClient iWebDavClient;
                    GuvnorMetadataProps guvnorMetadataProps;
                    block17: {
                        guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
                        iWebDavClient = WebDavServerCache.getWebDavClient(guvnorMetadataProps.getRepository());
                        if (iWebDavClient == null) {
                            iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorMetadataProps.getRepository()));
                            WebDavServerCache.cacheWebDavClient(guvnorMetadataProps.getRepository(), iWebDavClient);
                        }
                        inputStream = null;
                        try {
                            iResponse = iWebDavClient.getResourceInputStream(guvnorMetadataProps.getFullpath());
                            inputStream = iResponse.getInputStream();
                        }
                        catch (WebDavException webDavException) {
                            if (webDavException.getErrorCode() != 401) {
                                throw webDavException;
                            }
                            boolean bl = PlatformUtils.getInstance().authenticateForServer(guvnorMetadataProps.getRepository(), iWebDavClient);
                            if (!bl) break block17;
                            iResponse = iWebDavClient.getResourceInputStream(guvnorMetadataProps.getFullpath());
                            inputStream = iResponse.getInputStream();
                        }
                    }
                    if (inputStream != null) {
                        iFile.setContents(inputStream, true, true, null);
                        GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)iFile);
                        ResourceProperties resourceProperties = iWebDavClient.queryProperties(guvnorMetadataProps.getFullpath());
                        GuvnorMetadataProps guvnorMetadataProps2 = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
                        guvnorMetadataProps2.setVersion(resourceProperties.getLastModifiedDate());
                        guvnorMetadataProps2.setRevision(resourceProperties.getRevision());
                        GuvnorMetadataUtils.setGuvnorMetadataProps(iFile.getFullPath(), guvnorMetadataProps2);
                    }
                }
                catch (Exception exception) {
                    Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
                    if (iResponse == null) break block18;
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
            finally {
                if (iResponse != null) {
                    try {
                        iResponse.close();
                    }
                    catch (IOException iOException) {
                        Activator.getDefault().writeLog(4, iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }

    private ResourceProperties getRemoteResourceProps(IFile iFile, GuvnorMetadataProps guvnorMetadataProps) {
        ResourceProperties resourceProperties = null;
        try {
            IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(guvnorMetadataProps.getRepository());
            if (iWebDavClient == null) {
                iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorMetadataProps.getRepository()));
                WebDavServerCache.cacheWebDavClient(guvnorMetadataProps.getRepository(), iWebDavClient);
            }
            try {
                resourceProperties = iWebDavClient.queryProperties(guvnorMetadataProps.getFullpath());
            }
            catch (WebDavException webDavException) {
                if (webDavException.getErrorCode() != 401) {
                    throw webDavException;
                }
                boolean bl = PlatformUtils.getInstance().authenticateForServer(guvnorMetadataProps.getRepository(), iWebDavClient);
                if (bl) {
                    resourceProperties = iWebDavClient.queryProperties(guvnorMetadataProps.getFullpath());
                }
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
        return resourceProperties;
    }

    private boolean hasChangedRevision(ISelection iSelection) {
        boolean bl;
        block8: {
            bl = true;
            if (iSelection instanceof IStructuredSelection) break block8;
            return false;
        }
        try {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (!(e instanceof IFile)) continue;
                GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)((IFile)e));
                if (guvnorMetadataProps != null) {
                    ResourceProperties resourceProperties = this.getRemoteResourceProps((IFile)e, guvnorMetadataProps);
                    if (resourceProperties == null) {
                        bl = false;
                    } else {
                        if (!resourceProperties.getRevision().equals(guvnorMetadataProps.getRevision())) continue;
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                break;
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
            bl = false;
        }
        return bl;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl;
        boolean bl2 = bl = ActionUtils.checkResourceSet(iSelection, true) && ActionUtils.areFilesDirty(iSelection) || this.hasChangedRevision(iSelection);
        if (bl) {
            iAction.setEnabled(true);
            this.selectedItems = (IStructuredSelection)iSelection;
        } else {
            iAction.setEnabled(false);
            this.selectedItems = null;
        }
    }
}

