/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;

public class GuvnorWorkspaceFilePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Control createContents(Composite composite) {
        Composite composite2 = PlatformUtils.createComposite(composite, 2);
        IResource iResource = (IResource)super.getElement().getAdapter(IResource.class);
        if (iResource != null) {
            this.displayGuvnorProperties(composite2, iResource);
        } else {
            this.indicateNotGuvnorAssociated(composite2);
        }
        return composite2;
    }

    private void displayGuvnorProperties(Composite composite, IResource iResource) {
        try {
            GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata(iResource);
            if (guvnorMetadataProps == null) {
                this.indicateNotGuvnorAssociated(composite);
            } else {
                this.addGuvnorProperties(composite, guvnorMetadataProps);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().writeLog(4, exception.getMessage(), exception);
        }
    }

    private void addGuvnorProperties(Composite composite, GuvnorMetadataProps guvnorMetadataProps) {
        new Label(composite, 0).setText(Messages.getString("repository.label"));
        Label label = new Label(composite, 0);
        String string = guvnorMetadataProps.getRepository() != null ? guvnorMetadataProps.getRepository() : "";
        label.setText(string);
        new Label(composite, 0).setText(Messages.getString("repository.path"));
        label = new Label(composite, 0);
        String string2 = guvnorMetadataProps.getFullpath() != null ? guvnorMetadataProps.getFullpath().substring(string.length()) : "";
        label.setText(string2);
        new Label(composite, 0).setText(Messages.getString("repository.resource.version"));
        label = new Label(composite, 0);
        string = guvnorMetadataProps.getVersion() != null ? guvnorMetadataProps.getVersion() : "";
        label.setText(string);
        new Label(composite, 0).setText(Messages.getString("repository.resource.revision"));
        label = new Label(composite, 0);
        string = guvnorMetadataProps.getVersion() != null ? guvnorMetadataProps.getRevision() : "";
        label.setText(string);
    }

    private void indicateNotGuvnorAssociated(Composite composite) {
        new Label(composite, 0).setText(Messages.getString("not.guvnor.associated"));
    }
}

