/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.properties;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.model.TreeObject;

public class RepositoryElementPropsDialog
extends TitleAreaDialog {
    private static final int INITIAL_WIDTH = 780;
    private static final int INITIAL_HEIGHT = 400;
    private TreeObject node;
    private Text unField;
    private Text pwField;

    public RepositoryElementPropsDialog(Shell shell, TreeObject treeObject) {
        super(shell);
        super.setShellStyle(this.getShellStyle() | 0x10);
        this.node = treeObject;
    }

    protected Control createDialogArea(Composite composite) {
        super.setTitle(Messages.getString("guvnor.repository.element"));
        super.setMessage(MessageFormat.format(Messages.getString("guvnor.resource.properties"), this.node.getName()));
        super.setTitleImage(Activator.getImageDescriptor("guvnor_rep_wizban.gif").createImage());
        TabFolder tabFolder = new TabFolder(composite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("properties.basic"));
        Composite composite2 = PlatformUtils.createComposite((Composite)tabFolder, 2);
        tabItem.setControl((Control)composite2);
        this.addElementProperties(composite2);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("properties.security"));
        composite2 = PlatformUtils.createComposite((Composite)tabFolder, 2);
        tabItem.setControl((Control)composite2);
        this.addSecurityProperties(composite2);
        return super.createDialogArea(composite);
    }

    private void addElementProperties(Composite composite) {
        IPropertySource iPropertySource = (IPropertySource)this.node.getAdapter(IPropertySource.class);
        if (iPropertySource == null) {
            return;
        }
        IPropertyDescriptor[] iPropertyDescriptorArray = iPropertySource.getPropertyDescriptors();
        int n = 0;
        while (n < iPropertyDescriptorArray.length) {
            if (iPropertyDescriptorArray[n] instanceof TextPropertyDescriptor) {
                TextPropertyDescriptor textPropertyDescriptor = (TextPropertyDescriptor)iPropertyDescriptorArray[n];
                new Label(composite, 0).setText(MessageFormat.format(Messages.getString("guvnor.resource.property"), textPropertyDescriptor.getDisplayName()));
                String string = iPropertySource.getPropertyValue(textPropertyDescriptor.getId()) != null ? (String)iPropertySource.getPropertyValue(textPropertyDescriptor.getId()) : "";
                new Label(composite, 0).setText(string);
            }
            ++n;
        }
    }

    private void addSecurityProperties(Composite composite) {
        new Label(composite, 0).setText(Messages.getString("user.name"));
        this.unField = new Text(composite, 2060);
        this.unField.setLayoutData((Object)new GridData(768));
        this.unField.setEditable(false);
        this.unField.setBackground(Display.getDefault().getSystemColor(22));
        new Label(composite, 0).setText(Messages.getString("password"));
        this.pwField = new Text(composite, 4196364);
        this.pwField.setLayoutData((Object)new GridData(768));
        this.pwField.setEditable(false);
        this.pwField.setBackground(Display.getDefault().getSystemColor(22));
        this.populateSecuritySettings();
    }

    private void populateSecuritySettings() {
        try {
            String string;
            Map map = Platform.getAuthorizationInfo((URL)new URL(this.node.getGuvnorRepository().getLocation()), (String)"", (String)"basic");
            if (map == null) {
                return;
            }
            String string2 = (String)map.get("username");
            if (string2 != null) {
                this.unField.setText(string2);
            }
            if ((string = (String)map.get("password")) != null) {
                this.pwField.setText(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Activator.getDefault().writeLog(4, malformedURLException.getMessage(), malformedURLException);
        }
    }

    protected Point getInitialSize() {
        return new Point(780, 400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("guvnor.resource.properties.title"));
    }
}

