/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class GuvnorMetadataUtils {
    public static IFile findGuvnorMetadata(IResource iResource) {
        IFile iFile = null;
        IPath iPath = iResource.getFullPath().removeLastSegments(1);
        IPath iPath2 = iPath.append(".guvnorinfo").append("." + iResource.getName());
        IResource iResource2 = iResource.getWorkspace().getRoot().findMember(iPath2);
        if (iResource2 != null && iResource2.exists() && iResource2 instanceof IFile) {
            iFile = (IFile)iResource2;
        }
        return iFile;
    }

    public static boolean addResourceToGuvnor(String string, String string2, IFile iFile) {
        boolean bl = false;
        try {
            IWebDavClient iWebDavClient;
            String string3;
            block8: {
                string3 = String.valueOf(string2) + iFile.getName();
                iWebDavClient = WebDavServerCache.getWebDavClient(string);
                if (iWebDavClient == null) {
                    iWebDavClient = WebDavClientFactory.createClient(new URL(string));
                    WebDavServerCache.cacheWebDavClient(string, iWebDavClient);
                }
                try {
                    bl = iWebDavClient.createResource(string3, new ByteArrayInputStream(new byte[0]), false);
                    if (bl) {
                        iWebDavClient.putResource(string3, iFile.getContents());
                    }
                }
                catch (WebDavException webDavException) {
                    if (webDavException.getErrorCode() != 401) {
                        throw webDavException;
                    }
                    boolean bl2 = PlatformUtils.getInstance().authenticateForServer(string, iWebDavClient);
                    if (!bl2 || !(bl = iWebDavClient.createResource(string3, new ByteArrayInputStream(new byte[0]), false))) break block8;
                    iWebDavClient.putResource(string3, iFile.getContents());
                }
            }
            if (bl) {
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)iFile);
                ResourceProperties resourceProperties = iWebDavClient.queryProperties(string3);
                GuvnorMetadataProps guvnorMetadataProps = new GuvnorMetadataProps(iFile.getName(), string, string3, resourceProperties.getLastModifiedDate(), resourceProperties.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(iFile.getFullPath(), guvnorMetadataProps);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
        return bl;
    }

    public static void commitFileChanges(IFile iFile) {
        try {
            GuvnorMetadataProps guvnorMetadataProps;
            ResourceProperties resourceProperties;
            IWebDavClient iWebDavClient;
            GuvnorMetadataProps guvnorMetadataProps2;
            block9: {
                guvnorMetadataProps2 = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
                iWebDavClient = WebDavServerCache.getWebDavClient(guvnorMetadataProps2.getRepository());
                if (iWebDavClient == null) {
                    iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorMetadataProps2.getRepository()));
                    WebDavServerCache.cacheWebDavClient(guvnorMetadataProps2.getRepository(), iWebDavClient);
                }
                resourceProperties = null;
                try {
                    resourceProperties = iWebDavClient.queryProperties(guvnorMetadataProps2.getFullpath());
                }
                catch (WebDavException webDavException) {
                    if (webDavException.getErrorCode() != 401) {
                        throw webDavException;
                    }
                    boolean bl = PlatformUtils.getInstance().authenticateForServer(guvnorMetadataProps2.getRepository(), iWebDavClient);
                    if (!bl) break block9;
                    resourceProperties = iWebDavClient.queryProperties(guvnorMetadataProps2.getFullpath());
                }
            }
            if (resourceProperties == null) {
                throw new Exception("Could not retrieve server version of " + guvnorMetadataProps2.getFullpath());
            }
            boolean bl = true;
            if (!guvnorMetadataProps2.getRevision().equals(resourceProperties.getRevision())) {
                String string = MessageFormat.format(Messages.getString("overwrite.confirmation"), iFile.getName(), resourceProperties.getRevision(), guvnorMetadataProps2.getRevision());
                guvnorMetadataProps = PlatformUI.getWorkbench().getDisplay();
                bl = MessageDialog.openQuestion((Shell)guvnorMetadataProps.getActiveShell(), (String)Messages.getString("overwrite.confirmation.caption"), (String)string);
            }
            if (bl) {
                iWebDavClient.putResource(guvnorMetadataProps2.getFullpath(), iFile.getContents());
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)iFile);
                ResourceProperties resourceProperties2 = iWebDavClient.queryProperties(guvnorMetadataProps2.getFullpath());
                guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
                guvnorMetadataProps.setVersion(resourceProperties2.getLastModifiedDate());
                guvnorMetadataProps.setRevision(resourceProperties2.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(iFile.getFullPath(), guvnorMetadataProps);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    public static IFile findGuvnorMetadata(IPath iPath) {
        IFile iFile = null;
        IPath iPath2 = iPath.removeLastSegments(1);
        IPath iPath3 = iPath2.append(".guvnorinfo").append("." + iPath.lastSegment());
        IResource iResource = Activator.getDefault().getWorkspace().getRoot().findMember(iPath3);
        if (iResource != null && iResource.exists() && iResource instanceof IFile) {
            iFile = (IFile)iResource;
        }
        return iFile;
    }

    public static boolean isGuvnorControlledResource(IResource iResource) {
        return GuvnorMetadataUtils.findGuvnorMetadata(iResource) != null;
    }

    public static GuvnorMetadataProps loadGuvnorMetadata(IFile iFile) throws Exception {
        Properties properties = new Properties();
        properties.load(iFile.getContents());
        return new GuvnorMetadataProps(properties.getProperty("filename"), properties.getProperty("repository"), properties.getProperty("fullpath"), properties.getProperty("lastmodified"), properties.getProperty("revision"));
    }

    public static GuvnorMetadataProps getGuvnorMetadata(IResource iResource) throws Exception {
        IFile iFile = GuvnorMetadataUtils.findGuvnorMetadata(iResource);
        if (iFile == null) {
            return null;
        }
        return GuvnorMetadataUtils.loadGuvnorMetadata(iFile);
    }

    public static void writeGuvnorMetadataProps(File file, GuvnorMetadataProps guvnorMetadataProps) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            Properties properties = new Properties();
            properties.put("repository", guvnorMetadataProps.getRepository());
            properties.put("fullpath", guvnorMetadataProps.getFullpath());
            properties.put("filename", guvnorMetadataProps.getFilename());
            properties.put("lastmodified", guvnorMetadataProps.getVersion());
            properties.put("revision", guvnorMetadataProps.getRevision());
            properties.store(fileOutputStream, null);
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void setGuvnorMetadataProps(IPath iPath, GuvnorMetadataProps guvnorMetadataProps) throws Exception {
        IWorkspaceRoot iWorkspaceRoot = Activator.getDefault().getWorkspace().getRoot();
        IFolder iFolder = iWorkspaceRoot.getFolder(iPath.removeLastSegments(1).append(".guvnorinfo"));
        if (!iFolder.exists()) {
            iFolder.create(true, true, null);
        }
        IFile iFile = iWorkspaceRoot.getFile(iFolder.getFullPath().append("." + iPath.lastSegment()));
        Properties properties = new Properties();
        if (!iFile.exists()) {
            iFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        } else {
            properties.load(iFile.getContents());
        }
        if (guvnorMetadataProps.getRepository() != null) {
            properties.put("repository", guvnorMetadataProps.getRepository());
        }
        if (guvnorMetadataProps.getFullpath() != null) {
            properties.put("fullpath", guvnorMetadataProps.getFullpath());
        }
        if (guvnorMetadataProps.getFilename() != null) {
            properties.put("filename", guvnorMetadataProps.getFilename());
        }
        if (guvnorMetadataProps.getVersion() != null) {
            properties.put("lastmodified", guvnorMetadataProps.getVersion());
        }
        if (guvnorMetadataProps.getRevision() != null) {
            properties.put("revision", guvnorMetadataProps.getRevision());
        }
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(iFile.getLocation().toOSString()));
            properties.store(outputStream, null);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        iFolder.refreshLocal(2, null);
    }

    public static IPath createGuvnorMetadataLocation(String string) throws Exception {
        Path path = new Path(String.valueOf(string) + File.separator + ".guvnorinfo");
        if (!path.toFile().exists() && !path.toFile().mkdir()) {
            throw new Exception("Could not create directory " + path.toOSString());
        }
        return path;
    }

    public static File getGuvnorMetadataFile(String string, String string2) {
        return new File(String.valueOf(string) + File.separator + "." + string2);
    }

    public static IFile getGuvnorControlledResource(IResource iResource) throws Exception {
        IFile iFile = null;
        if (iResource instanceof IFile) {
            Properties properties = new Properties();
            properties.load(((IFile)iResource).getContents());
            if (properties.getProperty("filename") != null) {
                iFile = (IFile)Activator.getDefault().getWorkspace().getRoot().findMember(iResource.getFullPath().removeLastSegments(2).append(properties.getProperty("filename")));
            }
        }
        return iFile;
    }

    public static boolean isGuvnorMetadata(IResource iResource) {
        return iResource.getFullPath().removeLastSegments(1).toOSString().endsWith(".guvnorinfo");
    }

    public static void markCurrentGuvnorResource(IResource iResource) throws CoreException {
        iResource.setPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"), "current");
    }

    public static void markExpiredGuvnorResource(IResource iResource) throws CoreException {
        iResource.setPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"), "expired");
    }

    public static String getGuvnorResourceProperty(IResource iResource) throws CoreException {
        return iResource.getPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"));
    }

    public static boolean isGuvnorResourceCurrent(IResource iResource) throws CoreException {
        String string = iResource.getPersistentProperty(GuvnorMetadataUtils.generateQualifiedName("version"));
        if (string == null) {
            return false;
        }
        return string.equals("current");
    }

    private static QualifiedName generateQualifiedName(String string) {
        return new QualifiedName("org.guvnor.tools", string);
    }

    public static ResourceHistoryEntry[] parseHistoryProperties(Properties properties) {
        ResourceHistoryEntry[] resourceHistoryEntryArray = new ResourceHistoryEntry[properties.size()];
        Enumeration<Object> enumeration = properties.keys();
        int n = 0;
        while (n < properties.size()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = null;
            String string4 = null;
            String string5 = null;
            try {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {}
            resourceHistoryEntryArray[n] = new ResourceHistoryEntry(string, string3, string4, string5);
            ++n;
        }
        return resourceHistoryEntryArray;
    }
}

