/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.AuthenticationPromptDialog;
import org.guvnor.tools.utils.StringInput;
import org.guvnor.tools.utils.StringStorage;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.utils.webdav.WebDavSessionAuthenticator;
import org.guvnor.tools.views.RepositoryView;
import org.guvnor.tools.views.ResourceHistoryView;

public class PlatformUtils {
    private static PlatformUtils instance;

    public static PlatformUtils getInstance() {
        if (instance == null) {
            instance = new PlatformUtils();
        }
        return instance;
    }

    public static IFile getResourceFromFSPath(String string) {
        return Activator.getDefault().getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
    }

    public static Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    public static void updateDecoration() {
        final IWorkbench iWorkbench = Activator.getDefault().getWorkbench();
        iWorkbench.getDisplay().syncExec(new Runnable(){

            public void run() {
                IDecoratorManager iDecoratorManager = iWorkbench.getDecoratorManager();
                iDecoratorManager.update("org.guvnor.tools.decorator");
            }
        });
    }

    public static void refreshRepositoryView() {
        IWorkbenchWindow iWorkbenchWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        RepositoryView repositoryView = (RepositoryView)iWorkbenchPage.findView("org.guvnor.tools.views.RepositoryView");
        if (repositoryView != null) {
            repositoryView.refresh();
        }
    }

    public static ResourceHistoryView getResourceHistoryView() throws Exception {
        IWorkbenchWindow iWorkbenchWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        return (ResourceHistoryView)iWorkbenchPage.showView("org.guvnor.tools.views.ResourceHistoryView");
    }

    public static void openEditor(String string, String string2) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StringStorage stringStorage = new StringStorage(string, string2);
        StringInput stringInput = new StringInput(stringStorage);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(string2);
        String string3 = iEditorDescriptor != null ? iEditorDescriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
        try {
            if (iWorkbenchPage != null) {
                iWorkbenchPage.openEditor((IEditorInput)stringInput, string3);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    public static Table createResourceHistoryTable(Composite composite) {
        int n = 101124;
        Table table = new Table(composite, n);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384, 0);
        tableColumn.setResizable(true);
        tableColumn.setText(Messages.getString("history.revision"));
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(table, 16384, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(Messages.getString("history.date"));
        tableColumn.setWidth(175);
        tableColumn = new TableColumn(table, 16384, 2);
        tableColumn.setResizable(true);
        tableColumn.setText(Messages.getString("history.author"));
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(table, 0x1000000, 3);
        tableColumn.setResizable(true);
        tableColumn.setText(Messages.getString("history.comment"));
        tableColumn.setWidth(350);
        return table;
    }

    public boolean authenticateForServer(String string, IWebDavClient iWebDavClient) throws Exception {
        AuthPromptResults authPromptResults = this.promptForAuthentication(string);
        if (authPromptResults != null) {
            if (authPromptResults.wasSaved()) {
                Platform.addAuthorizationInfo((URL)new URL(string), (String)"", (String)"basic", authPromptResults.getAuthInfo());
            } else {
                WebDavSessionAuthenticator webDavSessionAuthenticator = new WebDavSessionAuthenticator();
                webDavSessionAuthenticator.addAuthenticationInfo(new URL(string), "", "basic", authPromptResults.getAuthInfo());
                iWebDavClient.setSessionAuthenticator(webDavSessionAuthenticator);
            }
            return true;
        }
        return false;
    }

    public void updateAuthentication(String string, String string2, String string3, boolean bl) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", string2);
        hashMap.put("password", string3);
        URL uRL = new URL(string);
        IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(string);
        if (iWebDavClient == null) {
            iWebDavClient = WebDavClientFactory.createClient(uRL);
            WebDavServerCache.cacheWebDavClient(string, iWebDavClient);
        }
        if (bl) {
            Platform.flushAuthorizationInfo((URL)uRL, (String)"", (String)"basic");
            Platform.addAuthorizationInfo((URL)uRL, (String)"", (String)"basic", hashMap);
        } else {
            WebDavSessionAuthenticator webDavSessionAuthenticator = new WebDavSessionAuthenticator();
            webDavSessionAuthenticator.addAuthenticationInfo(new URL(string), "", "basic", hashMap);
            iWebDavClient.setSessionAuthenticator(webDavSessionAuthenticator);
        }
    }

    public static void reportAuthenticationFailure() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                Shell shell = display.getActiveShell();
                MessageDialog.openError((Shell)shell, (String)Messages.getString("login.failure.dialog.caption"), (String)Messages.getString("login.failure.dialog.message"));
            }
        });
    }

    public AuthPromptResults promptForAuthentication(String string) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        AuthPromptRunnable authPromptRunnable = new AuthPromptRunnable(string);
        display.syncExec((Runnable)authPromptRunnable);
        return authPromptRunnable.getResults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthPromptResults {
        private Map<String, String> info;
        private boolean saved;

        public AuthPromptResults(Map<String, String> map, boolean bl) {
            this.info = map;
            this.saved = bl;
        }

        public Map<String, String> getAuthInfo() {
            return this.info;
        }

        public boolean wasSaved() {
            return this.saved;
        }
    }

    class AuthPromptRunnable
    implements Runnable {
        AuthPromptResults res = null;
        private String server;

        public AuthPromptRunnable(String string) {
            this.server = string;
        }

        public void run() {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            AuthenticationPromptDialog authenticationPromptDialog = new AuthenticationPromptDialog(shell, this.server);
            if (authenticationPromptDialog.open() == 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("username", authenticationPromptDialog.getUserName());
                hashMap.put("password", authenticationPromptDialog.getPassword());
                this.res = new AuthPromptResults(hashMap, authenticationPromptDialog.saveAuthenInfo());
            }
        }

        public AuthPromptResults getResults() {
            return this.res;
        }
    }
}

