/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamProcessingUtils {
    private static String DAV_NS = "DAV:";

    public static String getStreamContents(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static Map<String, ResourceProperties> parseListing(String string, InputStream inputStream) throws Exception {
        HashMap<String, ResourceProperties> hashMap = new HashMap<String, ResourceProperties>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        NodeList nodeList = document.getElementsByTagNameNS(DAV_NS, "response");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            NodeList nodeList2 = element.getElementsByTagNameNS(DAV_NS, "href");
            assert (nodeList2.getLength() == 1);
            String string2 = StreamProcessingUtils.extractOverlap(string, URLDecoder.decode(nodeList2.item(0).getTextContent(), "UTF-8"));
            if (string2.trim().length() > 0) {
                ResourceProperties resourceProperties = new ResourceProperties();
                NodeList nodeList3 = element.getElementsByTagNameNS(DAV_NS, "resourcetype");
                assert (nodeList3.getLength() == 1);
                NodeList nodeList4 = ((Element)nodeList3.item(0)).getElementsByTagNameNS(DAV_NS, "collection");
                assert (nodeList4.getLength() < 2);
                if (nodeList4.getLength() == 1) {
                    resourceProperties.setDirectory(true);
                }
                if ((nodeList3 = element.getElementsByTagNameNS(DAV_NS, "creationdate")).getLength() > 0) {
                    resourceProperties.setCreationDate(nodeList3.item(0).getTextContent());
                }
                if ((nodeList3 = element.getElementsByTagNameNS(DAV_NS, "getlastmodified")).getLength() > 0) {
                    resourceProperties.setLastModifiedDate(nodeList3.item(0).getTextContent());
                }
                String string3 = string.trim().endsWith("/") ? string.trim() : String.valueOf(string.trim()) + "/";
                resourceProperties.setBase(string3);
                hashMap.put(string2, resourceProperties);
            }
            ++n;
        }
        return hashMap;
    }

    private static String extractOverlap(String string, String string2) {
        String string3 = null;
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        while (n2 < string2.length() && !bl) {
            n = string.lastIndexOf(string2.substring(0, n2));
            if (n == -1) {
                string3 = string2.substring(n2 - 1);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            string3 = "";
        }
        if (string3.startsWith("/") && string3.length() > 1) {
            string3 = string3.substring(1);
        }
        return string3;
    }
}

