/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils.webdav;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.RemoteDAVClient;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpClient;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.webdav.DebugHttpClient;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.StreamProcessingUtils;
import org.guvnor.tools.utils.webdav.WebDavAuthenticator;
import org.guvnor.tools.utils.webdav.WebDavException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavClient
implements IWebDavClient {
    private RemoteDAVClient client;
    private WebDavAuthenticator platformAuthenticator;

    WebDavClient(URL uRL) {
        DebugHttpClient debugHttpClient = null;
        debugHttpClient = Activator.getDefault().useDebugHttpClient() ? new DebugHttpClient() : new HttpClient();
        this.platformAuthenticator = new WebDavAuthenticator(uRL);
        debugHttpClient.setAuthenticator(this.platformAuthenticator);
        this.client = new RemoteDAVClient(new WebDAVFactory(), (HttpClient)debugHttpClient);
    }

    @Override
    public void setSessionAuthenticator(IAuthenticator iAuthenticator) {
        if (iAuthenticator != null) {
            this.client.getHttpClient().setAuthenticator(iAuthenticator);
        } else {
            this.client.getHttpClient().setAuthenticator((IAuthenticator)this.platformAuthenticator);
        }
    }

    @Override
    public RemoteDAVClient getClient() {
        return this.client;
    }

    @Override
    public IContext createContext() {
        IContext iContext = WebDAVFactory.contextFactory.newContext();
        iContext.put("USER-AGENT", "guvnor");
        return iContext;
    }

    @Override
    public Map<String, ResourceProperties> listDirectory(String string) throws Exception {
        IResponse iResponse = null;
        try {
            IContext iContext = this.createContext();
            iContext.put("Depth", "1");
            ILocator iLocator = WebDAVFactory.locatorFactory.newLocator(string);
            iResponse = this.client.propfind(iLocator, iContext, null);
            if (iResponse.getStatusCode() != 207) {
                throw new WebDavException(iResponse);
            }
            Map<String, ResourceProperties> map = StreamProcessingUtils.parseListing(string, iResponse.getInputStream());
            this.addGuvnorResourceProperties(map, string);
            Map<String, ResourceProperties> map2 = map;
            return map2;
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    private void addGuvnorResourceProperties(Map<String, ResourceProperties> map, String string) throws Exception {
        IResponse iResponse = null;
        try {
            String string2 = this.changeToAPICall(string);
            Properties properties = new Properties();
            iResponse = this.getResourceInputStream(string2);
            properties.load(iResponse.getInputStream());
            iResponse.getInputStream();
            for (String string3 : map.keySet()) {
                String string4 = properties.getProperty(string3);
                if (string4 == null) continue;
                ResourceProperties resourceProperties = map.get(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                resourceProperties.setLastModifiedDate(string5);
                resourceProperties.setRevision(string6);
            }
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    @Override
    public ResourceProperties queryProperties(String string) throws Exception {
        IResponse iResponse = null;
        try {
            IContext iContext = this.createContext();
            iContext.put("Depth", "1");
            ILocator iLocator = WebDAVFactory.locatorFactory.newLocator(string);
            iResponse = this.client.propfind(iLocator, iContext, null);
            if (iResponse.getStatusCode() != 207 && iResponse.getStatusCode() != 200) {
                throw new WebDavException(iResponse);
            }
            Map<String, ResourceProperties> map = StreamProcessingUtils.parseListing("", iResponse.getInputStream());
            if (map.keySet().size() != 1) {
                throw new Exception(String.valueOf(map.keySet().size()) + " entries found for " + string);
            }
            String string2 = map.keySet().iterator().next();
            ResourceProperties resourceProperties = map.get(string2);
            String string3 = new Path(string2).lastSegment();
            this.addGuvnorResourceProperties(resourceProperties, string3, string);
            ResourceProperties resourceProperties2 = resourceProperties;
            return resourceProperties2;
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    private void addGuvnorResourceProperties(ResourceProperties resourceProperties, String string, String string2) throws Exception {
        if (resourceProperties == null) {
            return;
        }
        IResponse iResponse = null;
        try {
            String string3 = string2.substring(0, string2.lastIndexOf(47));
            String string4 = this.changeToAPICall(string3);
            Properties properties = new Properties();
            iResponse = this.getResourceInputStream(string4);
            properties.load(iResponse.getInputStream());
            String string5 = properties.getProperty(string);
            if (string5 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                resourceProperties.setLastModifiedDate(string6);
                resourceProperties.setRevision(string7);
            } else {
                Exception exception = new Exception("Failed to get Guvnor properties for " + string);
                Activator.getDefault().writeLog(2, exception.getMessage(), exception);
            }
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    @Override
    public String getResourceContents(String string) throws Exception {
        IResponse iResponse = null;
        try {
            iResponse = this.getResourceInputStream(string);
            String string2 = StreamProcessingUtils.getStreamContents(iResponse.getInputStream());
            return string2;
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    @Override
    public String getResourceVersionContents(String string, String string2) throws Exception {
        String string3 = String.valueOf(this.changeToAPICall(string)) + "?version=" + string2;
        return this.getResourceContents(string3);
    }

    @Override
    public IResponse getResourceInputStream(String string) throws Exception {
        ILocator iLocator = WebDAVFactory.locatorFactory.newLocator(string);
        IResponse iResponse = this.client.get(iLocator, this.createContext());
        if (iResponse.getStatusCode() != 200) {
            throw new WebDavException(iResponse);
        }
        return iResponse;
    }

    @Override
    public IResponse getResourceVersionInputStream(String string, String string2) throws Exception {
        String string3 = String.valueOf(this.changeToAPICall(string)) + "?version=" + string2;
        return this.getResourceInputStream(string3);
    }

    @Override
    public boolean createResource(String string, InputStream inputStream) throws Exception {
        return this.createResource(string, inputStream, true);
    }

    @Override
    public boolean createResource(String string, InputStream inputStream, boolean bl) throws Exception {
        boolean bl2;
        block9: {
            bl2 = true;
            if (!bl) {
                try {
                    if (this.queryProperties(string) != null) {
                        bl2 = false;
                    }
                }
                catch (WebDavException webDavException) {
                    if (webDavException.getErrorCode() == 404) break block9;
                    throw webDavException;
                }
            }
        }
        IResponse iResponse = null;
        try {
            ILocator iLocator;
            if (bl2 && (iResponse = this.client.put(iLocator = WebDAVFactory.locatorFactory.newLocator(string), this.createContext(), inputStream)).getStatusCode() != 200 && iResponse.getStatusCode() != 201) {
                throw new WebDavException(iResponse);
            }
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
        return bl2;
    }

    @Override
    public void putResource(String string, InputStream inputStream) throws Exception {
        IResponse iResponse = null;
        try {
            ILocator iLocator = WebDAVFactory.locatorFactory.newLocator(string);
            iResponse = this.client.put(iLocator, this.createContext(), inputStream);
            if (iResponse.getStatusCode() != 200 && iResponse.getStatusCode() != 204 && iResponse.getStatusCode() != 201) {
                throw new WebDavException(iResponse);
            }
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    @Override
    public IResponse getResourceVersions(String string) throws Exception {
        String string2 = String.valueOf(this.changeToAPICall(string)) + "?version=all";
        return this.getResourceInputStream(string2);
    }

    @Override
    public void deleteResource(String string) throws Exception {
        IResponse iResponse = null;
        try {
            ILocator iLocator = WebDAVFactory.locatorFactory.newLocator(string);
            iResponse = this.client.delete(iLocator, this.createContext());
            if (iResponse.getStatusCode() != 204 && iResponse.getStatusCode() != 200) {
                throw new WebDavException(iResponse);
            }
        }
        finally {
            if (iResponse != null) {
                iResponse.close();
            }
        }
    }

    private String changeToAPICall(String string) {
        return string.replaceFirst("/webdav/", "/api/");
    }
}

