/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorLocationManager;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;
import org.guvnor.tools.wizards.NewRepLocationWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action deleteRepositoryLocAction;
    private Action addRepositoryLocAction;
    private Action doubleClickAction;
    private Action refreshAction;

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        Activator.getLocationManager().addRepositorySetListener(new GuvnorLocationManager.IRepositorySetListener(){

            @Override
            public void repositorySetChanged(int n, List<GuvnorRepository> list) {
                RepositoryView.this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
            }
        });
        super.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.addDragDropSupport();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void addDragDropSupport() {
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDragSupport(1, transferArray, new DragSourceListener(){
            private TreeObject[] target;

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                this.target = null;
                dragSourceEvent.doit = true;
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (this.target == null) {
                    return;
                }
                try {
                    List list = RepositoryView.this.prepareFileTransfer(this.target);
                    String[] stringArray = new String[list.size()];
                    list.toArray(stringArray);
                    dragSourceEvent.data = stringArray;
                }
                catch (Exception exception) {
                    Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
                }
            }

            public void dragStart(DragSourceEvent dragSourceEvent) {
                ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
                ISelection iSelection = RepositoryView.this.viewer.getSelection();
                Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof TreeObject && ((TreeObject)objectArray[n]).getNodeType() == TreeObject.Type.RESOURCE) {
                        arrayList.add((TreeObject)objectArray[n]);
                    }
                    ++n;
                }
                if (arrayList.size() > 0) {
                    dragSourceEvent.doit = true;
                    this.target = new TreeObject[arrayList.size()];
                    arrayList.toArray(this.target);
                } else {
                    dragSourceEvent.doit = false;
                }
            }
        });
        this.viewer.addDropSupport(3, transferArray, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private TreeParent targetNode;

            public boolean performDrop(Object object) {
                if (this.targetNode == null) {
                    return false;
                }
                String[] stringArray = (String[])object;
                String[] stringArray2 = RepositoryView.this.processDrop(this.targetNode, stringArray);
                if (stringArray2.length != 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    while (n < stringArray2.length) {
                        stringBuilder.append(stringArray2[n]);
                        stringBuilder.append("\r\n");
                        ++n;
                    }
                    Activator.getDefault().displayError(4, stringBuilder.toString(), new Exception(), true);
                }
                if (stringArray.length != stringArray2.length) {
                    PlatformUtils.updateDecoration();
                    PlatformUtils.refreshRepositoryView();
                }
                return stringArray.length != stringArray2.length;
            }

            public boolean validateDrop(Object object, int n, TransferData transferData) {
                if (object == null || !(object instanceof TreeParent)) {
                    this.targetNode = null;
                    return false;
                }
                this.targetNode = (TreeParent)object;
                return true;
            }
        });
    }

    private String[] processDrop(TreeParent treeParent, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                IFile iFile = PlatformUtils.getResourceFromFSPath(stringArray[n]);
                if (iFile != null) {
                    try {
                        GuvnorMetadataProps guvnorMetadataProps = GuvnorMetadataUtils.getGuvnorMetadata((IResource)iFile);
                        if (guvnorMetadataProps == null) {
                            boolean bl = GuvnorMetadataUtils.addResourceToGuvnor(treeParent.getGuvnorRepository().getLocation(), treeParent.getFullPath(), iFile);
                            if (!bl) {
                                arrayList.add(MessageFormat.format(Messages.getString("add.failure"), stringArray[n], treeParent.getFullPath()));
                            }
                            break block9;
                        }
                        String string = String.valueOf(treeParent.getFullPath()) + iFile.getName();
                        if (string.equals(guvnorMetadataProps.getFullpath())) {
                            if (!GuvnorMetadataUtils.isGuvnorResourceCurrent((IResource)iFile)) {
                                GuvnorMetadataUtils.commitFileChanges(iFile);
                            }
                            break block9;
                        }
                        arrayList.add(MessageFormat.format(Messages.getString("already.guvnor.as"), stringArray[n], guvnorMetadataProps.getFullpath()));
                    }
                    catch (Exception exception) {
                        Activator.getDefault().writeLog(4, exception.getMessage(), exception);
                    }
                } else {
                    Activator.getDefault().writeLog(2, "Could not resolve: " + stringArray[n], new Exception());
                }
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private List<String> prepareFileTransfer(TreeObject[] treeObjectArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < treeObjectArray.length) {
            String string = this.getResourceContents(treeObjectArray[n]);
            Path path = new Path(String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + "t" + String.valueOf(System.currentTimeMillis()));
            if (!path.toFile().mkdir()) {
                throw new Exception("Could not create directory " + path.toOSString());
            }
            path.toFile().deleteOnExit();
            File file = new File(path + File.separator + treeObjectArray[n].getName());
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
            arrayList.add(file.getAbsolutePath());
            IPath iPath = GuvnorMetadataUtils.createGuvnorMetadataLocation(path.toOSString());
            iPath.toFile().deleteOnExit();
            File file2 = GuvnorMetadataUtils.getGuvnorMetadataFile(iPath.toOSString(), treeObjectArray[n].getName());
            file2.deleteOnExit();
            GuvnorMetadataUtils.writeGuvnorMetadataProps(file2, this.getGuvnorMetadataProps(treeObjectArray[n]));
            arrayList.add(file2.getAbsolutePath());
            Thread.sleep(1L, 0);
            ++n;
        }
        return arrayList;
    }

    private GuvnorMetadataProps getGuvnorMetadataProps(TreeObject treeObject) throws Exception {
        GuvnorRepository guvnorRepository = treeObject.getGuvnorRepository();
        IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(guvnorRepository.getLocation());
        if (iWebDavClient == null) {
            iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorRepository.getLocation()));
            WebDavServerCache.cacheWebDavClient(guvnorRepository.getLocation(), iWebDavClient);
        }
        ResourceProperties resourceProperties = iWebDavClient.queryProperties(treeObject.getFullPath());
        return new GuvnorMetadataProps(treeObject.getName(), treeObject.getGuvnorRepository().getLocation(), treeObject.getFullPath(), resourceProperties.getLastModifiedDate(), resourceProperties.getRevision());
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                RepositoryView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.deleteRepositoryLocAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.addRepositoryLocAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.refreshAction);
    }

    private boolean shouldAddDeleteAction() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection == null) {
            return false;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof TreeParent) {
            return ((TreeParent)object).getNodeType() == TreeObject.Type.REPOSITORY;
        }
        return false;
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        if (this.shouldAddDeleteAction()) {
            iMenuManager.add((IAction)this.deleteRepositoryLocAction);
        }
        iMenuManager.add((IAction)this.refreshAction);
        this.drillDownAdapter.addNavigationActions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.deleteRepositoryLocAction);
        iToolBarManager.add((IAction)this.addRepositoryLocAction);
        iToolBarManager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(iToolBarManager);
    }

    private void makeActions() {
        this.deleteRepositoryLocAction = new Action(){

            public void run() {
                ISelection iSelection = RepositoryView.this.viewer.getSelection();
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (object instanceof TreeParent) {
                    GuvnorRepository guvnorRepository = ((TreeParent)object).getGuvnorRepository();
                    if (MessageDialog.openConfirm((Shell)RepositoryView.this.getSite().getShell(), (String)Messages.getString("remove.rep.dialog.caption"), (String)MessageFormat.format(Messages.getString("remove.rep.dialog.msg"), guvnorRepository.getLocation()))) {
                        Activator.getLocationManager().removeRepository(guvnorRepository.getLocation());
                    }
                }
            }
        };
        this.deleteRepositoryLocAction.setText(Messages.getString("action.delete.rep"));
        this.deleteRepositoryLocAction.setToolTipText(Messages.getString("action.delete.rep.desc"));
        this.deleteRepositoryLocAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.addRepositoryLocAction = new Action(){

            public void run() {
                NewRepLocationWizard newRepLocationWizard = new NewRepLocationWizard();
                newRepLocationWizard.init(Activator.getDefault().getWorkbench(), null);
                WizardDialog wizardDialog = new WizardDialog(RepositoryView.this.getSite().getShell(), (IWizard)newRepLocationWizard);
                wizardDialog.create();
                wizardDialog.open();
            }
        };
        this.addRepositoryLocAction.setText(Messages.getString("action.add.rep"));
        this.addRepositoryLocAction.setToolTipText(Messages.getString("action.add.rep.desc"));
        this.addRepositoryLocAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection iSelection = RepositoryView.this.viewer.getSelection();
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (object instanceof TreeObject) {
                    RepositoryView.this.doubleClick((TreeObject)object);
                }
            }
        };
        this.refreshAction = new Action(){

            public void run() {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = RepositoryView.this.viewer.getSelection();
                if (iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty()) {
                    RepositoryView.this.viewer.refresh(iStructuredSelection.getFirstElement());
                }
            }
        };
        this.refreshAction.setText(Messages.getString("action.refresh.rep"));
        this.refreshAction.setToolTipText(Messages.getString("action.refresh.rep.desc"));
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                RepositoryView.this.doubleClickAction.run();
            }
        });
    }

    private void doubleClick(TreeObject treeObject) {
        if (treeObject.getNodeType() == TreeObject.Type.PACKAGE || treeObject.getNodeType() == TreeObject.Type.REPOSITORY) {
            if (this.viewer.getExpandedState((Object)treeObject)) {
                this.viewer.collapseToLevel((Object)treeObject, 1);
            } else {
                this.viewer.expandToLevel((Object)treeObject, 1);
            }
        }
        if (treeObject.getNodeType() == TreeObject.Type.RESOURCE) {
            try {
                String string = this.getResourceContents(treeObject);
                PlatformUtils.openEditor(string, treeObject.getName());
            }
            catch (Exception exception) {
                Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
            }
        }
    }

    private String getResourceContents(TreeObject treeObject) throws Exception {
        GuvnorRepository guvnorRepository = treeObject.getGuvnorRepository();
        IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(guvnorRepository.getLocation());
        if (iWebDavClient == null) {
            iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorRepository.getLocation()));
            WebDavServerCache.cacheWebDavClient(guvnorRepository.getLocation(), iWebDavClient);
        }
        String string = iWebDavClient.getResourceContents(treeObject.getFullPath());
        return string;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

