/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.ResourceHistorySorter;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.ResourceHistoryContentProvider;
import org.guvnor.tools.views.ResourceHistoryLabelProvider;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class ResourceHistoryView
extends ViewPart {
    private Label repositoryLabel;
    private Label resourceLabel;
    private TableViewer viewer;
    private Action showVersionAction;

    public void createPartControl(Composite composite) {
        Composite composite2 = PlatformUtils.createComposite(composite, 1);
        this.repositoryLabel = new Label(composite2, 0);
        this.repositoryLabel.setText(Messages.getString("history.rep.label"));
        this.repositoryLabel.setLayoutData((Object)new GridData(768));
        this.resourceLabel = new Label(composite2, 0);
        this.resourceLabel.setText(MessageFormat.format(Messages.getString("history.resource.label"), ""));
        this.resourceLabel.setLayoutData((Object)new GridData(768));
        this.viewer = new TableViewer(PlatformUtils.createResourceHistoryTable(composite2));
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ResourceHistoryContentProvider(new ResourceHistoryEntry[0]));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceHistoryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ResourceHistorySorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ResourceHistoryView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showVersionAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ResourceHistoryView.this.showResourceVersionContents();
            }
        });
    }

    private void makeActions() {
        this.showVersionAction = new Action(){

            public void run() {
                ResourceHistoryView.this.showResourceVersionContents();
            }
        };
        this.showVersionAction.setText(Messages.getString("action.open"));
        this.showVersionAction.setToolTipText(Messages.getString("action.open.desc"));
        this.showVersionAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    private void showResourceVersionContents() {
        String string = this.repositoryLabel.getToolTipText();
        String string2 = this.resourceLabel.getToolTipText();
        ISelection iSelection = this.viewer.getSelection();
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof ResourceHistoryEntry) {
            ResourceHistoryEntry resourceHistoryEntry = (ResourceHistoryEntry)object;
            try {
                int n;
                String string3;
                block8: {
                    IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(string);
                    if (iWebDavClient == null) {
                        iWebDavClient = WebDavClientFactory.createClient(new URL(string));
                        WebDavServerCache.cacheWebDavClient(string, iWebDavClient);
                    }
                    string3 = null;
                    try {
                        string3 = iWebDavClient.getResourceVersionContents(string2, resourceHistoryEntry.getRevision());
                    }
                    catch (WebDavException webDavException) {
                        if (webDavException.getErrorCode() != 401) {
                            throw webDavException;
                        }
                        n = PlatformUtils.getInstance().authenticateForServer(string, iWebDavClient);
                        if (n == 0) break block8;
                        string3 = iWebDavClient.getResourceVersionContents(string2, resourceHistoryEntry.getRevision());
                    }
                }
                if (string3 != null) {
                    String string4 = null;
                    n = string2.lastIndexOf("/");
                    string4 = n != -1 && n + 1 < string2.length() ? string2.substring(n + 1) : string2;
                    PlatformUtils.openEditor(string3, String.valueOf(string4) + ", " + resourceHistoryEntry.getRevision());
                }
            }
            catch (Exception exception) {
                Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setEntries(String string, String string2, Properties properties) {
        this.repositoryLabel.setText(String.valueOf(Messages.getString("history.rep.label")) + string);
        this.repositoryLabel.setToolTipText(string);
        this.resourceLabel.setText(MessageFormat.format(Messages.getString("history.resource.label"), string2.substring(string.length())));
        this.resourceLabel.setToolTipText(string2);
        ResourceHistoryEntry[] resourceHistoryEntryArray = GuvnorMetadataUtils.parseHistoryProperties(properties);
        this.viewer.setContentProvider((IContentProvider)new ResourceHistoryContentProvider(resourceHistoryEntryArray));
        this.viewer.setInput((Object)this.getViewSite());
    }
}

