/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views.model;

import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.TreeObject;

public class TreeParent
extends TreeObject
implements IDeferredWorkbenchAdapter {
    private ArrayList<TreeObject> children = new ArrayList();

    public TreeParent(String string, TreeObject.Type type) {
        super(string, type);
    }

    public void addChild(TreeObject treeObject) {
        this.children.add(treeObject);
        treeObject.setParent(this);
    }

    public void removeChild(TreeObject treeObject) {
        this.children.remove(treeObject);
        treeObject.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        if (!(object instanceof TreeParent)) {
            return;
        }
        TreeParent treeParent = (TreeParent)object;
        if (treeParent.getNodeType() == TreeObject.Type.NONE) {
            List<GuvnorRepository> list = Activator.getLocationManager().getRepositories();
            iProgressMonitor.beginTask(Messages.getString("pending"), list.size());
            int n = 0;
            while (n < list.size()) {
                TreeParent treeParent2 = new TreeParent(list.get(n).getLocation(), TreeObject.Type.REPOSITORY);
                treeParent2.setParent(treeParent);
                treeParent2.setGuvnorRepository(list.get(n));
                ResourceProperties resourceProperties = new ResourceProperties();
                resourceProperties.setBase("");
                treeParent2.setResourceProps(resourceProperties);
                iElementCollector.add((Object)treeParent2, iProgressMonitor);
                iProgressMonitor.worked(1);
                ++n;
            }
            iProgressMonitor.done();
        }
        if (treeParent.getNodeType() == TreeObject.Type.REPOSITORY || treeParent.getNodeType() == TreeObject.Type.PACKAGE) {
            this.listDirectory(treeParent, iElementCollector, iProgressMonitor);
        }
    }

    public void listDirectory(TreeParent treeParent, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(Messages.getString("pending"), 1);
        iProgressMonitor.worked(1);
        GuvnorRepository guvnorRepository = treeParent.getGuvnorRepository();
        try {
            Map<String, ResourceProperties> map;
            block14: {
                IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(guvnorRepository.getLocation());
                if (iWebDavClient == null) {
                    iWebDavClient = WebDavClientFactory.createClient(new URL(guvnorRepository.getLocation()));
                    WebDavServerCache.cacheWebDavClient(guvnorRepository.getLocation(), iWebDavClient);
                }
                map = null;
                try {
                    map = iWebDavClient.listDirectory(treeParent.getFullPath());
                }
                catch (WebDavException webDavException) {
                    if (webDavException.getErrorCode() != 401) {
                        throw webDavException;
                    }
                    boolean bl = PlatformUtils.getInstance().authenticateForServer(treeParent.getGuvnorRepository().getLocation(), iWebDavClient);
                    if (!bl) break block14;
                    map = iWebDavClient.listDirectory(treeParent.getFullPath());
                }
            }
            if (map != null) {
                for (String string : map.keySet()) {
                    ResourceProperties resourceProperties = map.get(string);
                    TreeObject treeObject = null;
                    treeObject = resourceProperties.isDirectory() ? new TreeParent(string, TreeObject.Type.PACKAGE) : new TreeObject(string, TreeObject.Type.RESOURCE);
                    treeObject.setGuvnorRepository(guvnorRepository);
                    treeObject.setResourceProps(resourceProperties);
                    treeParent.addChild(treeObject);
                    iElementCollector.add((Object)treeObject, iProgressMonitor);
                }
            }
            iProgressMonitor.worked(1);
        }
        catch (WebDavException webDavException) {
            if (webDavException.getErrorCode() == 401) {
                PlatformUtils.reportAuthenticationFailure();
            } else if (webDavException.getErrorCode() == 501) {
                Activator.getDefault().displayMessage(4, Messages.getString("rep.connect.fail"));
            } else {
                Activator.getDefault().displayError(4, webDavException.getMessage(), webDavException, true);
            }
        }
        catch (ConnectException connectException) {
            Activator.getDefault().displayMessage(4, Messages.getString("rep.connect.fail"));
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object object) {
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        return object.toString();
    }

    public Object getParent(Object object) {
        if (object instanceof TreeObject) {
            return ((TreeObject)object).getParent();
        }
        return null;
    }
}

