/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views.model;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.guvnor.tools.Messages;
import org.guvnor.tools.views.model.TreeObject;

public class TreePropertyProvider
implements IPropertySource {
    private TreeObject node;

    public TreePropertyProvider(TreeObject treeObject) {
        this.node = treeObject;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", Messages.getString("prop.name")), new TextPropertyDescriptor((Object)"location", Messages.getString("prop.location")), new TextPropertyDescriptor((Object)"type", Messages.getString("prop.type")), new TextPropertyDescriptor((Object)"creationdate", Messages.getString("prop.created")), new TextPropertyDescriptor((Object)"lastmodified", Messages.getString("prop.lastmod")), new TextPropertyDescriptor((Object)"revision", Messages.getString("prop.revision"))};
    }

    public Object getPropertyValue(Object object) {
        if (object.equals("name")) {
            return this.node.getName();
        }
        if (object.equals("location")) {
            return this.node.getFullPath().substring(this.node.getGuvnorRepository().getLocation().length());
        }
        if (object.equals("type")) {
            if (this.node.getNodeType() == TreeObject.Type.REPOSITORY) {
                return Messages.getString("prop.rep.value");
            }
            if (this.node.getNodeType() == TreeObject.Type.PACKAGE) {
                return Messages.getString("prop.dir.value");
            }
            if (this.node.getNodeType() == TreeObject.Type.RESOURCE) {
                return Messages.getString("prop.file.value");
            }
        }
        if (object.equals("creationdate")) {
            return this.node.getResourceProps().getCreationDate();
        }
        if (object.equals("lastmodified")) {
            return this.node.getResourceProps().getLastModifiedDate();
        }
        if (object.equals("revision")) {
            return this.node.getResourceProps().getRevision();
        }
        return "";
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }
}

