/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.GuvnorMainConfigPage;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.SelectGuvnorRepPage;
import org.guvnor.tools.wizards.SelectGuvnorResourcesPage;
import org.guvnor.tools.wizards.SelectLocalTargetPage;

public class CheckoutWizard
extends Wizard
implements INewWizard,
IGuvnorWizard {
    private GuvnorMainConfigPage mainConfigPage;
    private SelectGuvnorRepPage selectRepPage;
    private SelectGuvnorResourcesPage selectResPage;
    private SelectLocalTargetPage selectLocalTargetPage;
    private GuvWizardModel model = new GuvWizardModel();

    public GuvWizardModel getModel() {
        return this.model;
    }

    public void addPages() {
        this.selectRepPage = new SelectGuvnorRepPage("select_rep_page", Messages.getString("select.guvnor.rep"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectRepPage.setDescription(Messages.getString("select.guvnor.rep.desc"));
        super.addPage((IWizardPage)this.selectRepPage);
        this.mainConfigPage = new GuvnorMainConfigPage("config_page", Messages.getString("new.guvnor.rep"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.mainConfigPage.setDescription(Messages.getString("new.guvnor.rep.desc"));
        super.addPage((IWizardPage)this.mainConfigPage);
        this.selectResPage = new SelectGuvnorResourcesPage("select_res_page", Messages.getString("select.resources"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectResPage.setDescription(Messages.getString("select.resources.desc"));
        super.addPage((IWizardPage)this.selectResPage);
        this.selectLocalTargetPage = new SelectLocalTargetPage("local_target_page", Messages.getString("select.target.loc"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectLocalTargetPage.setDescription(Messages.getString("select.target.loc.desc"));
        super.addPage((IWizardPage)this.selectLocalTargetPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage.getName().equals("select_rep_page")) {
            if (this.model.shouldCreateNewRep()) {
                return this.mainConfigPage;
            }
            return this.selectResPage;
        }
        if (iWizardPage.getName().equals("config_page")) {
            return this.selectResPage;
        }
        if (iWizardPage.getName().equals("select_res_page")) {
            return this.selectLocalTargetPage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            IWebDavClient iWebDavClient = WebDavServerCache.getWebDavClient(this.model.getRepLocation());
            assert (iWebDavClient != null);
            for (String string : this.model.getResources()) {
                ResourceProperties resourceProperties = iWebDavClient.queryProperties(string);
                if (resourceProperties == null) {
                    throw new Exception("Null resource properties for " + string);
                }
                String string2 = iWebDavClient.getResourceContents(string);
                Path path = new Path(this.model.getTargetLocation());
                IWorkspaceRoot iWorkspaceRoot = Activator.getDefault().getWorkspace().getRoot();
                IFile iFile = iWorkspaceRoot.getFile(path.append(string.substring(string.lastIndexOf(47))));
                if (iFile.exists()) {
                    iFile = this.resolveNameConflict(iFile);
                }
                if (iFile == null) continue;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(iFile.getCharset()));
                if (iFile.exists()) {
                    iFile.setContents((InputStream)byteArrayInputStream, true, true, null);
                } else {
                    iFile.create((InputStream)byteArrayInputStream, true, null);
                }
                GuvnorMetadataProps guvnorMetadataProps = new GuvnorMetadataProps(iFile.getName(), this.model.getRepLocation(), string, resourceProperties.getLastModifiedDate(), resourceProperties.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(iFile.getFullPath(), guvnorMetadataProps);
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)iFile);
            }
        }
        catch (Exception exception) {
            Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
        }
        return true;
    }

    public IFile resolveNameConflict(IFile iFile) {
        final IWorkspaceRoot iWorkspaceRoot = Activator.getDefault().getWorkspace().getRoot();
        final IPath iPath = iFile.getFullPath().removeLastSegments(1);
        InputDialog inputDialog = new InputDialog(super.getShell(), Messages.getString("name.conflict"), MessageFormat.format(Messages.getString("name.conflict.request"), iFile.getName()), String.valueOf(Messages.getString("copy.of")) + iFile.getName(), new IInputValidator(){

            public String isValid(String string) {
                IFile iFile = iWorkspaceRoot.getFile(iPath.append(string));
                if (iFile == null || !iFile.exists()) {
                    return null;
                }
                return MessageFormat.format(Messages.getString("already.exists"), string);
            }
        });
        if (inputDialog.open() == 0) {
            return iWorkspaceRoot.getFile(iPath.append(inputDialog.getValue()));
        }
        return null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public boolean canFinish() {
        return this.model.getRepLocation() != null && this.model.getTargetLocation() != null && this.model.getResources() != null;
    }
}

