/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.preferences.GuvnorPreferencePage;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;

public class GuvnorMainConfigPage
extends WizardPage {
    private Text serverField;
    private Text portField;
    private Text replocField;
    private Text unField;
    private Text pwField;
    private Button cbSavePassword;
    private boolean saveAuthInfo;
    private Label warningLabel;
    private boolean initialized = false;

    public GuvnorMainConfigPage(String string) {
        super(string);
    }

    public GuvnorMainConfigPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    public void createControl(Composite composite) {
        boolean bl;
        Composite composite2 = PlatformUtils.createComposite(composite, 2);
        new Label(composite2, 0).setText(Messages.getString("mainconfig.guvnor.loc"));
        this.serverField = new Text(composite2, 2052);
        this.serverField.setLayoutData((Object)new GridData(768));
        this.serverField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        this.addDropSupport(this.serverField);
        this.serverField.setFocus();
        new Label(composite2, 0).setText(Messages.getString("mainconfig.port"));
        this.portField = new Text(composite2, 2052);
        this.portField.setLayoutData((Object)new GridData(768));
        this.portField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite2, 0).setText(Messages.getString("mainconfig.rep"));
        this.replocField = new Text(composite2, 2052);
        this.replocField.setLayoutData((Object)new GridData(768));
        this.replocField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite2, 0).setText(Messages.getString("mainconfig.user.name"));
        this.unField = new Text(composite2, 2052);
        this.unField.setLayoutData((Object)new GridData(768));
        this.unField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite2, 0).setText(Messages.getString("mainconfig.password"));
        this.pwField = new Text(composite2, 0x400804);
        this.pwField.setLayoutData((Object)new GridData(768));
        this.pwField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite2, 0).setLayoutData((Object)new GridData(768));
        Composite composite3 = PlatformUtils.createComposite(composite2, 2);
        this.cbSavePassword = new Button(composite3, 32);
        this.cbSavePassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                GuvnorMainConfigPage.this.saveAuthInfo = GuvnorMainConfigPage.this.cbSavePassword.getSelection();
                GuvnorMainConfigPage.this.warningLabel.setEnabled(GuvnorMainConfigPage.this.saveAuthInfo);
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        this.saveAuthInfo = bl = GuvnorPreferencePage.shouldSavePasswords();
        this.cbSavePassword.setSelection(bl);
        new Label(composite3, 0).setText(Messages.getString("mainconfig.save.password"));
        new Label(composite2, 0).setLayoutData((Object)new GridData(768));
        this.warningLabel = new Label(composite2, 64);
        this.warningLabel.setText(Messages.getString("password.warning"));
        this.warningLabel.setEnabled(bl);
        super.setControl((Control)composite2);
    }

    private void addDropSupport(Text text) {
        int n = 17;
        DropTarget dropTarget = new DropTarget((Control)text, n);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transferArray = new Transfer[]{textTransfer};
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                dropTargetEvent.feedback = 9;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                if (textTransfer.isSupportedType(dropTargetEvent.currentDataType)) {
                    GuvnorMainConfigPage.this.parseCandidateUrl((String)dropTargetEvent.data);
                }
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }
        });
    }

    private void parseCandidateUrl(String string) {
        try {
            URL uRL = new URL(string);
            this.serverField.setText(uRL.getHost());
            if (uRL.getPort() != -1) {
                this.portField.setText(String.valueOf(uRL.getPort()));
            }
            this.replocField.setText(uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            Activator.getDefault().writeLog(4, malformedURLException.getMessage(), malformedURLException);
        }
    }

    private void updateModel() {
        URL uRL;
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        try {
            uRL = this.validateUrl();
            guvWizardModel.setRepLocation(uRL.toString());
            guvWizardModel.setUsername(this.unField.getText());
            guvWizardModel.setPassword(this.pwField.getText());
            guvWizardModel.setSaveAuthInfo(this.saveAuthInfo);
            guvWizardModel.setCreateNewRep(true);
        }
        catch (Exception exception) {
            guvWizardModel.setRepLocation(null);
        }
        uRL = super.getWizard().getContainer();
        if (uRL != null) {
            uRL.updateButtons();
        }
    }

    private URL validateUrl() throws Exception {
        if (this.serverField.getText().trim().length() == 0) {
            return null;
        }
        URL uRL = this.testCompleteField();
        if (uRL != null) {
            return uRL;
        }
        String string = null;
        string = this.replocField.getText().trim().length() > 0 ? (this.replocField.getText().startsWith("/") ? this.replocField.getText() : "/" + this.replocField.getText()) : "";
        if (this.portField.getText().trim().length() > 0) {
            int n = Integer.parseInt(this.portField.getText());
            uRL = new URL("http", this.serverField.getText(), n, string);
        } else {
            uRL = new URL("http", this.serverField.getText(), string);
        }
        return uRL;
    }

    private URL testCompleteField() {
        URL uRL = null;
        try {
            uRL = new URL(this.serverField.getText());
            this.parseCandidateUrl(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {}
        return uRL;
    }

    public boolean isPageComplete() {
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        return guvWizardModel.getRepLocation() != null;
    }

    public void setVisible(boolean bl) {
        if (bl && !this.initialized) {
            String string = GuvnorPreferencePage.getGuvnorTemplatePref();
            if (string != null && string.trim().length() > 0) {
                this.parseCandidateUrl(string);
            }
            this.initialized = true;
        }
        super.setVisible(bl);
    }
}

