/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.WizardUtils;

public class SelectGuvnorFolderPage
extends WizardPage {
    private TreeViewer viewer;
    private String previousSelection;

    public SelectGuvnorFolderPage(String string) {
        super(string);
    }

    public SelectGuvnorFolderPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    public void createControl(Composite composite) {
        Composite composite2 = PlatformUtils.createComposite(composite, 1);
        new Label(composite2, 0).setText(Messages.getString("select.folder"));
        this.viewer = new TreeViewer(composite2, 2820);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SelectGuvnorFolderPage.this.updateModel();
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof TreeObject) {
                    TreeObject treeObject = (TreeObject)object2;
                    return treeObject.getFullPath().indexOf("/snapshots/") == -1;
                }
                return true;
            }
        });
        super.setControl((Control)composite2);
    }

    private void handleRepositoryCreation() {
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        if (guvWizardModel.shouldCreateNewRep() && guvWizardModel.getRepLocation() != null) {
            GuvnorRepository guvnorRepository = Activator.getLocationManager().findRepository(guvWizardModel.getRepLocation());
            if (guvnorRepository != null) {
                return;
            }
            try {
                WizardUtils.createGuvnorRepository(guvWizardModel);
            }
            catch (Exception exception) {
                super.setErrorMessage(exception.getMessage());
                Activator.getDefault().writeLog(4, exception.getMessage(), exception);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
            String string = guvWizardModel.getRepLocation();
            assert (string != null);
            if (this.previousSelection != null && !string.equals(this.previousSelection)) {
                this.handleRepositoryCreation();
                RepositoryContentProvider repositoryContentProvider = new RepositoryContentProvider();
                repositoryContentProvider.setRepositorySelection(string);
                this.viewer.setContentProvider((IContentProvider)repositoryContentProvider);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = string;
            } else if (this.previousSelection == null) {
                this.handleRepositoryCreation();
                RepositoryContentProvider repositoryContentProvider = new RepositoryContentProvider();
                repositoryContentProvider.setRepositorySelection(string);
                this.viewer.setContentProvider((IContentProvider)repositoryContentProvider);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = string;
            }
        }
        super.setVisible(bl);
    }

    private void updateModel() {
        if (super.getErrorMessage() != null) {
            super.setErrorMessage(null);
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        if (iStructuredSelection.getFirstElement() instanceof TreeParent) {
            TreeParent treeParent = (TreeParent)iStructuredSelection.getFirstElement();
            if (treeParent.getNodeType() == TreeObject.Type.PACKAGE || treeParent.getNodeType() == TreeObject.Type.REPOSITORY) {
                this.viewer.expandToLevel((Object)treeParent, 1);
                String string = treeParent.getFullPath().endsWith("/") ? treeParent.getFullPath() : String.valueOf(treeParent.getFullPath()) + "/";
                guvWizardModel.setTargetLocation(string);
                super.getWizard().getContainer().updateButtons();
            } else {
                guvWizardModel.setTargetLocation(null);
                super.getWizard().getContainer().updateButtons();
            }
        } else {
            guvWizardModel.setTargetLocation(null);
            super.getWizard().getContainer().updateButtons();
        }
    }
}

