/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.WizardUtils;

public class SelectGuvnorResourcesPage
extends WizardPage {
    private TreeViewer viewer;
    private String previousSelection;
    private Action doubleClickAction;

    public SelectGuvnorResourcesPage(String string) {
        super(string);
    }

    public SelectGuvnorResourcesPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    public void createControl(Composite composite) {
        Composite composite2 = PlatformUtils.createComposite(composite, 1);
        new Label(composite2, 0).setText(Messages.getString("select.resources"));
        this.viewer = new TreeViewer(composite2, 2818);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SelectGuvnorResourcesPage.this.updateModel();
            }
        });
        this.hookDoubleClickAction();
        super.setControl((Control)composite2);
    }

    private void hookDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection iSelection = SelectGuvnorResourcesPage.this.viewer.getSelection();
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (object instanceof TreeObject) {
                    SelectGuvnorResourcesPage.this.doubleClick((TreeObject)object);
                }
            }
        };
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                SelectGuvnorResourcesPage.this.doubleClickAction.run();
            }
        });
    }

    private void doubleClick(TreeObject treeObject) {
        if (treeObject.getNodeType() == TreeObject.Type.PACKAGE || treeObject.getNodeType() == TreeObject.Type.REPOSITORY) {
            if (this.viewer.getExpandedState((Object)treeObject)) {
                this.viewer.collapseToLevel((Object)treeObject, 1);
            } else {
                this.viewer.expandToLevel((Object)treeObject, 1);
            }
        }
    }

    private void handleRepositoryCreation() {
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        if (guvWizardModel.shouldCreateNewRep() && guvWizardModel.getRepLocation() != null) {
            GuvnorRepository guvnorRepository = Activator.getLocationManager().findRepository(guvWizardModel.getRepLocation());
            if (guvnorRepository != null) {
                return;
            }
            try {
                WizardUtils.createGuvnorRepository(guvWizardModel);
            }
            catch (Exception exception) {
                super.setErrorMessage(exception.getMessage());
                Activator.getDefault().displayError(4, exception.getMessage(), exception, true);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
            String string = guvWizardModel.getRepLocation();
            assert (string != null);
            if (this.previousSelection != null && !string.equals(this.previousSelection)) {
                this.handleRepositoryCreation();
                RepositoryContentProvider repositoryContentProvider = new RepositoryContentProvider();
                repositoryContentProvider.setRepositorySelection(string);
                this.viewer.setContentProvider((IContentProvider)repositoryContentProvider);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = string;
            } else if (this.previousSelection == null) {
                this.handleRepositoryCreation();
                RepositoryContentProvider repositoryContentProvider = new RepositoryContentProvider();
                repositoryContentProvider.setRepositorySelection(string);
                this.viewer.setContentProvider((IContentProvider)repositoryContentProvider);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = string;
            }
        }
        super.setVisible(bl);
    }

    private void updateModel() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (!iStructuredSelection.isEmpty()) {
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = iStructuredSelection.toList();
            for (Object object2 : list) {
                if (((TreeObject)object2).getNodeType() != TreeObject.Type.RESOURCE) continue;
                arrayList.add(((TreeObject)object2).getFullPath());
            }
            object2 = ((IGuvnorWizard)super.getWizard()).getModel();
            if (arrayList.size() > 0) {
                ((GuvWizardModel)object2).setResources(arrayList);
            } else {
                ((GuvWizardModel)object2).setResources(null);
            }
        }
        super.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        GuvWizardModel guvWizardModel = ((IGuvnorWizard)super.getWizard()).getModel();
        return guvWizardModel.getResources() != null && guvWizardModel.getResources().size() > 0;
    }
}

