/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.task.preferences;

import org.drools.eclipse.task.Activator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsTaskPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text ipAddressText;
    private Text portText;
    private Text languageText;

    protected Control createContents(Composite composite) {
        this.ipAddressText = this.createText(composite, "IP\u30a2\u30c9\u30ec\u30b9");
        this.portText = this.createText(composite, "\u30dd\u30fc\u30c8");
        this.languageText = this.createText(composite, "\u8a00\u8a9e");
        this.initializeValues();
        return new Composite(composite, 0);
    }

    private Text createText(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        Text text = new Text(composite, 0);
        return text;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.ipAddressText.setText(iPreferenceStore.getDefaultString("ServerIPAddress"));
        this.portText.setText(String.valueOf(iPreferenceStore.getDefaultInt("ServerPort")));
        this.languageText.setText(iPreferenceStore.getDefaultString("Language"));
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.ipAddressText.setText(iPreferenceStore.getString("ServerIPAddress"));
        this.portText.setText(String.valueOf(iPreferenceStore.getInt("ServerPort")));
        this.languageText.setText(iPreferenceStore.getString("Language"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        Activator.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        try {
            Integer n = new Integer(this.portText.getText());
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            iPreferenceStore.setValue("ServerIPAddress", this.ipAddressText.getText());
            iPreferenceStore.setValue("ServerPort", n.intValue());
            iPreferenceStore.setValue("Language", this.languageText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.showMessage("\u30dd\u30fc\u30c8\u3092\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093\u3002\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void showMessage(String string) {
        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)"Task View", (String)string);
    }
}

