/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.task.views;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.eclipse.task.Activator;
import org.drools.eclipse.task.views.BlockingTaskOperationResponseHandler;
import org.drools.eclipse.task.views.BlockingTaskSummaryResponseHandler;
import org.drools.eclipse.task.views.NewTaskDialog;
import org.drools.eclipse.task.views.TimeoutException;
import org.drools.process.workitem.wsht.BlockingAddTaskResponseHandler;
import org.drools.task.Status;
import org.drools.task.User;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.MinaTaskClient;
import org.drools.task.service.TaskClientHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TaskView
extends ViewPart {
    private static final String NAME_COLUMN = "Name";
    private static final String STATUS_COLUMN = "Status";
    private static final String OWNER_COLUMN = "Owner";
    private static final String CREATED_COLUMN = "Created";
    private static final String COMMENT_COLUMN = "Comment";
    private static String[] columnNames = new String[]{"Name", "Status", "Owner", "Created", "Comment"};
    private static Map<Status, String> STATUSSES = new HashMap<Status, String>();
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private String language = "ja-JP";
    private Text userNameText;
    private Table table;
    private TableViewer tableViewer;
    private Action refreshAction;
    private Button claimButton;
    private Button startButton;
    private Button stopButton;
    private Button releaseButton;
    private Button suspendButton;
    private Button resumeButton;
    private Button skipButton;
    private Button completeButton;
    private Button failButton;
    private MinaTaskClient client;

    static {
        STATUSSES.put(Status.Created, "\u4f5c\u6210");
        STATUSSES.put(Status.Completed, "\u7d42\u4e86");
        STATUSSES.put(Status.Error, "\u30a8\u30e9\u30fc");
        STATUSSES.put(Status.Exited, "\u51fa\u529b");
        STATUSSES.put(Status.Failed, "\u5931\u6557");
        STATUSSES.put(Status.InProgress, "\u5b9f\u884c\u4e2d");
        STATUSSES.put(Status.Obsolete, "\u5ec3\u6b62");
        STATUSSES.put(Status.Ready, "\u6e96\u5099\u5b8c\u4e86");
        STATUSSES.put(Status.Reserved, "\u4e88\u7d04");
        STATUSSES.put(Status.Suspended, "\u4e00\u6642\u505c\u6b62");
    }

    public TaskView() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.ipAddress = iPreferenceStore.getString("ServerIPAddress");
        this.port = iPreferenceStore.getInt("ServerPort");
        this.language = iPreferenceStore.getString("Language");
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ServerIPAddress".equals(propertyChangeEvent.getProperty())) {
                    TaskView.this.ipAddress = (String)propertyChangeEvent.getNewValue();
                } else if ("ServerPort".equals(propertyChangeEvent.getProperty())) {
                    TaskView.this.port = (Integer)propertyChangeEvent.getNewValue();
                } else if ("Language".equals(propertyChangeEvent.getProperty())) {
                    TaskView.this.language = (String)propertyChangeEvent.getNewValue();
                }
            }
        });
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(11, false));
        Label label = new Label(composite, 0);
        label.setText("\u30e6\u30fc\u30b6ID");
        this.userNameText = new Text(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.minimumWidth = 120;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 768;
        this.userNameText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 0x1000008);
        button.setText("\u66f4\u65b0");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.refresh();
            }
        });
        Button button2 = new Button(composite, 0x1000008);
        button2.setText("\u4f5c\u6210");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.createTask();
            }
        });
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setInput((Object)this.getViewSite());
        this.createButtons(composite);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void createTable(Composite composite) {
        int n = 101124;
        this.table = new Table(composite, n);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 11;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 16384, 0);
        tableColumn.setText("\u540d\u524d");
        tableColumn.setWidth(300);
        tableColumn = new TableColumn(this.table, 16384, 1);
        tableColumn.setText("\u72b6\u614b");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.table, 16384, 2);
        tableColumn.setText("\u30aa\u30fc\u30ca\u30fc");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.table, 0x1000000, 3);
        tableColumn.setText("\u30b3\u30e1\u30f3\u30c8");
        tableColumn.setWidth(120);
        tableColumn = new TableColumn(this.table, 0x1000000, 3);
        tableColumn.setText("\u4f5c\u6210\u65e5");
        tableColumn.setWidth(120);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
    }

    private void createButtons(Composite composite) {
        this.claimButton = new Button(composite, 0x1000008);
        this.claimButton.setText("\u30af\u30ec\u30fc\u30e0");
        this.claimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.claim();
            }
        });
        this.claimButton.setEnabled(false);
        this.startButton = new Button(composite, 0x1000008);
        this.startButton.setText("\u958b\u59cb");
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.start();
            }
        });
        this.startButton.setEnabled(false);
        this.stopButton = new Button(composite, 0x1000008);
        this.stopButton.setText("\u4e2d\u65ad");
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.stop();
            }
        });
        this.stopButton.setEnabled(false);
        this.releaseButton = new Button(composite, 0x1000008);
        this.releaseButton.setText("\u958b\u653e");
        this.releaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.release();
            }
        });
        this.releaseButton.setEnabled(false);
        this.suspendButton = new Button(composite, 0x1000008);
        this.suspendButton.setText("\u505c\u6b62");
        this.suspendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.suspend();
            }
        });
        this.suspendButton.setEnabled(false);
        this.resumeButton = new Button(composite, 0x1000008);
        this.resumeButton.setText("\u518d\u958b");
        this.resumeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.resume();
            }
        });
        this.resumeButton.setEnabled(false);
        this.skipButton = new Button(composite, 0x1000008);
        this.skipButton.setText("\u30b9\u30ad\u30c3\u30d7");
        this.skipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.skip();
            }
        });
        this.skipButton.setEnabled(false);
        this.completeButton = new Button(composite, 0x1000008);
        this.completeButton.setText("\u5b8c\u4e86");
        this.completeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.complete();
            }
        });
        this.completeButton.setEnabled(false);
        this.failButton = new Button(composite, 0x1000008);
        this.failButton.setText("\u5931\u6557");
        this.failButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.fail();
            }
        });
        this.failButton.setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        this.failButton.setLayoutData((Object)gridData);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                System.out.println(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskView.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        boolean bl = this.table.getSelectionCount() == 1;
        TaskSummary taskSummary = this.getSelectedTask();
        String string = this.getUserId();
        this.claimButton.setEnabled(bl && Status.Ready.equals((Object)taskSummary.getStatus()));
        this.startButton.setEnabled(bl && (Status.Ready.equals((Object)taskSummary.getStatus()) || Status.Reserved.equals((Object)taskSummary.getStatus()) && string.equals(taskSummary.getActualOwner().getId())));
        this.stopButton.setEnabled(bl && Status.InProgress.equals((Object)taskSummary.getStatus()) && string.equals(taskSummary.getActualOwner().getId()));
        this.releaseButton.setEnabled(bl && (Status.Reserved.equals((Object)taskSummary.getStatus()) || Status.InProgress.equals((Object)taskSummary.getStatus())) && string.equals(taskSummary.getActualOwner().getId()));
        this.suspendButton.setEnabled(bl && (Status.Ready.equals((Object)taskSummary.getStatus()) || (Status.Reserved.equals((Object)taskSummary.getStatus()) || Status.InProgress.equals((Object)taskSummary.getStatus())) && string.equals(taskSummary.getActualOwner().getId())));
        this.resumeButton.setEnabled(bl && Status.Suspended.equals((Object)taskSummary.getStatus()));
        this.skipButton.setEnabled(bl && taskSummary.isSkipable() && (Status.Created.equals((Object)taskSummary.getStatus()) && Status.Ready.equals((Object)taskSummary.getStatus()) || (Status.Reserved.equals((Object)taskSummary.getStatus()) || Status.InProgress.equals((Object)taskSummary.getStatus())) && string.equals(taskSummary.getActualOwner().getId())));
        this.completeButton.setEnabled(bl && Status.InProgress.equals((Object)taskSummary.getStatus()) && string.equals(taskSummary.getActualOwner().getId()));
        this.failButton.setEnabled(bl && Status.InProgress.equals((Object)taskSummary.getStatus()) && string.equals(taskSummary.getActualOwner().getId()));
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TaskView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                TaskView.this.refresh();
            }
        };
        this.refreshAction.setText("\u66f4\u65b0");
        this.refreshAction.setToolTipText("\u30bf\u30b9\u30af\u4e00\u89a7\u3092\u66f4\u65b0");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void showMessage(String string) {
        MessageDialog.openInformation((Shell)this.tableViewer.getControl().getShell(), (String)"\u30bf\u30b9\u30af\u30d3\u30e5\u30fc", (String)string);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    private void refresh() {
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        try {
            BlockingTaskSummaryResponseHandler blockingTaskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
            minaTaskClient.getTasksAssignedAsPotentialOwner(string, this.language, (TaskClientHandler.TaskSummaryResponseHandler)blockingTaskSummaryResponseHandler);
            List<TaskSummary> list = blockingTaskSummaryResponseHandler.getResults();
            this.tableViewer.setInput(list);
            this.tableViewer.refresh();
            this.tableViewer.setSelection(null);
            this.updateButtons();
        }
        catch (TimeoutException timeoutException) {
            this.showMessage("\u30bf\u30b9\u30af\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            minaTaskClient.disconnect();
            this.client = null;
            this.tableViewer.setInput(new ArrayList());
            this.tableViewer.refresh();
            this.tableViewer.setSelection(null);
        }
    }

    private void createTask() {
        NewTaskDialog newTaskDialog = new NewTaskDialog(this.getSite().getShell());
        int n = newTaskDialog.open();
        if (n == 0) {
            MinaTaskClient minaTaskClient = this.getTaskClient();
            if (minaTaskClient == null) {
                return;
            }
            BlockingAddTaskResponseHandler blockingAddTaskResponseHandler = new BlockingAddTaskResponseHandler();
            minaTaskClient.addTask(newTaskDialog.getTask(), newTaskDialog.getContent(), (TaskClientHandler.AddTaskResponseHandler)blockingAddTaskResponseHandler);
            blockingAddTaskResponseHandler.waitTillDone(5000L);
            this.refresh();
        }
    }

    public void claim() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.claim(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void start() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.start(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void stop() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.stop(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void release() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.release(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void suspend() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.suspend(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void resume() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.resume(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void skip() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.skip(taskSummary.getId(), string, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void complete() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.complete(taskSummary.getId(), string, null, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void fail() {
        MinaTaskClient minaTaskClient = this.getTaskClient();
        if (minaTaskClient == null) {
            return;
        }
        String string = this.getUserId();
        if (string == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler blockingTaskOperationResponseHandler = new BlockingTaskOperationResponseHandler();
        minaTaskClient.fail(taskSummary.getId(), string, null, (TaskClientHandler.TaskOperationResponseHandler)blockingTaskOperationResponseHandler);
        blockingTaskOperationResponseHandler.waitTillDone(3000L);
        this.refresh();
    }

    private MinaTaskClient getTaskClient() {
        if (this.client == null) {
            this.client = new MinaTaskClient("org.drools.eclipse.task.views.TaskView", new TaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
            NioSocketConnector nioSocketConnector = new NioSocketConnector();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ipAddress, this.port);
            boolean bl = this.client.connect((SocketConnector)nioSocketConnector, (SocketAddress)inetSocketAddress);
            if (!bl) {
                this.showMessage("\u30bf\u30b9\u30af\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\uff1a " + this.ipAddress + " [\u30dd\u30fc\u30c8 " + this.port + "]");
                this.client = null;
            }
        }
        return this.client;
    }

    public void dispose() {
        if (this.client != null) {
            this.client.disconnect();
        }
        super.dispose();
    }

    private String getUserId() {
        return this.userNameText.getText();
    }

    private TaskSummary getSelectedTask() {
        Object object;
        ISelection iSelection = this.tableViewer.getSelection();
        if (iSelection instanceof StructuredSelection && (object = ((StructuredSelection)iSelection).getFirstElement()) instanceof TaskSummary) {
            return (TaskSummary)object;
        }
        return null;
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof List) {
                List list = (List)object;
                return list.toArray();
            }
            return new String[0];
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof TaskSummary) {
                TaskSummary taskSummary = (TaskSummary)object;
                switch (n) {
                    case 0: {
                        return taskSummary.getName();
                    }
                    case 1: {
                        Status status = taskSummary.getStatus();
                        return status == null ? null : (String)STATUSSES.get(status);
                    }
                    case 2: {
                        User user = taskSummary.getActualOwner();
                        if (user == null) {
                            return null;
                        }
                        return user.getId();
                    }
                    case 3: {
                        return DateFormat.getDateTimeInstance().format(taskSummary.getCreatedOn());
                    }
                    case 4: {
                        return taskSummary.getDescription();
                    }
                }
                throw new IllegalArgumentException("\u4e0d\u660e\u306a\u5217\u30a4\u30f3\u30c7\u30a3\u30c3\u30af\u30b9\uff1a " + n);
            }
            return this.getText(object);
        }

        public Image getColumnImage(Object object, int n) {
            return this.getImage(object);
        }

        public Image getImage(Object object) {
            return null;
        }
    }
}

