/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap hashMap, BasicPdfWriter basicPdfWriter) throws IOException {
        int n;
        int n2;
        int n3;
        if (hashMap.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (objectArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            for (int i = 0; i < objectArray.length; ++i) {
                pdfArray.add(new PdfString((String)objectArray[i], null));
                pdfArray.add((PdfObject)hashMap.get(objectArray[i]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            return pdfDictionary;
        }
        int n4 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(objectArray.length + 64 - 1) / 64];
        for (n3 = 0; n3 < pdfIndirectReferenceArray.length; ++n3) {
            n = Math.min(n2 + 64, objectArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfString((String)objectArray[n2], null));
            pdfArray.add(new PdfString((String)objectArray[n - 1], null));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n2 = n3 * 64; n2 < n; ++n2) {
                pdfArray.add(new PdfString((String)objectArray[n2], null));
                pdfArray.add((PdfObject)hashMap.get(objectArray[n2]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            pdfIndirectReferenceArray[n3] = basicPdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n3 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n3 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n = 0; n < n3; ++n) {
                    pdfArray.add(pdfIndirectReferenceArray[n]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n2 = (objectArray.length + (n4 *= 64) - 1) / n4;
            for (n = 0; n < n2; ++n) {
                int n5;
                int n6 = Math.min(n5 + 64, n3);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfString((String)objectArray[n * n4], null));
                pdfArray.add(new PdfString((String)objectArray[Math.min((n + 1) * n4, objectArray.length) - 1], null));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n5 = n * 64; n5 < n6; ++n5) {
                    pdfArray.add(pdfIndirectReferenceArray[n5]);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n] = basicPdfWriter.addToBody(pdfDictionary).getIndirectReference();
            }
            n3 = n2;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NAMES));
                if (pdfArray == null) break block2;
                for (int i = 0; i < pdfArray.size(); ++i) {
                    PdfString pdfString = (PdfString)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i++));
                    hashMap.put(PdfEncodings.convertToString(pdfString.getBytes(), null), pdfArray.getPdfObject(i));
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i));
                PdfNameTree.iterateItems(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNameTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

