/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.expressions.ExpressionMath;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.FetchGroup;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class VersionLockingPolicy
implements OptimisticLockingPolicy,
Serializable {
    protected DatabaseField writeLockField;
    protected int lockValueStored;
    protected ClassDescriptor descriptor;
    protected transient Expression cachedExpression;
    public static final int IN_CACHE = 1;
    public static final int IN_OBJECT = 2;

    public VersionLockingPolicy() {
        this.storeInCache();
    }

    public VersionLockingPolicy(String fieldName) {
        this(new DatabaseField(fieldName));
    }

    public VersionLockingPolicy(DatabaseField field) {
        this();
        this.setWriteLockField(field);
    }

    public void addLockFieldsToUpdateRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isStoredInCache()) {
            databaseRow.put(this.getWriteLockField(), (Object)null);
        }
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) {
        Object value = this.isStoredInCache() ? query.getSession().getIdentityMapAccessor().getWriteLockValue(query.getPrimaryKey(), query.getObject().getClass()) : this.lockValueFromObject(query.getObject());
        if (value == null) {
            if (query.isDeleteObjectQuery()) {
                throw OptimisticLockException.noVersionNumberWhenDeleting(query.getObject(), query);
            }
            throw OptimisticLockException.noVersionNumberWhenUpdating(query.getObject(), query);
        }
        query.getTranslationRow().put(this.getWriteLockField(), value);
    }

    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return this.buildUpdateExpression(table, mainExpression, row, null);
    }

    protected Expression buildExpression() {
        ExpressionBuilder builder = new ExpressionBuilder();
        return builder.getField(this.getWriteLockField()).equal(builder.getParameter(this.getWriteLockField()));
    }

    public Expression buildUpdateExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row, AbstractRecord row2) {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.buildExpression();
        }
        if (this.getWriteLockField().getTableName().equals(table.getName())) {
            return mainExpression.and(this.cachedExpression);
        }
        return mainExpression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int compareWriteLockValues(Object value1, Object value2) {
        BigDecimal bigDecimalValue1 = value1 instanceof BigDecimal ? (BigDecimal)value1 : new BigDecimal(((Number)value1).longValue());
        BigDecimal bigDecimalValue2 = value2 instanceof BigDecimal ? (BigDecimal)value2 : new BigDecimal(((Number)value2).longValue());
        return bigDecimalValue1.compareTo(bigDecimalValue2);
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.BIGDECIMAL;
    }

    public Object getBaseValue() {
        return new BigDecimal(0);
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected Object getInitialWriteValue(AbstractSession session) {
        return new BigDecimal(1);
    }

    protected Object getNewLockValue(ModifyQuery query) {
        Class objectClass = query.getDescriptor().getJavaClass();
        Number newWriteLockValue = null;
        Number value = this.isStoredInCache() ? (Number)((Number)query.getSession().getIdentityMapAccessor().getWriteLockValue(((WriteObjectQuery)query).getPrimaryKey(), objectClass)) : (Number)((Number)this.lockValueFromObject(((ObjectLevelModifyQuery)query).getObject()));
        if (value == null) {
            throw OptimisticLockException.noVersionNumberWhenUpdating(((ObjectLevelModifyQuery)query).getObject(), (ObjectLevelModifyQuery)query);
        }
        newWriteLockValue = this.incrementWriteLockValue(value);
        return newWriteLockValue;
    }

    protected Vector getUnmappedFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        if (this.isStoredInCache()) {
            fields.addElement(this.getWriteLockField());
        }
        return fields;
    }

    public Object getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return row.get(this.getWriteLockField());
        }
        return null;
    }

    public int getVersionDifference(Object currentValue, Object domainObject, Vector primaryKeys, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessor().getWriteLockValue(primaryKeys, domainObject.getClass())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (writeLockFieldValue == null) {
            writeLockFieldValue = new BigDecimal(0);
        }
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return ((BigDecimal)newWriteLockFieldValue).subtract((BigDecimal)writeLockFieldValue).intValue();
    }

    public DatabaseField getWriteLockField() {
        return this.writeLockField;
    }

    public String getWriteLockFieldName() {
        return this.getWriteLockField().getQualifiedName();
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder) {
        return ExpressionMath.add(builder.getField(this.writeLockField.getName()), 1);
    }

    public Object getWriteLockValue(Object domainObject, Vector primaryKey, AbstractSession session) {
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessor().getWriteLockValue(primaryKey, domainObject.getClass())) : (Number)((Number)this.lockValueFromObject(domainObject));
        return writeLockFieldValue;
    }

    protected Number incrementWriteLockValue(Number numberValue) {
        BigDecimal writeLockValue = numberValue instanceof BigDecimal ? (BigDecimal)numberValue : new BigDecimal(numberValue.doubleValue());
        return writeLockValue.add(new BigDecimal(1));
    }

    public void initialize(AbstractSession session) {
        DatabaseMapping mapping = this.mappingFromLockField();
        if (mapping == null) {
            if (this.isStoredInObject()) {
                throw OptimisticLockException.mustHaveMappingWhenStoredInObject(this.descriptor.getJavaClass());
            }
            return;
        }
        if (mapping.isReadOnly()) {
            throw DescriptorException.mappingCanNotBeReadOnly(mapping);
        }
        if (this.isStoredInCache()) {
            session.getIntegrityChecker().handleError(DescriptorException.mustBeReadOnlyMappingWhenStoredInCache(mapping));
        }
    }

    public void initializeProperties() {
        DatabaseField dbField = this.getWriteLockField();
        this.descriptor.buildField(dbField);
        if (dbField.getType() == null) {
            dbField.setType(this.getDefaultLockingFieldType());
        }
        Enumeration enumtr = this.getUnmappedFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField lockField = (DatabaseField)enumtr.nextElement();
            this.descriptor.getFields().addElement(lockField);
        }
    }

    public boolean isChildWriteLockValueGreater(AbstractSession session, Vector primaryKey, Class original, ObjectChangeSet changeSet) {
        if (this.isStoredInCache()) {
            Number writeLockValue = (Number)changeSet.getWriteLockValue();
            Number parentValue = (Number)session.getIdentityMapAccessor().getWriteLockValue(primaryKey, original);
            if (parentValue != null && !(parentValue instanceof BigDecimal)) {
                parentValue = new BigDecimal(parentValue.longValue());
            }
            if (writeLockValue != null && !(writeLockValue instanceof BigDecimal)) {
                writeLockValue = new BigDecimal(writeLockValue.longValue());
            }
            if (writeLockValue != null && (parentValue == null || ((BigDecimal)parentValue).compareTo((BigDecimal)writeLockValue) == -1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isChildWriteLockValueGreater(UnitOfWorkImpl uow, Vector primaryKey, Class original) {
        if (this.isStoredInCache()) {
            Number writeLockValue = (Number)uow.getIdentityMapAccessor().getWriteLockValue(primaryKey, original);
            Number parentValue = (Number)uow.getParent().getIdentityMapAccessor().getWriteLockValue(primaryKey, original);
            if (parentValue != null && !(parentValue instanceof BigDecimal)) {
                parentValue = new BigDecimal(parentValue.longValue());
            }
            if (writeLockValue != null && !(writeLockValue instanceof BigDecimal)) {
                writeLockValue = new BigDecimal(writeLockValue.longValue());
            }
            if (writeLockValue != null && (parentValue == null || ((BigDecimal)parentValue).compareTo((BigDecimal)writeLockValue) == -1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object currentValue, Object domainObject, Vector primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)currentValue;
        if (newWriteLockFieldValue == null) {
            return true;
        }
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessor().getWriteLockValue(primaryKey, domainObject.getClass())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return writeLockFieldValue == null || ((BigDecimal)newWriteLockFieldValue).compareTo((BigDecimal)writeLockFieldValue) == 1;
    }

    public boolean isNewerVersion(AbstractRecord databaseRow, Object domainObject, Vector primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)databaseRow.get(this.getWriteLockField());
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessor().getWriteLockValue(primaryKey, domainObject.getClass())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return writeLockFieldValue == null || ((BigDecimal)newWriteLockFieldValue).compareTo((BigDecimal)writeLockFieldValue) == 1;
    }

    public boolean isStoredInCache() {
        return this.lockValueStored == 1;
    }

    public boolean isStoredInObject() {
        return this.lockValueStored == 2;
    }

    protected Object lockValueFromObject(Object domainObject) {
        return this.getDescriptor().getObjectBuilder().getBaseValueForField(this.getWriteLockField(), domainObject);
    }

    protected DatabaseMapping mappingFromLockField() {
        return this.descriptor.getObjectBuilder().getMappingForField(this.getWriteLockField());
    }

    public void mergeIntoParentCache(UnitOfWorkImpl uow, Vector primaryKey, Object object) {
        if (this.isStoredInCache()) {
            Object parentValue = uow.getParent().getIdentityMapAccessor().getWriteLockValue(primaryKey, object.getClass());
            uow.getIdentityMapAccessor().updateWriteLockValue(primaryKey, object.getClass(), parentValue);
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setIsStoredInCache(boolean isStoredInCache) {
        if (isStoredInCache) {
            this.storeInCache();
        } else {
            this.storeInObject();
        }
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery query) {
        Object lockValue = this.getInitialWriteValue(query.getSession());
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    protected void updateWriteLockValueForWrite(ObjectLevelModifyQuery query, Object lockValue) {
        query.getModifyRow().put(this.getWriteLockField(), lockValue);
        ObjectChangeSet objectChangeSet = query.getObjectChangeSet();
        if (objectChangeSet != null) {
            objectChangeSet.setWriteLockValue(lockValue);
        }
        AbstractRecord record = this.getDescriptor().getObjectBuilder().createRecord(1);
        record.put(this.getWriteLockField(), lockValue);
        this.getDescriptor().getObjectBuilder().assignReturnRow(query.getObject(), query.getSession(), record);
        if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
            if (objectChangeSet == null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(query.getObject());
            }
            query.getQueryMechanism().updateChangeSet(this.getDescriptor(), objectChangeSet, record, query.getObject());
        }
    }

    public void setWriteLockField(DatabaseField writeLockField) {
        this.writeLockField = writeLockField;
    }

    public void setWriteLockFieldName(String writeLockFieldName) {
        this.setWriteLockField(new DatabaseField(writeLockFieldName));
    }

    public void storeInCache() {
        this.lockValueStored = 1;
    }

    public void storeInObject() {
        this.lockValueStored = 2;
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getNewLockValue(query);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    public void writeLockValueIntoRow(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getWriteLockValue(domainObject, query.getPrimaryKey(), query.getSession());
        query.getModifyRow().put(this.getWriteLockField(), lockValue);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
    }

    public void validateDelete(int rowCount, Object object, DeleteObjectQuery query) {
        if (rowCount <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, query);
        }
    }

    public void validateUpdate(int rowCount, Object object, WriteObjectQuery owner) {
        if (rowCount <= 0) {
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, owner);
        }
    }

    public void prepareFetchGroupForReadQuery(FetchGroup fetchGroup, ObjectLevelReadQuery query) {
        if (this.isStoredInObject()) {
            String verAttributeName = this.descriptor.getObjectBuilder().getMappingForField(this.writeLockField).getAttributeName();
            fetchGroup.addAttribute(verAttributeName);
        } else if (!query.getAdditionalFields().contains(this.writeLockField)) {
            query.addAdditionalField(this.writeLockField);
        }
    }
}

