/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.JavaSECMPInitializer;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.schemaframework.SchemaManager;
import oracle.toplink.essentials.tools.sessionmanagement.SessionManager;

public class EntityManagerFactoryProvider
implements PersistenceProvider {
    public static final String JDBC_DRIVER_PROPERTY = "toplink.jdbc.driver";
    public static final String JDBC_CONNECTION_STRING_PROPERTY = "toplink.jdbc.url";
    public static final String JDBC_USER_PROPERTY = "toplink.jdbc.user";
    public static final String JDBC_PASSWORD_PROPERTY = "toplink.jdbc.password";
    public static final String TOPLINK_PLATFORM_PROPERTY = "toplink.platform.class.name";
    public static final String TOPLINK_SERVER_PLATFORM_PROPERTY = "toplink.server.platform.class.name";
    public static final String TOPLINK_EXTERNAL_TRANSACTION_CONTROLLER_PROPERTY = "toplink.external.transaction.controller.class.name";
    public static final String TOPLINK_LOGGING_LEVEL = "toplink.logging.level";
    public static final String TOPLINK_ORM_THROW_EXCEPTIONS = "toplink.orm.throw.exceptions";
    public static final String TOPLINK_VALIDATION_ONLY_PROPERTY = "toplink.validation-only";
    public static final String DDL_GENERATION = "toplink.ddl-generation";
    public static final String CREATE_ONLY = "create-tables";
    public static final String DROP_AND_CREATE = "drop-and-create-tables";
    public static final String NONE = "none";
    public static final String APP_LOCATION = "toplink.application-location";
    public static final String CREATE_JDBC_DDL_FILE = "toplink.create-ddl-jdbc-file-name";
    public static final String DROP_JDBC_DDL_FILE = "toplink.drop-ddl-jdbc-file-name";
    public static final String MAX_WRITE_CONNECTIONS = "toplink.max-write-connections";
    public static final String MIN_WRITE_CONNECTIONS = "toplink.min-write-connections";
    public static final String MAX_READ_CONNECTIONS = "toplink.max-read-connections";
    public static final String MIN_READ_CONNECTIONS = "toplink.min-read-connections";
    public static final String BIND_ALL_PARAMETERS = "toplink.bind-all-parameters";
    public static final String DESCRIPTOR_CACHE_SIZE = "toplink.cache.default-size";
    public static final String DEFAULT_APP_LOCATION = "." + File.separator;
    public static final String DEFAULT_CREATE_JDBC_FILE_NAME = "createDDL.jdbc";
    public static final String DEFAULT_DROP_JDBC_FILE_NAME = "dropDDL.jdbc";
    public static final String JAVASE_DB_INTERACTION = "INTERACT_WITH_DB";

    private void cleanUpSessionManager(EntityManagerSetupImpl emSetupImpl) {
        AbstractSession tempSession;
        if (emSetupImpl.getDeployedSessionName() != null && (tempSession = (AbstractSession)SessionManager.getManager().getSessions().get(emSetupImpl.getDeployedSessionName())) != null) {
            SessionManager.getManager().getSessions().remove(emSetupImpl.getDeployedSessionName());
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        ServerSession session;
        Map nonNullProperties = properties == null ? new HashMap() : properties;
        String name = emName;
        if (name == null) {
            name = "";
        }
        if ((session = this.getServerSession(name, nonNullProperties)) != null) {
            try {
                EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(session);
                this.login(session, this.getPersistenceUnitProperties(name, nonNullProperties));
                this.generateDDLFiles(session, this.getPersistenceUnitProperties(name, nonNullProperties), true);
                return emf;
            }
            catch (ValidationException e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        EntityManagerSetupImpl emSetupImpl = new EntityManagerSetupImpl();
        ClassLoader tempLoader = info.getNewTempClassLoader();
        Collection entities = EntityManagerFactoryProvider.buildEntityList(info, tempLoader, emSetupImpl);
        Map mergedProperties = EntityManagerFactoryProvider.mergePropertiesIntoMap(properties, info.getProperties());
        boolean validationOnly = EntityManagerFactoryProvider.getConfigPropertyAsString(TOPLINK_VALIDATION_ONLY_PROPERTY, mergedProperties, "false").equalsIgnoreCase("true");
        emSetupImpl.setValidationOnly(validationOnly);
        ClassTransformer transformer = emSetupImpl.predeploy(entities, tempLoader, info, properties);
        if (transformer != null) {
            info.addTransformer(transformer);
        }
        ClassLoader realLoader = info.getClassLoader();
        entities = EntityManagerFactoryProvider.buildEntityList(info, realLoader, emSetupImpl);
        ServerSession session = null;
        try {
            session = emSetupImpl.deploy(entities, realLoader);
            if (validationOnly) {
                session.initializeDescriptors();
            } else {
                this.login(session, mergedProperties);
                this.generateDDLFiles(session, mergedProperties, false);
            }
        }
        catch (ValidationException exception) {
            this.cleanUpSessionManager(emSetupImpl);
            throw new PersistenceException(exception);
        }
        catch (RuntimeException exception) {
            this.cleanUpSessionManager(emSetupImpl);
            throw exception;
        }
        return new EntityManagerFactoryImpl(session);
    }

    private void login(ServerSession session, Map persistenceUnitProperties) {
        String toplinkPlatform = (String)persistenceUnitProperties.get(TOPLINK_PLATFORM_PROPERTY);
        if (!session.isConnected()) {
            if (toplinkPlatform == null || toplinkPlatform.equals("")) {
                session.loginAndDetectDatasource();
            } else {
                session.login();
            }
        }
    }

    private void generateDDLFiles(ServerSession session, Map props, boolean inSEmode) {
        boolean createTables = false;
        boolean shouldDropFirst = false;
        String ddlGeneration = NONE;
        if (null == props) {
            return;
        }
        ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString(DDL_GENERATION, props, NONE);
        if ((ddlGeneration = ddlGeneration.toLowerCase()).equals(NONE)) {
            return;
        }
        if (ddlGeneration.equals(CREATE_ONLY) || ddlGeneration.equals(DROP_AND_CREATE)) {
            createTables = true;
            if (ddlGeneration.equals(DROP_AND_CREATE)) {
                shouldDropFirst = true;
            }
        }
        if (createTables) {
            String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString(APP_LOCATION, props, DEFAULT_APP_LOCATION);
            String createDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString(CREATE_JDBC_DDL_FILE, props, DEFAULT_CREATE_JDBC_FILE_NAME);
            String dropDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString(DROP_JDBC_DDL_FILE, props, DEFAULT_DROP_JDBC_FILE_NAME);
            SchemaManager mgr = new SchemaManager(session);
            if (inSEmode) {
                this.runInSEMode(mgr, shouldDropFirst);
            }
            this.writeDDLsToFiles(mgr, shouldDropFirst, appLocation, createDDLJdbc, dropDDLJdbc);
        }
    }

    public static Collection buildEntityList(PersistenceUnitInfo info, ClassLoader loader, EntityManagerSetupImpl emSetupImpl) {
        HashSet<String> classNames = new HashSet<String>();
        classNames.addAll(info.getManagedClassNames());
        Iterator<URL> i = info.getJarFileUrls().iterator();
        while (i.hasNext()) {
            classNames.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(i.next(), loader));
        }
        if (!info.excludeUnlistedClasses()) {
            classNames.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(info.getPersistenceUnitRootUrl(), loader));
        }
        classNames.addAll(emSetupImpl.buildPersistentClassSet(loader, info));
        Vector entityList = new Vector();
        i = classNames.iterator();
        String className = null;
        while (i.hasNext()) {
            try {
                className = (String)((Object)i.next());
                Class<?> entityClass = loader.loadClass(className);
                entityList.add(entityClass);
            }
            catch (ClassNotFoundException exc) {
                AbstractSessionLog.getLog().log(4, "exception_loading_entity_class", className, exc);
            }
        }
        return entityList;
    }

    protected ServerSession getServerSession(String emName, Map m) {
        JavaSECMPInitializer initializer = JavaSECMPInitializer.getJavaSECMPInitializer(m);
        return initializer.getServerSession(emName, m);
    }

    protected Properties getPersistenceUnitProperties(String emName, Map m) {
        JavaSECMPInitializer initializer = JavaSECMPInitializer.getJavaSECMPInitializer(m);
        return initializer.getPersistenceUnitProperties(emName);
    }

    private void runInSEMode(SchemaManager mgr, boolean shouldDropFirst) {
        String str = EntityManagerFactoryProvider.getConfigPropertyAsString(JAVASE_DB_INTERACTION, null, "true");
        boolean interactWithDB = Boolean.valueOf(str.toLowerCase());
        if (!interactWithDB) {
            return;
        }
        this.createOrReplaceDefaultTables(mgr, shouldDropFirst);
    }

    public static String getConfigPropertyAsString(String propertyKey, Map overrides, String defaultValue) {
        String value = null;
        if (overrides != null) {
            value = (String)overrides.get(propertyKey);
        }
        if (value == null) {
            value = System.getProperty(propertyKey);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void createOrReplaceDefaultTables(SchemaManager mgr, boolean shouldDropFirst) {
        if (shouldDropFirst) {
            mgr.replaceDefaultTables(true);
        } else {
            mgr.createDefaultTables();
        }
    }

    private void writeDDLsToFiles(SchemaManager mgr, boolean shouldDropFirst, String appLocation, String createDDLJdbc, String dropDDLJdbc) {
        appLocation = this.addFileSeperator(appLocation);
        if (null != createDDLJdbc) {
            String createJdbcFileName = appLocation + createDDLJdbc;
            mgr.outputCreateDDLToFile(createJdbcFileName);
        }
        if (null != dropDDLJdbc) {
            String dropJdbcFileName = appLocation + dropDDLJdbc;
            mgr.outputDropDDLToFile(dropJdbcFileName);
        }
        mgr.setCreateSQLFiles(false);
        this.createOrReplaceDefaultTables(mgr, true);
        mgr.closeDDLWriter();
    }

    private String addFileSeperator(String appLocation) {
        int strLength = appLocation.length();
        if (appLocation.substring(strLength - 1, strLength).equals(File.separator)) {
            return appLocation;
        }
        return appLocation + File.separator;
    }

    public static Map mergePropertiesIntoMap(Map target, Properties source) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (target != null) {
            map.putAll(target);
        }
        if (source != null) {
            Enumeration<?> sourceNames = source.propertyNames();
            while (sourceNames.hasMoreElements()) {
                String key = (String)sourceNames.nextElement();
                if (map.get(key) != null) continue;
                map.put(key, source.getProperty(key));
            }
        }
        return map;
    }
}

