/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.toplink.essentials.internal.databaseaccess.BindCallCustomParameter;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class OutputParameterForCallableStatement
extends BindCallCustomParameter {
    protected boolean isCursor;
    protected int jdbcType;
    protected String typeName;
    protected boolean isTypeNameRequired;

    public OutputParameterForCallableStatement(DatabaseField field) {
        super(field);
    }

    public OutputParameterForCallableStatement(DatabaseField field, DatabasePlatform platform) {
        this(field, platform, false);
    }

    public OutputParameterForCallableStatement(DatabaseField field, DatabasePlatform platform, boolean isCursor) {
        this(field);
        this.isCursor = isCursor;
        this.prepare(platform);
    }

    public OutputParameterForCallableStatement(OutputParameterForCallableStatement outParameter) {
        super(outParameter.obj);
        this.isCursor = outParameter.isCursor;
        this.jdbcType = outParameter.jdbcType;
        this.typeName = outParameter.typeName;
        this.isTypeNameRequired = outParameter.isTypeNameRequired;
    }

    protected OutputParameterForCallableStatement() {
    }

    public void setIsCursor(boolean isCursor) {
        this.isCursor = isCursor;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public boolean isTypeNameRequired() {
        return this.isTypeNameRequired;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DatabaseField getOutputField() {
        return (DatabaseField)this.obj;
    }

    public void prepare(DatabasePlatform platform) {
        if (this.isCursor()) {
            this.jdbcType = platform.getCursorCode();
        } else {
            this.jdbcType = platform.getJDBCType(this.getOutputField());
            this.isTypeNameRequired = platform.requiresTypeNameToRegisterOutputParameter();
            if (this.isTypeNameRequired) {
                this.typeName = platform.getJdbcTypeName(this.jdbcType);
            }
        }
    }

    public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (this.isTypeNameRequired) {
            ((CallableStatement)statement).registerOutParameter(index, this.jdbcType, this.typeName);
        } else {
            ((CallableStatement)statement).registerOutParameter(index, this.jdbcType);
        }
    }

    public String toString() {
        return "=> " + this.getOutputField().getName();
    }
}

