/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.descriptors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class InstantiationPolicy
implements Cloneable,
Serializable {
    protected String methodName;
    protected transient Method method;
    protected Class factoryClass;
    protected String factoryClassName;
    protected String factoryMethodName;
    protected Object factory;
    protected ClassDescriptor descriptor;
    private transient Constructor defaultConstructor;

    public Object buildNewInstance() throws DescriptorException {
        if (this.isUsingDefaultConstructor()) {
            return this.buildNewInstanceUsingDefaultConstructor();
        }
        return this.buildNewInstanceUsingFactory();
    }

    protected Object buildNewInstanceUsingDefaultConstructor() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeConstructor(this.getDefaultConstructor(), null);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (InstantiationException exception) {
            throw DescriptorException.instantiationWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (NoSuchMethodError exception) {
            throw DescriptorException.noSuchMethodWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileConstructorInstantiation(this.getDescriptor(), exception);
        }
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeMethod(this.getMethod(), this.getFactory(), new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), exception);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Constructor getDefaultConstructor() throws DescriptorException {
        if (this.defaultConstructor == null) {
            this.setDefaultConstructor(this.buildDefaultConstructor());
        }
        return this.defaultConstructor;
    }

    protected Constructor buildDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getDescriptor().getJavaClass());
    }

    protected Constructor buildDefaultConstructorFor(Class javaClass) throws DescriptorException {
        try {
            return PrivilegedAccessController.getDeclaredConstructorFor(javaClass, new Class[0], true);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(javaClass.getName() + ".<Default Constructor>", this.getDescriptor(), exception);
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public Object getFactory() {
        return this.factory;
    }

    public Class getFactoryClass() {
        return this.factoryClass;
    }

    public String getFactoryClassName() {
        if (this.factoryClassName == null && this.factoryClass != null) {
            this.factoryClassName = this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    protected Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isUsingDefaultConstructor()) {
            return;
        }
        try {
            if (this.getFactory() == null) {
                this.setFactory(this.buildFactory());
            }
            this.initializeMethod();
        }
        catch (DescriptorException ex) {
            session.getIntegrityChecker().handleError(ex);
        }
    }

    protected Object buildFactory() throws DescriptorException {
        if (this.getFactoryClass() == null) {
            return null;
        }
        if (this.getFactoryMethodName() == null) {
            return this.buildFactoryUsingDefaultConstructor();
        }
        return this.buildFactoryUsingStaticMethod();
    }

    protected Object buildFactoryUsingDefaultConstructor() throws DescriptorException {
        try {
            return PrivilegedAccessController.invokeConstructor(this.buildFactoryDefaultConstructor(), null);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileConstructorInstantiationOfFactory(this.getDescriptor(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileConstructorInstantiationOfFactory(this.getDescriptor(), exception);
        }
        catch (InstantiationException exception) {
            throw DescriptorException.instantiationWhileConstructorInstantiationOfFactory(this.getDescriptor(), exception);
        }
        catch (NoSuchMethodError exception) {
            throw DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory(this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileConstructorInstantiationOfFactory(this.getDescriptor(), exception);
        }
    }

    protected Constructor buildFactoryDefaultConstructor() throws DescriptorException {
        return this.buildDefaultConstructorFor(this.getFactoryClass());
    }

    protected Object buildFactoryUsingStaticMethod() throws DescriptorException {
        Method factoryMethod = this.buildMethod(this.getFactoryClass(), this.getFactoryMethodName(), new Class[0]);
        try {
            return PrivilegedAccessController.invokeMethod(factoryMethod, null, null);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileMethodInstantiationOfFactory(this.getFactoryMethodName(), this.getDescriptor(), exception);
        }
    }

    protected void initializeMethod() throws DescriptorException {
        Class<?> tempClass = this.getFactory() == null ? this.getDescriptor().getJavaClass() : this.getFactory().getClass();
        this.setMethod(this.buildMethod(tempClass, this.getMethodName(), new Class[0]));
    }

    protected Method buildMethod(Class methodClass, String methodName, Class[] methodParameterTypes) throws DescriptorException {
        try {
            return Helper.getDeclaredMethod(methodClass, methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(methodClass.getName() + "." + methodName, this.getDescriptor(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingInstantiationPolicy(methodClass.getName() + "." + methodName, this.getDescriptor(), exception);
        }
    }

    public boolean isUsingDefaultConstructor() {
        return this.getMethodName() == null;
    }

    protected void setDefaultConstructor(Constructor defaultConstructor) {
        this.defaultConstructor = defaultConstructor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    protected void setFactory(Object factory) {
        this.factory = factory;
    }

    protected void setFactoryClass(Class factoryClass) {
        this.factoryClass = factoryClass;
    }

    protected void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.factoryClassName == null) {
            return;
        }
        Class factoryClass = null;
        try {
            factoryClass = PrivilegedAccessController.getClassForName(this.factoryClassName, true, classLoader);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.factoryClassName, exc);
        }
        this.setFactoryClass(factoryClass);
    }

    public String toString() {
        String mName = null;
        mName = this.isUsingDefaultConstructor() ? "<CONSTRUCTOR>" : this.getMethodName();
        return Helper.getShortClassName(this) + "(" + mName + ")";
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.setMethodName(null);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(factoryClass);
        this.setFactoryClassName(factoryClass.getName());
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName, String factoryMethodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(factoryClass);
        this.setFactoryClassName(factoryClass.getName());
        this.setFactoryMethodName(factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(factoryClassName);
        this.setFactoryMethodName(null);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.setMethodName(methodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(factoryClassName);
        this.setFactoryMethodName(factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.setMethodName(methodName);
        this.setFactory(factory);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.setMethodName(staticMethodName);
        this.setFactory(null);
        this.setFactoryClass(null);
        this.setFactoryClassName(null);
        this.setFactoryMethodName(null);
    }
}

