/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.CMPPolicy;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected KeyElementAccessor[] keyClassFields;
    protected String pkClassName;
    protected Class pkClass;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                this.setPKClass(PrivilegedAccessController.getClassForName(this.getPKClassName(), true, classLoader));
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("pk_class_not_found", new Object[]{this.pkClassName}), exc);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String pkClassName) {
        this.pkClassName = pkClassName;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.initializePrimaryKeyFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class pkClass) {
        this.pkClass = pkClass;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object key, AbstractSession session) {
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(key.getClass());
        Vector<Object> pkVector = new Vector<Object>(pkElementArray.length);
        for (int index = 0; index < pkElementArray.length; ++index) {
            DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName());
            if (mapping == null) {
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(pkElementArray[index].getDatabaseField());
            }
            while (mapping.isAggregateObjectMapping()) {
                if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName())) != null) continue;
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(pkElementArray[index].getDatabaseField());
            }
            Object fieldValue = null;
            fieldValue = mapping.isDirectToFieldMapping() ? ((AbstractDirectMapping)mapping).getFieldValue(pkElementArray[index].getValue(key), session) : pkElementArray[index].getValue(key);
            pkVector.add(fieldValue);
        }
        return pkVector;
    }

    public Object createPrimaryKeyInstance(Object key, AbstractSession session) {
        Object keyInstance = this.getPKClassInstance();
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        for (int index = 0; index < pkElementArray.length; ++index) {
            KeyElementAccessor accessor = pkElementArray[index];
            DatabaseMapping mapping = builder.getMappingForAttributeName(accessor.getAttributeName());
            while (mapping.isAggregateObjectMapping()) {
                if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName())) != null) continue;
                mapping = builder.getMappingForField(accessor.getDatabaseField());
            }
            Object fieldValue = mapping.getRealAttributeValueFromObject(key, session);
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    protected Object createBeanUsingKey(Object key, AbstractSession session) {
        try {
            Object bean = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            KeyElementAccessor[] keyElements = this.getKeyClassFields(key.getClass());
            for (int index = 0; index < keyElements.length; ++index) {
                Object toWriteInto = bean;
                Object keyFieldValue = keyElements[index].getValue(key);
                DatabaseField field = keyElements[index].getDatabaseField();
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                }
                while (mapping.isAggregateObjectMapping()) {
                    Object aggregate = mapping.getRealAttributeValueFromObject(toWriteInto, session);
                    if (aggregate == null) {
                        aggregate = mapping.getReferenceDescriptor().getJavaClass().newInstance();
                        mapping.setRealAttributeValueInObject(toWriteInto, aggregate);
                    }
                    if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName())) == null) {
                        mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                    }
                    toWriteInto = aggregate;
                }
                mapping.setRealAttributeValueInObject(toWriteInto, keyFieldValue);
            }
            return bean;
        }
        catch (Exception e) {
            throw DescriptorException.errorUsingPrimaryKey(key, this.getDescriptor(), e);
        }
    }

    protected KeyElementAccessor[] initializePrimaryKeyFields(Class keyClass) {
        KeyElementAccessor[] pkAttributes = null;
        ClassDescriptor descriptor = this.getDescriptor();
        pkAttributes = new KeyElementAccessor[descriptor.getObjectBuilder().getPrimaryKeyMappings().size()];
        Iterator attributesIter = descriptor.getPrimaryKeyFields().iterator();
        int i = 0;
        while (attributesIter.hasNext()) {
            DatabaseField field = (DatabaseField)attributesIter.next();
            Vector<DatabaseMapping> allMappings = null;
            allMappings = descriptor.getObjectBuilder().getReadOnlyMappingsForField(field);
            if (allMappings == null) {
                allMappings = new Vector<DatabaseMapping>(1);
            }
            allMappings.add(descriptor.getObjectBuilder().getMappingForField(field));
            NoSuchMethodException elementIsFound = null;
            for (int index = allMappings.size() - 1; index >= 0; --index) {
                block13: {
                    DatabaseMapping mapping = (DatabaseMapping)allMappings.get(index);
                    if (mapping.isAggregateMapping()) {
                        Vector aggregateMappings = mapping.getReferenceDescriptor().getObjectBuilder().getReadOnlyMappingsForField(field);
                        if (aggregateMappings != null && !aggregateMappings.isEmpty()) {
                            allMappings.add((DatabaseMapping)((Object)aggregateMappings));
                            index = allMappings.size() - 1;
                        }
                        mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(field);
                    }
                    String fieldName = mapping.getAttributeName();
                    if (keyClass == null) {
                        pkAttributes[i] = new KeyIsElementAccessor(mapping.getAttributeName(), field);
                        this.setPKClass(ConversionManager.getObjectClass(mapping.getAttributeClassification()));
                        elementIsFound = null;
                    } else {
                        try {
                            pkAttributes[i] = new FieldAccessor(PrivilegedAccessController.getField(keyClass, fieldName, true), fieldName, field);
                            elementIsFound = null;
                        }
                        catch (NoSuchFieldException ex) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("get");
                            buffer.append(fieldName.substring(0, 1).toUpperCase());
                            buffer.append(fieldName.substring(1));
                            try {
                                pkAttributes[i] = new PropertyAccessor(PrivilegedAccessController.getMethod(keyClass, buffer.toString(), new Class[0], true), fieldName, field);
                                elementIsFound = null;
                            }
                            catch (NoSuchMethodException exs) {
                                if (descriptor.getObjectBuilder().getPrimaryKeyMappings().size() == 1) {
                                    pkAttributes[i] = new KeyIsElementAccessor(mapping.getAttributeName(), field);
                                    this.setPKClass(ConversionManager.getObjectClass(mapping.getAttributeClassification()));
                                    elementIsFound = null;
                                    break block13;
                                }
                                elementIsFound = exs;
                            }
                        }
                    }
                }
                if (elementIsFound == null) break;
            }
            if (elementIsFound != null) {
                throw DescriptorException.errorUsingPrimaryKey(keyClass, this.getDescriptor(), elementIsFound);
            }
            ++i;
        }
        return pkAttributes;
    }

    protected KeyElementAccessor[] getKeyClassFields(Class clazz) {
        if (this.keyClassFields == null) {
            this.keyClassFields = this.initializePrimaryKeyFields(this.pkClass == null ? clazz : this.pkClass);
        }
        return this.keyClassFields;
    }

    private class KeyIsElementAccessor
    implements KeyElementAccessor {
        protected String attributeName;
        protected DatabaseField databaseField;

        public KeyIsElementAccessor(String attributeName, DatabaseField databaseField) {
            this.attributeName = attributeName;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            return object;
        }

        public void setValue(Object object, Object value) {
        }
    }

    private class FieldAccessor
    implements KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;

        public FieldAccessor(Field field, String attributeName, DatabaseField databaseField) {
            this.field = field;
            this.attributeName = attributeName;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                return PrivilegedAccessController.getValueFromField(this.field, object);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }

        public void setValue(Object object, Object value) {
            try {
                Field pkField = PrivilegedAccessController.getField(object.getClass(), this.field.getName(), true);
                PrivilegedAccessController.setValueInField(pkField, object, value);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }
    }

    private class PropertyAccessor
    implements KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;

        public PropertyAccessor(Method method, String attributeName, DatabaseField field) {
            this.method = method;
            this.attributeName = attributeName;
            this.databaseField = field;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                return PrivilegedAccessController.invokeMethod(this.method, object, new Object[0]);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }

        public void setValue(Object object, Object value) {
            try {
                PrivilegedAccessController.invokeMethod(MetadataHelper.getSetMethod(this.method, object.getClass()), object, new Object[]{value});
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), ex);
            }
        }
    }

    private static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public Object getValue(Object var1);

        public void setValue(Object var1, Object var2);
    }
}

