/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.util.ArrayList;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

public class TableInfo {
    String tableName;
    String catalog;
    String schema;
    ArrayList uniqueConstraints;
    boolean specified;

    public TableInfo() {
        this.tableName = "";
        this.catalog = "";
        this.schema = "";
        this.uniqueConstraints = new ArrayList();
        this.specified = true;
    }

    public TableInfo(String tableName, String catalog, String schema, ArrayList uniqueConstraints) {
        this.tableName = tableName;
        this.catalog = catalog;
        this.schema = schema;
        this.uniqueConstraints = uniqueConstraints;
        this.specified = true;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFullyQualifiedTableName() {
        return MetadataHelper.getFullyQualifiedTableName(this.tableName, this.catalog, this.schema);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ArrayList getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void setUniqueConstraints(ArrayList uniqueConstraints) {
        this.uniqueConstraints = uniqueConstraints;
    }

    public void isSpecified(boolean isSpecified) {
        this.specified = isSpecified;
    }

    public boolean specified() {
        return this.specified;
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TableInfo) {
            TableInfo table = (TableInfo)objectToCompare;
            if (!table.getTableName().equals(this.getTableName())) {
                return false;
            }
            if (!table.getCatalog().equals(this.getCatalog())) {
                return false;
            }
            if (!table.getSchema().equals(this.getSchema())) {
                return false;
            }
            if (table.getUniqueConstraints().equals(this.getUniqueConstraints())) {
                return false;
            }
            return table.specified() == this.specified();
        }
        return false;
    }
}

