/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import java.io.Serializable;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public abstract class DatabaseValueHolder
implements ValueHolderInterface,
Cloneable,
Serializable {
    protected Object value;
    protected boolean isInstantiated;
    protected transient AbstractSession session;
    protected AbstractRecord row;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError();
        }
    }

    public AbstractRecord getRow() {
        return this.row;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public synchronized Object getValue() {
        if (!this.isInstantiated()) {
            this.privilegedSetValue(this.instantiate());
            this.setInstantiated();
            this.resetFields();
        }
        return this.value;
    }

    protected abstract Object instantiate() throws DatabaseException;

    public abstract Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder var1);

    public boolean isEasilyInstantiated() {
        return this.isInstantiated();
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public abstract boolean isPessimisticLockingValueHolder();

    protected boolean isTransactionalValueHolder() {
        return this.session != null && this.session.isUnitOfWork();
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return false;
    }

    public void privilegedSetValue(Object value) {
        this.value = value;
    }

    public void releaseWrappedValueHolder() {
        AbstractSession session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(session.getRootSession(null));
        }
    }

    protected void resetFields() {
        this.setRow(null);
        this.setSession(null);
    }

    public void setInstantiated() {
        this.isInstantiated = true;
    }

    public void setRow(AbstractRecord row) {
        this.row = row;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setUninstantiated() {
        this.isInstantiated = false;
    }

    public void setValue(Object value) {
        this.value = value;
        this.setInstantiated();
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getValue() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }
}

