/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.IdentityMapAccessor;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class UnitOfWorkIdentityMapAccessor
extends IdentityMapAccessor {
    public UnitOfWorkIdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor)) {
            return true;
        }
        return ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        return super.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return super.getFromIdentityMapWithDeferredLock(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object objectFromCache = super.getFromIdentityMap(primaryKey, theClass, true, descriptor);
        if (objectFromCache != null) {
            return objectFromCache;
        }
        return this.getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAndCloneCacheKeyFromParent(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object unregisteredDeletedClone;
        CacheKey cacheKey = ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, theClass, descriptor);
        if (cacheKey == null && ((UnitOfWorkImpl)this.getSession()).getParent().isUnitOfWork()) {
            ((UnitOfWorkIdentityMapAccessor)((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance()).getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
            cacheKey = ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, theClass, descriptor);
        }
        Object objectFromCache = null;
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            ConcurrencyManager concurrencyManager = cacheKey.getMutex();
            synchronized (concurrencyManager) {
                objectFromCache = cacheKey.getObject();
                try {
                    while (cacheKey.isAcquired() && objectFromCache == null) {
                        cacheKey.getMutex().wait(5L);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (objectFromCache == null) {
                    return null;
                }
            }
        }
        return null;
        if (this.getSession().isClassReadOnly(theClass, descriptor)) {
            return objectFromCache;
        }
        if (this.getSession() instanceof RepeatableWriteUnitOfWork && (unregisteredDeletedClone = ((RepeatableWriteUnitOfWork)this.getSession()).getUnregisteredDeletedCloneForOriginal(objectFromCache)) != null) {
            return unregisteredDeletedClone;
        }
        return ((UnitOfWorkImpl)this.getSession()).cloneAndRegisterObject(objectFromCache, cacheKey);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

