/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.xml;

import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.platform.xml.XMLPlatform;
import oracle.toplink.essentials.platform.xml.XMLPlatformException;

public class XMLPlatformFactory {
    public static final String XML_PLATFORM_PROPERTY = "toplink.xml.platform";
    public static final String XDK_PLATFORM_CLASS_NAME = "oracle.toplink.essentials.platform.xml.xdk.XDKPlatform";
    public static final String JAXP_PLATFORM_CLASS_NAME = "oracle.toplink.essentials.platform.xml.jaxp.JAXPPlatform";
    private static XMLPlatformFactory instance;
    private Class xmlPlatformClass;

    private XMLPlatformFactory() {
    }

    public static XMLPlatformFactory getInstance() throws XMLPlatformException {
        if (null == instance) {
            instance = new XMLPlatformFactory();
        }
        return instance;
    }

    public Class getXMLPlatformClass() throws XMLPlatformException {
        if (null != this.xmlPlatformClass) {
            return this.xmlPlatformClass;
        }
        String newXMLPlatformClassName = System.getProperty(XML_PLATFORM_PROPERTY);
        if (null == newXMLPlatformClassName) {
            newXMLPlatformClassName = JAXP_PLATFORM_CLASS_NAME;
        }
        try {
            ClassLoader classLoader = PrivilegedAccessController.getClassLoaderForClass(this.getClass());
            Class<?> newXMLPlatformClass = classLoader.loadClass(newXMLPlatformClassName);
            this.setXMLPlatformClass(newXMLPlatformClass);
            return this.xmlPlatformClass;
        }
        catch (ClassNotFoundException e) {
            throw XMLPlatformException.xmlPlatformClassNotFound(newXMLPlatformClassName, e);
        }
    }

    public void setXMLPlatformClass(Class xmlPlatformClass) {
        this.xmlPlatformClass = xmlPlatformClass;
    }

    public XMLPlatform getXMLPlatform() throws XMLPlatformException {
        try {
            return (XMLPlatform)PrivilegedAccessController.newInstanceFromClass(this.getXMLPlatformClass());
        }
        catch (IllegalAccessException e) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), e);
        }
        catch (InstantiationException e) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), e);
        }
    }
}

