/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.expressions.SQLStatement;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.FalseUndefinedTrue;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.CallQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.EJBQLCall;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.Record;
import oracle.toplink.essentials.sessions.Session;

public abstract class DatabaseQuery
implements Cloneable,
Serializable,
FalseUndefinedTrue {
    protected String name;
    protected Vector arguments;
    protected Vector argumentValues;
    protected Vector argumentTypes;
    protected Vector argumentTypeNames;
    protected transient ClassDescriptor descriptor;
    protected DatabaseQueryMechanism queryMechanism;
    protected boolean shouldMaintainCache = true;
    protected Hashtable properties;
    protected transient AbstractSession session;
    protected transient Accessor accessor;
    protected AbstractRecord translationRow;
    protected boolean isUserDefined = false;
    protected int cascadePolicy = 1;
    protected String sessionName;
    protected boolean isPrepared = false;
    protected boolean shouldPrepare = true;
    protected int shouldBindAllParameters = 0;
    protected int shouldCacheStatement = 0;
    protected boolean shouldUseWrapperPolicy = true;
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    public static final int CascadeDependentParts = 4;
    public static final int CascadeAggregateDelete = 5;
    public static final int CascadeByMapping = 6;
    protected Boolean flushOnExecute;

    public void addArgument(String argumentName) {
        this.addArgument(argumentName, Object.class);
    }

    public void addArgument(String argumentName, Class type) {
        this.getArguments().addElement(argumentName);
        this.getArgumentTypes().addElement(type);
        this.getArgumentTypeNames().addElement(type.getName());
    }

    public void addArgument(String argumentName, String typeAsString) {
        this.getArguments().addElement(argumentName);
        this.getArgumentTypes().addElement(Helper.getObjectClass(ConversionManager.loadClass(typeAsString)));
        this.getArgumentTypeNames().addElement(typeAsString);
    }

    public void addArgumentByTypeName(String argumentName, String typeAsString) {
        this.getArguments().addElement(argumentName);
        this.getArgumentTypeNames().addElement(typeAsString);
    }

    public void addArgumentValue(Object argumentValue) {
        this.getArgumentValues().addElement(argumentValue);
    }

    public void addArgumentValues(Vector theArgumentValues) {
        this.setArgumentValues(theArgumentValues);
    }

    public void addCall(Call call) {
        this.setQueryMechanism(call.buildQueryMechanism(this, this.getQueryMechanism()));
        this.setIsPrepared(false);
    }

    public void addStatement(SQLStatement statement) {
        if (!this.hasQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        } else if (!this.getQueryMechanism().isStatementQueryMechanism()) {
            this.setQueryMechanism(new StatementQueryMechanism(this));
        }
        ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatements().addElement(statement);
        this.setIsPrepared(false);
    }

    public void bindAllParameters() {
        this.setShouldBindAllParameters(true);
    }

    protected void buildSelectionCriteria(AbstractSession session) {
        this.getQueryMechanism().buildSelectionCriteria(session);
    }

    public void cacheStatement() {
        this.setShouldCacheStatement(true);
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadeByMapping() {
        this.setCascadePolicy(6);
    }

    public void cascadeOnlyDependentParts() {
        this.setCascadePolicy(4);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
    }

    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrepare(AbstractSession session, AbstractRecord translationRow) {
        if (!this.isPrepared()) {
            DatabaseQuery databaseQuery = this;
            synchronized (databaseQuery) {
                if (!this.isPrepared()) {
                    if ((this.isReadQuery() || this.isDataModifyQuery()) && this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism && (translationRow == null || translationRow.isEmpty())) {
                        if (this.isReadObjectQuery() || this.isUserDefined()) {
                            ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                        }
                    } else if (this.isCallQuery() && this.getQueryMechanism() instanceof CallQueryMechanism) {
                        ((CallQueryMechanism)this.getQueryMechanism()).setCallHasCustomSQLArguments();
                    }
                    this.setSession(session);
                    this.prepare();
                    this.setSession(null);
                    this.setIsPrepared(true);
                }
            }
        }
    }

    public Object clone() {
        try {
            DatabaseQuery cloneQuery = (DatabaseQuery)super.clone();
            if (cloneQuery.properties != null) {
                if (cloneQuery.properties.isEmpty()) {
                    cloneQuery.setProperties(null);
                } else {
                    cloneQuery.setProperties((Hashtable)this.getProperties().clone());
                }
            }
            if (this.hasQueryMechanism()) {
                cloneQuery.setQueryMechanism(this.getQueryMechanism().clone(cloneQuery));
            }
            cloneQuery.setIsPrepared(this.isPrepared());
            return cloneQuery;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public void deploymentSetShouldMaintainCache(int maintainCache) {
        if (maintainCache == 1) {
            this.setShouldMaintainCache(true);
        } else if (maintainCache == -1) {
            this.setShouldMaintainCache(false);
        }
    }

    public int deploymentShouldMaintainCache() {
        if (this.shouldMaintainCache()) {
            return 1;
        }
        return -1;
    }

    public void dontBindAllParameters() {
        this.setShouldBindAllParameters(false);
    }

    public void dontCacheStatement() {
        this.setShouldCacheStatement(false);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public void dontMaintainCache() {
        this.setShouldMaintainCache(false);
    }

    public abstract Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException;

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        return this.execute(unitOfWork, translationRow);
    }

    public Object execute(AbstractSession session, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        DatabaseQuery customQuery;
        DatabaseQuery queryToExecute = this;
        session.startOperationProfile("query prepare");
        Object earlyReturn = queryToExecute.checkEarlyReturn(session, translationRow);
        if (earlyReturn != null || this.isReadObjectQuery() && ((ReadObjectQuery)this).shouldCheckCacheOnly()) {
            session.endOperationProfile("query prepare");
            return earlyReturn;
        }
        boolean hasCustomQuery = false;
        if (!this.isPrepared() && this.shouldPrepare() && (customQuery = this.checkForCustomQuery(session, translationRow)) != null) {
            hasCustomQuery = true;
            queryToExecute = customQuery;
        }
        boolean alreadyClonedQuery = false;
        DatabaseQuery sessionPreparedQuery = session.prepareDatabaseQuery(queryToExecute);
        if (sessionPreparedQuery != queryToExecute) {
            queryToExecute = sessionPreparedQuery;
            alreadyClonedQuery = true;
        }
        if (queryToExecute.shouldPrepare()) {
            queryToExecute.checkPrepare(session, translationRow);
        }
        if (!alreadyClonedQuery) {
            queryToExecute = (DatabaseQuery)queryToExecute.clone();
        }
        queryToExecute.setTranslationRow(translationRow);
        if (!queryToExecute.shouldPrepare()) {
            queryToExecute.checkPrepare(session, translationRow);
        }
        queryToExecute.setSession(session);
        if (hasCustomQuery) {
            this.prepareCustomQuery(queryToExecute);
        }
        queryToExecute.prepareForExecution();
        session.endOperationProfile("query prepare");
        Object result = queryToExecute.executeDatabaseQuery();
        this.clonedQueryExecutionComplete(queryToExecute, session);
        return result;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = NonSynchronizedVector.newInstance();
        }
        return this.arguments;
    }

    public Vector getArgumentTypes() {
        if (this.argumentTypes == null || this.argumentTypes.isEmpty()) {
            this.argumentTypes = new Vector();
            if (this.argumentTypeNames != null) {
                for (String argumentTypeName : this.argumentTypeNames) {
                    this.argumentTypes.addElement(Helper.getObjectClass(ConversionManager.loadClass(argumentTypeName)));
                }
            }
        }
        return this.argumentTypes;
    }

    public Vector getArgumentTypeNames() {
        if (this.argumentTypeNames == null) {
            this.argumentTypeNames = NonSynchronizedVector.newInstance();
        }
        return this.argumentTypeNames;
    }

    public void setArgumentTypes(Vector argumentTypes) {
        this.argumentTypes = argumentTypes;
        this.getArgumentTypeNames().clear();
        Iterator types = argumentTypes.iterator();
        while (types.hasNext()) {
            this.argumentTypeNames.addElement(((Class)types.next()).getName());
        }
    }

    public void setArgumentTypeNames(Vector argumentTypeNames) {
        this.argumentTypeNames = argumentTypeNames;
    }

    public void setArguments(Vector arguments) {
        Enumeration enumtr = arguments.elements();
        while (enumtr.hasMoreElements()) {
            this.addArgument((String)enumtr.nextElement());
        }
    }

    public Vector getArgumentValues() {
        if (this.argumentValues == null) {
            this.argumentValues = NonSynchronizedVector.newInstance();
        }
        return this.argumentValues;
    }

    public void setArgumentValues(Vector theArgumentValues) {
        this.argumentValues = theArgumentValues;
    }

    public DatabaseCall getCall() {
        Call call = this.getDatasourceCall();
        if (call instanceof DatabaseCall) {
            return (DatabaseCall)call;
        }
        return null;
    }

    public Call getDatasourceCall() {
        Call call = null;
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism mechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            call = mechanism.getCall();
            if (mechanism.hasMultipleCalls()) {
                call = (Call)mechanism.getCalls().get(0);
            }
        }
        if (call == null && this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            call = ((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall();
        }
        return call;
    }

    public List getDatasourceCalls() {
        Vector calls = new Vector();
        if (this.getQueryMechanism() instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism mechanism = (DatasourceCallQueryMechanism)this.getQueryMechanism();
            if (mechanism.hasMultipleCalls()) {
                calls = mechanism.getCalls();
            } else {
                calls.add(mechanism.getCall());
            }
        }
        if (calls.isEmpty() && this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            calls.add(((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall());
        }
        return calls;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(5);
        }
        return this.properties;
    }

    public synchronized Object getProperty(Object property) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(property);
    }

    public DatabaseQueryMechanism getQueryMechanism() {
        if (this.queryMechanism == null) {
            this.queryMechanism = new ExpressionQueryMechanism(this);
        }
        return this.queryMechanism;
    }

    public boolean hasQueryMechanism() {
        return this.queryMechanism != null;
    }

    public Class getReferenceClass() {
        return null;
    }

    public String getReferenceClassName() {
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.getQueryMechanism().getSelectionCriteria();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SQLStatement getSQLStatement() {
        return ((StatementQueryMechanism)this.getQueryMechanism()).getSQLStatement();
    }

    public String getEJBQLString() {
        if (!this.getQueryMechanism().isEJBQLCallQueryMechanism()) {
            return null;
        }
        EJBQLCall call = ((EJBQLCallQueryMechanism)this.getQueryMechanism()).getEJBQLCall();
        return call.getEjbqlString();
    }

    public String getSQLString() {
        Call call = this.getDatasourceCall();
        if (call == null) {
            return null;
        }
        if (!(call instanceof SQLCall)) {
            return null;
        }
        return ((SQLCall)call).getSQLString();
    }

    public List getSQLStrings() {
        List calls = this.getDatasourceCalls();
        if (calls == null || calls.isEmpty()) {
            return null;
        }
        Vector<String> returnSQL = new Vector<String>(calls.size());
        for (Call call : calls) {
            if (!(call instanceof SQLCall)) {
                return null;
            }
            returnSQL.addElement(((SQLCall)call).getSQLString());
        }
        return returnSQL;
    }

    public int getShouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public String getTranslatedSQLString(Session session, Record translationRow) {
        CallQueryMechanism queryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (queryMechanism.getCall() == null) {
            return null;
        }
        SQLCall call = (SQLCall)queryMechanism.getCall().clone();
        call.translate((AbstractRecord)translationRow, queryMechanism.getModifyRow(), (AbstractSession)session);
        return call.getSQLString();
    }

    public List getTranslatedSQLStrings(Session session, Record translationRow) {
        CallQueryMechanism queryMechanism = (CallQueryMechanism)this.getQueryMechanism();
        if (queryMechanism.getCalls() == null || queryMechanism.getCalls().isEmpty()) {
            return null;
        }
        Vector<String> calls = new Vector<String>(queryMechanism.getCalls().size());
        for (SQLCall call : queryMechanism.getCalls()) {
            call = (SQLCall)call.clone();
            call.translate((AbstractRecord)translationRow, queryMechanism.getModifyRow(), (AbstractSession)session);
            calls.addElement(call.getSQLString());
        }
        return calls;
    }

    public AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean hasAccessor() {
        return this.accessor != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public void ignoreBindAllParameters() {
        this.shouldBindAllParameters = 0;
    }

    public void ignoreCacheStatement() {
        this.shouldCacheStatement = 0;
    }

    public boolean isCallQuery() {
        return this.getQueryMechanism().isCallQueryMechanism();
    }

    public boolean isCascadeOfAggregateDelete() {
        return this.getCascadePolicy() == 5;
    }

    public boolean isDataModifyQuery() {
        return false;
    }

    public boolean isDataReadQuery() {
        return false;
    }

    public boolean isDeleteAllQuery() {
        return false;
    }

    public boolean isDeleteObjectQuery() {
        return false;
    }

    public boolean isExpressionQuery() {
        return this.getQueryMechanism().isExpressionQueryMechanism();
    }

    public boolean isModifyAllQuery() {
        return false;
    }

    public boolean isModifyQuery() {
        return false;
    }

    public boolean isUpdateAllQuery() {
        return false;
    }

    public boolean isUpdateObjectQuery() {
        return false;
    }

    public Boolean getFlushOnExecute() {
        return this.flushOnExecute;
    }

    public boolean isInsertObjectQuery() {
        return false;
    }

    public boolean isObjectLevelModifyQuery() {
        return false;
    }

    public boolean isObjectLevelReadQuery() {
        return false;
    }

    public boolean isObjectBuildingQuery() {
        return true;
    }

    protected boolean isPrepared() {
        return this.isPrepared;
    }

    public boolean isReadAllQuery() {
        return false;
    }

    public boolean isReadObjectQuery() {
        return false;
    }

    public boolean isReadQuery() {
        return false;
    }

    public boolean isReportQuery() {
        return false;
    }

    public boolean isSQLCallQuery() {
        Call call = this.getDatasourceCall();
        return call != null && call instanceof SQLCall;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public boolean isWriteObjectQuery() {
        return false;
    }

    public void maintainCache() {
        this.setShouldMaintainCache(true);
    }

    protected void prepare() throws QueryException {
        this.getQueryMechanism().prepare();
    }

    public void prepareCall(Session session, Record translationRow) throws QueryException {
        this.checkPrepare((AbstractSession)session, (AbstractRecord)translationRow);
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
    }

    public void prepareForExecution() throws QueryException {
        this.getQueryMechanism().prepareForExecution();
    }

    protected void prepareForRemoteExecution() {
    }

    public void removeProperty(Object property) {
        this.getProperties().remove(property);
    }

    public AbstractRecord rowFromArguments(Vector argumentValues) throws QueryException {
        Vector argumentNames = this.getArguments();
        if (argumentNames.size() != argumentValues.size()) {
            throw QueryException.argumentSizeMismatchInQueryAndQueryDefinition(this);
        }
        DatabaseRecord row = new DatabaseRecord();
        for (int index = 0; index < argumentNames.size(); ++index) {
            String argumentName = (String)argumentNames.elementAt(index);
            Object argumentValue = argumentValues.elementAt(index);
            row.put(new DatabaseField(argumentName), argumentValue);
        }
        return row;
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public void setDatasourceCall(Call call) {
        if (call == null) {
            return;
        }
        this.setQueryMechanism(call.buildNewQueryMechanism(this));
    }

    public void setCall(Call call) {
        this.setDatasourceCall(call);
    }

    public void setCascadePolicy(int policyConstant) {
        this.cascadePolicy = policyConstant;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        if (this.descriptor != descriptor) {
            this.setIsPrepared(false);
        }
        this.descriptor = descriptor;
    }

    public void setEJBQLString(String ejbqlString) {
        if (ejbqlString != null && !ejbqlString.equals("")) {
            EJBQLCallQueryMechanism mechanism = new EJBQLCallQueryMechanism(this, new EJBQLCall(ejbqlString));
            this.setQueryMechanism(mechanism);
        }
    }

    public void setFlushOnExecute(Boolean flushMode) {
        this.flushOnExecute = flushMode;
    }

    public void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    public void setIsUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
    }

    public void setName(String queryName) {
        this.name = queryName;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public synchronized void setProperty(Object property, Object value) {
        this.getProperties().put(property, value);
    }

    protected void setQueryMechanism(DatabaseQueryMechanism queryMechanism) {
        this.queryMechanism = queryMechanism;
        this.setIsPrepared(false);
    }

    public void setSelectionCriteria(Expression expression) {
        if (expression == null && !this.getQueryMechanism().isExpressionQueryMechanism()) {
            return;
        }
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            this.setQueryMechanism(new ExpressionQueryMechanism(this, expression));
        } else {
            ((ExpressionQueryMechanism)this.getQueryMechanism()).setSelectionCriteria(expression);
        }
        this.setIsPrepared(false);
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldBindAllParameters(boolean shouldBindAllParameters) {
        this.shouldBindAllParameters = shouldBindAllParameters ? 1 : -1;
        this.setIsPrepared(false);
    }

    public void setShouldBindAllParameters(int bindAllParams) {
        this.shouldBindAllParameters = bindAllParams;
    }

    public void setShouldCacheStatement(boolean shouldCacheStatement) {
        this.shouldCacheStatement = shouldCacheStatement ? 1 : -1;
        this.setIsPrepared(false);
    }

    public void setShouldMaintainCache(boolean shouldMaintainCache) {
        this.shouldMaintainCache = shouldMaintainCache;
    }

    public void setShouldPrepare(boolean shouldPrepare) {
        this.shouldPrepare = shouldPrepare;
        this.setIsPrepared(false);
    }

    public void setShouldUseWrapperPolicy(boolean shouldUseWrapperPolicy) {
        this.shouldUseWrapperPolicy = shouldUseWrapperPolicy;
    }

    public void setSQLStatement(SQLStatement sqlStatement) {
        this.setQueryMechanism(new StatementQueryMechanism(this, sqlStatement));
    }

    public void setSQLString(String sqlString) {
        if (sqlString != null && !sqlString.equals("")) {
            this.setCall(new SQLCall(sqlString));
        }
    }

    public void setTranslationRow(AbstractRecord translationRow) {
        this.translationRow = translationRow;
    }

    public boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters == 1;
    }

    public boolean shouldCacheStatement() {
        return this.shouldCacheStatement == 1;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 6;
    }

    public boolean shouldCascadeOnlyDependentParts() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldIgnoreBindAllParameters() {
        return this.shouldBindAllParameters == 0;
    }

    public boolean shouldIgnoreCacheStatement() {
        return this.shouldCacheStatement == 0;
    }

    public boolean shouldMaintainCache() {
        return this.shouldMaintainCache;
    }

    public boolean shouldPrepare() {
        return this.shouldPrepare;
    }

    public boolean shouldUseWrapperPolicy() {
        return this.shouldUseWrapperPolicy;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }
}

