/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.mappings.AggregateCollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectCollectionMapping;
import oracle.toplink.essentials.mappings.DirectMapMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.sequencing.DefaultSequence;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.schemaframework.FieldDefinition;
import oracle.toplink.essentials.tools.schemaframework.TableCreator;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;

public class DefaultTableGenerator {
    Project project = null;
    private Map tableMap = null;
    private Map fieldMap = null;

    public DefaultTableGenerator(Project project) {
        this.project = project;
        this.tableMap = new HashMap();
        this.fieldMap = new HashMap();
    }

    public TableCreator generateDefaultTableCreator() {
        TableCreator tblCreator = new TableCreator();
        for (ClassDescriptor desc : this.project.getDescriptors().values()) {
            if (desc.isAggregateDescriptor()) continue;
            this.initTableSchema(desc);
        }
        for (ClassDescriptor desc : this.project.getOrderedDescriptors()) {
            if (desc.isAggregateDescriptor()) continue;
            this.postInitTableSchema(desc);
        }
        tblCreator.addTableDefinitions(this.tableMap.values());
        return tblCreator;
    }

    public TableCreator generateFilteredDefaultTableCreator(AbstractSession session) throws DatabaseException {
        TableCreator tblCreator = this.generateDefaultTableCreator();
        try {
            Connection conn = null;
            if (session.isServerSession()) {
                conn = ((ServerSession)session).getDefaultConnectionPool().acquireConnection().getConnection();
            } else if (session.isDatabaseSession()) {
                conn = ((DatabaseSessionImpl)session).getAccessor().getConnection();
            }
            if (conn == null) {
                return tblCreator;
            }
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ResultSet resultSet = dbMetaData.getTables(null, dbMetaData.getUserName(), null, new String[]{"TABLE"});
            ArrayList<String> tablesInDatabase = new ArrayList<String>();
            while (resultSet.next()) {
                tablesInDatabase.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            ArrayList<TableDefinition> existedTables = new ArrayList<TableDefinition>();
            ArrayList<String> existedTableNames = new ArrayList<String>();
            for (TableDefinition tblDef : tblCreator.getTableDefinitions()) {
                if (!tablesInDatabase.contains(tblDef.getFullName())) continue;
                existedTables.add(tblDef);
                existedTableNames.add(tblDef.getFullName());
            }
            if (!existedTableNames.isEmpty()) {
                session.getSessionLog().log(1, "skip_create_existing_tables", existedTableNames);
                tblCreator.getTableDefinitions().removeAll(existedTables);
            }
        }
        catch (SQLException sqlEx) {
            throw DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
        }
        return tblCreator;
    }

    protected void initTableSchema(ClassDescriptor desc) {
        TableDefinition tblDef = null;
        DatabaseTable dbTbl2 = null;
        for (DatabaseTable dbTbl2 : desc.getTables()) {
            tblDef = this.getTableDefFromDBTable(dbTbl2);
        }
        Iterator fieldIter = desc.getFields().iterator();
        DatabaseField dbField = null;
        while (fieldIter.hasNext()) {
            dbField = (DatabaseField)fieldIter.next();
            boolean isPKField = false;
            isPKField = desc.getPrimaryKeyFields().contains(dbField);
            Map secondaryKeyMap = (Map)desc.getAdditionalTablePrimaryKeyFields().get(dbField.getTable());
            if (secondaryKeyMap != null) {
                isPKField = isPKField || secondaryKeyMap.containsValue(dbField);
            }
            FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField, isPKField);
            if (isPKField) {
                String sequenceName = desc.getSequenceNumberName();
                DatabaseLogin login = this.project.getLogin();
                Sequence seq = login.getSequence(sequenceName);
                if (seq instanceof DefaultSequence) {
                    seq = login.getDefaultSequence();
                }
                boolean isIdentity = seq instanceof NativeSequence && seq.shouldAcquireValueAfterInsert();
                fieldDef.setIsIdentity(isIdentity);
            }
            if ((tblDef = (TableDefinition)this.tableMap.get(dbField.getTableName())).getFields().contains(fieldDef)) continue;
            tblDef.addField(fieldDef);
        }
    }

    private void postInitTableSchema(ClassDescriptor desc) {
        for (DatabaseMapping mapping : desc.getMappings()) {
            if (mapping.isManyToManyMapping()) {
                this.buildRelationTableDefinition((ManyToManyMapping)mapping);
                continue;
            }
            if (mapping.isDirectCollectionMapping()) {
                this.buildDirectCollectionTableDefinition((DirectCollectionMapping)mapping, desc);
                continue;
            }
            if (!mapping.isAggregateCollectionMapping()) continue;
            this.addForeignkeyFieldToAggregateTargetTable((AggregateCollectionMapping)mapping);
        }
    }

    private void buildRelationTableDefinition(ManyToManyMapping mapping) {
        TableDefinition tblDef = this.getTableDefFromDBTable(mapping.getRelationTable());
        DatabaseField dbField = null;
        Vector srcFkFields = mapping.getSourceRelationKeyFields();
        for (int index = 0; index < srcFkFields.size(); ++index) {
            dbField = this.resolveDatabaseField((DatabaseField)srcFkFields.get(index), (DatabaseField)mapping.getSourceKeyFields().get(index));
            this.setFieldToRelationTable(dbField, tblDef);
        }
        Vector targFkFields = mapping.getTargetRelationKeyFields();
        for (int index = 0; index < targFkFields.size(); ++index) {
            dbField = this.resolveDatabaseField((DatabaseField)targFkFields.get(index), (DatabaseField)mapping.getTargetKeyFields().get(index));
            this.setFieldToRelationTable(dbField, tblDef);
        }
    }

    private void buildDirectCollectionTableDefinition(DirectCollectionMapping mapping, ClassDescriptor desc) {
        TableDefinition tblDef = this.getTableDefFromDBTable(mapping.getReferenceTable());
        DatabaseField dbField = null;
        Vector refPkFields = mapping.getReferenceKeyFields();
        for (int index = 0; index < refPkFields.size(); ++index) {
            dbField = this.resolveDatabaseField((DatabaseField)refPkFields.get(index), (DatabaseField)mapping.getSourceKeyFields().get(index));
            tblDef.addField(this.getDirectCollectionReferenceKeyFieldDefFromDBField(dbField));
        }
        tblDef.addField(this.getFieldDefFromDBField(mapping.getDirectField(), false));
        if (mapping.isDirectMapMapping()) {
            dbField = ((DirectMapMapping)mapping).getDirectKeyField();
            tblDef.addField(this.getFieldDefFromDBField(dbField, false));
        }
    }

    private void addForeignkeyFieldToAggregateTargetTable(AggregateCollectionMapping mapping) {
        for (DatabaseField dbField : mapping.getTargetForeignKeyFields()) {
            TableDefinition targTblDef = this.getTableDefFromDBTable(dbField.getTable());
            targTblDef.addField(this.getFieldDefFromDBField(dbField, false));
        }
    }

    private TableDefinition getTableDefFromDBTable(DatabaseTable dbTbl) {
        TableDefinition tblDef = (TableDefinition)this.tableMap.get(dbTbl.getName());
        if (tblDef == null) {
            tblDef = new TableDefinition();
            tblDef.setName(dbTbl.getName());
            tblDef.setQualifier(dbTbl.getTableQualifier());
            tblDef.setUniqueKeys(dbTbl.getUniqueConstraints());
            this.tableMap.put(dbTbl.getName(), tblDef);
        }
        return tblDef;
    }

    private DatabaseField resolveDatabaseField(DatabaseField childField, DatabaseField parentField) {
        DatabaseField reslovedDatabaseField = new DatabaseField();
        reslovedDatabaseField.setName(childField.getName());
        reslovedDatabaseField.setType(this.getFieldDefFromDBField(parentField, true).getType());
        return reslovedDatabaseField;
    }

    private FieldDefinition getFieldDefFromDBField(DatabaseField dbField, boolean isPrimaryKey) {
        FieldDefinition fieldDef = (FieldDefinition)this.fieldMap.get(dbField);
        if (fieldDef == null) {
            fieldDef = new FieldDefinition();
            fieldDef.setName(dbField.getName());
            if (dbField.getColumnDefinition().length() > 0) {
                fieldDef.setTypeName(dbField.getColumnDefinition());
            } else {
                Class fieldType = dbField.getType();
                if (fieldType != null) {
                    if (fieldType.equals(ClassConstants.STRING) || fieldType.equals(ClassConstants.APCHAR) || fieldType.equals(ClassConstants.ACHAR)) {
                        fieldDef.setSize(dbField.getLength());
                    } else if (dbField.getPrecision() > 0) {
                        fieldDef.setSize(dbField.getPrecision());
                        fieldDef.setSubSize(dbField.getScale());
                    }
                }
                if (fieldType == null || !fieldType.isPrimitive() && new DatabaseSessionImpl(this.project).getPlatform().getFieldTypeDefinition(fieldType) == null) {
                    AbstractSessionLog.getLog().log(1, "field_type_set_to_java_lang_string", dbField.getQualifiedName(), fieldType);
                    fieldDef.setType(ClassConstants.STRING);
                } else {
                    fieldDef.setType(ConversionManager.getObjectClass(fieldType));
                }
                fieldDef.setShouldAllowNull(dbField.isNullable());
                fieldDef.setUnique(dbField.isUnique());
            }
            fieldDef.setIsPrimaryKey(isPrimaryKey);
            this.fieldMap.put(dbField, fieldDef);
        }
        return fieldDef;
    }

    private FieldDefinition getDirectCollectionReferenceKeyFieldDefFromDBField(DatabaseField dbField) {
        FieldDefinition fieldDef = (FieldDefinition)this.getFieldDefFromDBField(dbField, true).clone();
        fieldDef.setIsPrimaryKey(false);
        return fieldDef;
    }

    private void setFieldToRelationTable(DatabaseField dbField, TableDefinition tblDef) {
        FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField, false);
        if (!tblDef.getFields().contains(fieldDef)) {
            tblDef.addField(this.getFieldDefFromDBField(dbField, false));
        }
    }
}

