/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.tools.schemaframework.SequenceDefinition;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;

public class TableSequenceDefinition
extends SequenceDefinition {
    public String sequenceTableName;
    public String sequenceNameFieldName;
    public String sequenceCounterFieldName;

    public TableSequenceDefinition(String name, String sequenceTableName, String sequenceNameFieldName, String sequenceCounterFieldName) {
        super(name);
        this.setSequenceTableName(sequenceTableName);
        this.setSequenceCounterFieldName(sequenceCounterFieldName);
        this.setSequenceNameFieldName(sequenceNameFieldName);
    }

    public TableSequenceDefinition(TableSequence sequence) {
        this(sequence.getName(), sequence.getTableName(), sequence.getNameFieldName(), sequence.getCounterFieldName());
    }

    public TableSequenceDefinition(String name, TableSequence sequence) {
        this(name, sequence.getTableName(), sequence.getNameFieldName(), sequence.getCounterFieldName());
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getSequenceTableName());
            writer.write("(" + this.getSequenceNameFieldName());
            writer.write(", " + this.getSequenceCounterFieldName());
            writer.write(") values (");
            writer.write("'" + this.getName() + "', 0)");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getSequenceTableName());
            writer.write(" WHERE " + this.getSequenceNameFieldName());
            writer.write(" = '" + this.getName() + "'");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        Vector results = session.executeSelectingCall(new SQLCall("SELECT * FROM " + this.getSequenceTableName() + " WHERE " + this.getSequenceNameFieldName() + " = '" + this.getName() + "'"));
        return !results.isEmpty();
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceCounterFieldName(String sequenceCounterFieldName) {
        this.sequenceCounterFieldName = sequenceCounterFieldName;
    }

    public String getSequenceCounterFieldName() {
        return this.sequenceCounterFieldName;
    }

    public void setSequenceNameFieldName(String sequenceNameFieldName) {
        this.sequenceNameFieldName = sequenceNameFieldName;
    }

    public String getSequenceNameFieldName() {
        return this.sequenceNameFieldName;
    }

    public TableDefinition buildTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName(this.getSequenceTableName());
        definition.addPrimaryKeyField(this.getSequenceNameFieldName(), String.class, 50);
        definition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
        return definition;
    }
}

