/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class LevelBase
extends OlapElementBase
implements Level {
    protected final Hierarchy hierarchy;
    protected final String name;
    protected final String uniqueName;
    protected String description;
    protected final int depth;
    protected final LevelType levelType;
    protected MemberFormatter memberFormatter;
    protected int approxRowCount;

    protected LevelBase(Hierarchy hierarchy, String name, int depth, LevelType levelType) {
        this.hierarchy = hierarchy;
        this.name = name;
        this.uniqueName = Util.makeFqName(hierarchy, name);
        this.depth = depth;
        this.levelType = levelType;
    }

    public void setApproxRowCount(int approxRowCount) {
        this.approxRowCount = approxRowCount;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxLevelName.str(this.getUniqueName());
    }

    public LevelType getLevelType() {
        return this.levelType;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Dimension getDimension() {
        return this.hierarchy.getDimension();
    }

    public int getDepth() {
        return this.depth;
    }

    public Level getChildLevel() {
        int childDepth = this.depth + 1;
        Level[] levels = this.hierarchy.getLevels();
        return childDepth < levels.length ? levels[childDepth] : null;
    }

    public Level getParentLevel() {
        int parentDepth = this.depth - 1;
        Level[] levels = this.hierarchy.getLevels();
        return parentDepth >= 0 ? levels[parentDepth] : null;
    }

    public abstract boolean isAll();

    public boolean isMeasure() {
        return this.hierarchy.getName().equals("Measures");
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        return this.areMembersUnique() ? Util.lookupHierarchyRootMember(schemaReader, this.hierarchy, s, matchType) : null;
    }

    public MemberFormatter getMemberFormatter() {
        return this.memberFormatter;
    }
}

