/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.QueryAxis;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap4j.MondrianOlap4jCellSetMetaData;
import mondrian.olap4j.MondrianOlap4jConnection;
import org.olap4j.Axis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCellSetAxisMetaData
implements CellSetAxisMetaData {
    private final QueryAxis queryAxis;
    private final MondrianOlap4jCellSetMetaData cellSetMetaData;
    private final List<Property> propertyList = new ArrayList<Property>();

    MondrianOlap4jCellSetAxisMetaData(MondrianOlap4jCellSetMetaData cellSetMetaData, QueryAxis queryAxis) {
        if (queryAxis == null) {
            queryAxis = new QueryAxis(false, null, AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined);
        }
        this.queryAxis = queryAxis;
        this.cellSetMetaData = cellSetMetaData;
        for (Id id : queryAxis.getDimensionProperties()) {
            this.propertyList.add((Property)Property.StandardMemberProperty.valueOf((String)id.toStringArray()[0]));
        }
    }

    public Axis getAxisOrdinal() {
        return Axis.Factory.forOrdinal((int)this.queryAxis.getAxisOrdinal().logicalOrdinal());
    }

    public List<Hierarchy> getHierarchies() {
        if (this.queryAxis.getAxisOrdinal().isFilter()) {
            HashSet<Dimension> dimensionSet = new HashSet<Dimension>();
            for (CellSetAxisMetaData cellSetAxisMetaData : this.cellSetMetaData.getAxesMetaData()) {
                for (Hierarchy hierarchy : cellSetAxisMetaData.getHierarchies()) {
                    dimensionSet.add(hierarchy.getDimension());
                }
            }
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Dimension dimension : this.cellSetMetaData.getCube().getDimensions()) {
                if (!dimensionSet.add(dimension)) continue;
                hierarchyList.add(dimension.getDefaultHierarchy());
            }
            for (Hierarchy hierarchy : this.getHierarchiesNonFilter()) {
                if (hierarchy.getDimension().getHierarchies().size() == 1) continue;
                for (int i = 0; i < hierarchyList.size(); ++i) {
                    Hierarchy hierarchy1 = (Hierarchy)hierarchyList.get(i);
                    if (!hierarchy1.getDimension().equals(hierarchy.getDimension()) || hierarchy1 == hierarchy) continue;
                    hierarchyList.set(i, hierarchy);
                }
            }
            return hierarchyList;
        }
        return this.getHierarchiesNonFilter();
    }

    private List<Hierarchy> getHierarchiesNonFilter() {
        Exp exp = this.queryAxis.getSet();
        if (exp == null) {
            return Collections.emptyList();
        }
        Type type = exp.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        MondrianOlap4jConnection olap4jConnection = this.cellSetMetaData.olap4jStatement.olap4jConnection;
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Type elementType : tupleType.elementTypes) {
                hierarchyList.add(olap4jConnection.toOlap4j(elementType.getHierarchy()));
            }
            return hierarchyList;
        }
        return Collections.singletonList(olap4jConnection.toOlap4j(type.getHierarchy()));
    }

    public List<Property> getProperties() {
        return this.propertyList;
    }
}

