/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import java.util.List;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToken<T extends TokenId>
extends Token<T>
implements TokenOrEmbedding<T> {
    private final T id;
    protected TokenList<T> tokenList;
    protected int rawOffset;

    public AbstractToken(T t) {
        assert (t != null);
        this.id = t;
    }

    AbstractToken(T t, int n) {
        this.id = t;
        this.rawOffset = n;
    }

    @Override
    public final T id() {
        return this.id;
    }

    public final TokenList<T> tokenList() {
        return this.tokenList;
    }

    public final void setTokenList(TokenList<T> tokenList) {
        this.tokenList = tokenList;
    }

    public final int rawOffset() {
        return this.rawOffset;
    }

    public final void setRawOffset(int n) {
        this.rawOffset = n;
    }

    @Override
    public final boolean isFlyweight() {
        return this.rawOffset == -1;
    }

    public final void makeFlyweight() {
        this.setRawOffset(-1);
    }

    @Override
    public PartType partType() {
        return PartType.COMPLETE;
    }

    @Override
    public boolean isCustomText() {
        return false;
    }

    @Override
    public int offset(TokenHierarchy<?> tokenHierarchy) {
        if (this.tokenList != null) {
            if (this.tokenList.getClass() == EmbeddedTokenList.class) {
                ((EmbeddedTokenList)this.tokenList).embeddingContainer().updateStatus();
            }
            return this.tokenList.tokenOffset(this);
        }
        return this.rawOffset;
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public Object getProperty(Object object) {
        return null;
    }

    @Override
    public Token<T> joinToken() {
        return null;
    }

    @Override
    public List<? extends Token<T>> joinedParts() {
        return null;
    }

    @Override
    public final AbstractToken<T> token() {
        return this;
    }

    @Override
    public final EmbeddingContainer<T> embedding() {
        return null;
    }

    @Override
    public boolean isRemoved() {
        if (this.tokenList != null) {
            if (this.tokenList.getClass() == EmbeddedTokenList.class) {
                ((EmbeddedTokenList)this.tokenList).embeddingContainer().updateStatus();
            }
            return this.tokenList.isRemoved();
        }
        return !this.isFlyweight();
    }

    public String dumpInfo() {
        return this.dumpInfo(null, null, true, true, 0).toString();
    }

    public StringBuilder dumpInfo(StringBuilder stringBuilder, TokenHierarchy<?> tokenHierarchy, boolean bl, boolean bl2, int n) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(50);
        }
        if (bl) {
            try {
                CharSequence charSequence = this.text();
                if (charSequence != null) {
                    stringBuilder.append('\"');
                    this.dumpTextImpl(stringBuilder, charSequence);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append("<null-text>");
                }
            }
            catch (NullPointerException nullPointerException) {
                stringBuilder.append("NPE in Token.text()!!!");
            }
            stringBuilder.append(' ');
        }
        if (this.isFlyweight()) {
            stringBuilder.append("F(").append(this.length()).append(')');
        } else {
            int n2 = bl2 ? this.offset(tokenHierarchy) : this.rawOffset();
            stringBuilder.append('<').append(n2);
            stringBuilder.append(",").append(n2 + this.length()).append('>');
        }
        stringBuilder.append(' ').append(this.id != null ? this.id.name() + '[' + this.id.ordinal() + ']' : "<null-id>");
        stringBuilder.append(" ").append(this.dumpInfoTokenType());
        return stringBuilder;
    }

    public StringBuilder dumpText(StringBuilder stringBuilder, CharSequence charSequence) {
        assert (this.tokenList == null) : "Should only be called for tokens not yet added to a token-list";
        int n = this.length();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n + 10);
        }
        CharSequence charSequence2 = this.isFlyweight() ? this.text() : charSequence.subSequence(this.rawOffset, this.rawOffset + n);
        this.dumpTextImpl(stringBuilder, charSequence2);
        return stringBuilder;
    }

    private void dumpTextImpl(StringBuilder stringBuilder, CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (n > 400 && i >= 200 && i < n - 200) {
                i = n - 200;
                stringBuilder.append(" ...<TEXT-SHORTENED>... ");
                continue;
            }
            try {
                CharSequenceUtilities.debugChar((StringBuilder)stringBuilder, (char)charSequence.charAt(i));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                stringBuilder.append("IOOBE at index=").append(i).append("!!!");
                break;
            }
        }
    }

    protected String dumpInfoTokenType() {
        return "AbsT";
    }
}

