/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.wizard.AddServerInstanceWizard;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class ServerWizardVisual
extends JPanel {
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final Map<ServerWizardProvider, String> displayNames = new HashMap<ServerWizardProvider, String>();
    private AddServerInstanceWizard wizard;
    private boolean updatingDisplayName = false;
    private JTextField displayNameEditField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList serverListBox;

    public ServerWizardVisual() {
        this.initComponents();
        PriorityQueue<WizardAdapter> priorityQueue = new PriorityQueue<WizardAdapter>(5, new WizardPriority());
        for (int i = 0; i < this.serverListBox.getModel().getSize(); ++i) {
            priorityQueue.add((WizardAdapter)this.serverListBox.getModel().getElementAt(i));
        }
        if (!priorityQueue.isEmpty()) {
            WizardAdapter wizardAdapter = (WizardAdapter)priorityQueue.peek();
            this.serverListBox.setSelectedValue(wizardAdapter, true);
            this.fillDisplayName(wizardAdapter.getServerInstanceWizard());
        }
        this.displayNameEditField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.listeners.remove(changeListener);
        }
    }

    public void read(AddServerInstanceWizard addServerInstanceWizard) {
        Object object;
        if (this.wizard == null) {
            this.wizard = addServerInstanceWizard;
        }
        if ((object = addServerInstanceWizard.getProperty("ServInstWizard_displayName")) != null) {
            this.displayNameEditField.setText((String)object);
        }
    }

    public void store(AddServerInstanceWizard addServerInstanceWizard) {
        addServerInstanceWizard.putProperty("ServInstWizard_displayName", this.displayNameEditField.getText());
        Object e = this.serverListBox.getSelectedValue();
        if (e != null) {
            addServerInstanceWizard.putProperty("ServInstWizard_server", ((WizardAdapter)e).getServerInstanceWizard());
        }
    }

    boolean hasValidData() {
        boolean bl;
        boolean bl2 = bl = this.isServerValid() && this.isDisplayNameValid();
        if (bl) {
            this.wizard.setErrorMessage(null);
        }
        return bl;
    }

    private boolean isServerValid() {
        boolean bl;
        boolean bl2 = bl = this.serverListBox.getSelectedValue() != null;
        if (!bl) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_ChooseServer"));
        }
        return bl;
    }

    private boolean isDisplayNameValid() {
        String string = this.displayNameEditField.getText().trim();
        if (string.length() <= 0) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_DisplayName"));
            return false;
        }
        if (this.existsDisplayName(string)) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_DisplayNameExists"));
            return false;
        }
        return true;
    }

    private boolean existsDisplayName(String string) {
        for (ServerInstanceProvider serverInstanceProvider : ServerRegistry.getInstance().getProviders()) {
            for (ServerInstance serverInstance : serverInstanceProvider.getInstances()) {
                if (!serverInstance.getDisplayName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void displayNameEditFieldUpdate() {
        if (!this.updatingDisplayName) {
            this.fireChange();
        }
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String generateDisplayName(ServerWizardProvider serverWizardProvider) {
        String string;
        int n = 0;
        do {
            string = serverWizardProvider.getDisplayName();
            if (n != 0) {
                string = string + " (" + String.valueOf(n) + ")";
            }
            ++n;
        } while (this.existsDisplayName(string));
        return string;
    }

    private void fillDisplayName(ServerWizardProvider serverWizardProvider) {
        String string = this.displayNames.get(serverWizardProvider);
        if (string == null) {
            string = this.generateDisplayName(serverWizardProvider);
        }
        this.updatingDisplayName = true;
        this.displayNameEditField.setText(string);
        this.updatingDisplayName = false;
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameEditField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.serverListBox = new JList();
        this.setName(NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_Name"));
        this.jLabel1.setLabelFor(this.serverListBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_Server"));
        this.jLabel2.setLabelFor(this.displayNameEditField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_DisplayName"));
        this.displayNameEditField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ServerWizardVisual.this.displayNameEditFieldKeyReleased(keyEvent);
            }
        });
        this.serverListBox.setModel(new WizardListModel());
        this.serverListBox.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ServerWizardVisual.this.serverListBoxValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.serverListBox);
        this.serverListBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME_Server"));
        this.serverListBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC_Server"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.displayNameEditField, -1, 375, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 375, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.displayNameEditField, -2, -1, -2)).addContainerGap()));
        this.displayNameEditField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME_DisplayName"));
        this.displayNameEditField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC_DisplayName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC"));
    }

    private void serverListBoxValueChanged(ListSelectionEvent listSelectionEvent) {
        ServerWizardProvider serverWizardProvider;
        if (!listSelectionEvent.getValueIsAdjusting() && (serverWizardProvider = ((WizardAdapter)this.serverListBox.getSelectedValue()).getServerInstanceWizard()) != null) {
            this.fillDisplayName(serverWizardProvider);
        }
    }

    private void displayNameEditFieldKeyReleased(KeyEvent keyEvent) {
        WizardAdapter wizardAdapter = (WizardAdapter)this.serverListBox.getSelectedValue();
        if (wizardAdapter != null) {
            this.displayNames.put(wizardAdapter.getServerInstanceWizard(), this.displayNameEditField.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WizardPriority
    implements Comparator<WizardAdapter>,
    Serializable {
        private static final List<Pattern> PRIORITY_LIST = new ArrayList<Pattern>(4);

        private WizardPriority() {
        }

        @Override
        public int compare(WizardAdapter wizardAdapter, WizardAdapter wizardAdapter2) {
            Integer n = this.computePriority(wizardAdapter.getServerInstanceWizard().getDisplayName());
            Integer n2 = this.computePriority(wizardAdapter2.getServerInstanceWizard().getDisplayName());
            return -n.compareTo(n2);
        }

        private int computePriority(String string) {
            int n = 0;
            for (int i = 0; i < PRIORITY_LIST.size(); ++i) {
                if (!PRIORITY_LIST.get(i).matcher(string).matches()) continue;
                n = i;
            }
            return n;
        }

        static {
            PRIORITY_LIST.add(Pattern.compile(".*Sailfin.*"));
            PRIORITY_LIST.add(Pattern.compile(".*Sun\\s*Java\\s*System.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*V1.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*V2.*"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WizardAdapter
    implements Comparable<WizardAdapter> {
        private final ServerWizardProvider serverInstanceWizard;

        public WizardAdapter(ServerWizardProvider serverWizardProvider) {
            this.serverInstanceWizard = serverWizardProvider;
        }

        public ServerWizardProvider getServerInstanceWizard() {
            return this.serverInstanceWizard;
        }

        @Override
        public int compareTo(WizardAdapter wizardAdapter) {
            return this.serverInstanceWizard.getDisplayName().compareTo(wizardAdapter.getServerInstanceWizard().getDisplayName());
        }

        public String toString() {
            return this.serverInstanceWizard.getDisplayName();
        }
    }

    private static class WizardListModel
    implements ListModel {
        private final List<WizardAdapter> serverWizards = new ArrayList<WizardAdapter>();

        public WizardListModel() {
            for (ServerWizardProvider serverWizardProvider : Lookups.forPath((String)"Servers").lookupAll(ServerWizardProvider.class)) {
                if (serverWizardProvider.getInstantiatingIterator() == null) continue;
                this.serverWizards.add(new WizardAdapter(serverWizardProvider));
            }
            Collections.sort(this.serverWizards);
        }

        public Object getElementAt(int n) {
            return this.serverWizards.get(n);
        }

        public int getSize() {
            return this.serverWizards.size();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

