/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.ext.DataAccessor;
import org.netbeans.editor.ext.FileAccessor;
import org.netbeans.editor.ext.StringCache;

public class FileStorage {
    private static final int MAX_STRING = 60000;
    private static final int BYTES_INCREMENT = 2048;
    private static final byte[] EMPTY_BYTES = new byte[0];
    Thread currentLock;
    protected boolean openedForWrite;
    public boolean fileNotFound = false;
    protected DataAccessor da;
    protected boolean opened = false;
    protected int offset;
    protected byte[] bytes = EMPTY_BYTES;
    char[] chars = Analyzer.EMPTY_CHAR_ARRAY;
    StringCache strCache;
    private int lockDeep;
    private static final String WRITE_LOCK_MISSING = "Unlock file without previous lock file";
    private int version = 1;
    private static final int BIT7 = 128;
    private static final int BIT6 = 64;
    private static final int BIT5 = 32;

    public FileStorage(String string) {
        this(string, new StringCache());
    }

    public FileStorage(String string, StringCache stringCache) {
        this.da = new FileAccessor(new File(string));
        this.strCache = stringCache;
    }

    public FileStorage(DataAccessor dataAccessor, StringCache stringCache) {
        this.da = dataAccessor;
        this.strCache = stringCache;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void open(boolean bl) throws IOException {
        if (this.openedForWrite == bl) {
            this.ensureOpen(bl);
            this.da.seek(this.getFileLength());
            return;
        }
        this.close();
        this.ensureOpen(bl);
        this.da.seek(this.getFileLength());
        this.openedForWrite = bl;
        this.offset = 0;
    }

    private void ensureOpen(boolean bl) throws IOException {
        if (!this.opened) {
            this.da.open(bl);
            this.opened = true;
        }
    }

    public void close() throws IOException {
        this.opened = false;
        this.da.close();
    }

    protected void checkBytesSize(int n) {
        if (this.bytes.length < n) {
            byte[] byArray = new byte[n + 2048];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
    }

    public void read(int n) throws IOException {
        this.checkBytesSize(n);
        this.da.read(this.bytes, 0, n);
        this.offset = 0;
    }

    public void write() throws IOException {
        if (this.offset > 0) {
            this.da.append(this.bytes, 0, this.offset);
        }
        this.offset = 0;
    }

    public void seek(int n) throws IOException {
        this.da.seek(n);
    }

    public String getFileName() {
        return this.da.toString();
    }

    public int getFilePointer() throws IOException {
        return (int)this.da.getFilePointer();
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFileLength() throws IOException {
        return this.da.getFileLength();
    }

    public void resetBytes() {
        this.bytes = EMPTY_BYTES;
    }

    public void resetFile() throws IOException {
        this.open(true);
        this.offset = 0;
        this.da.resetFile();
        this.close();
    }

    public int getInteger() {
        if (this.version == 1) {
            int n = this.bytes[this.offset++];
            n = (n << 8) + (this.bytes[this.offset++] & 0xFF);
            n = (n << 8) + (this.bytes[this.offset++] & 0xFF);
            n = (n << 8) + (this.bytes[this.offset++] & 0xFF);
            return n;
        }
        if (this.version == 2) {
            return this.decodeInteger();
        }
        return 0;
    }

    public String getString() {
        int n = this.getInteger();
        if (n < 0) {
            throw new RuntimeException("Consistency error: read string length=" + n);
        }
        if (n > 60000) {
            throw new RuntimeException("FileStorage: String len is " + n + ". There's probably a corruption in the file '" + this.getFileName() + "'.");
        }
        if (this.version == 1) {
            if (this.chars.length < n) {
                this.chars = new char[2 * n];
            }
            for (int i = 0; i < n; ++i) {
                this.chars[i] = (char)((this.bytes[this.offset] << 8) + (this.bytes[this.offset + 1] & 0xFF));
                this.offset += 2;
            }
            String string = null;
            if (n >= 0) {
                string = this.strCache != null ? this.strCache.getString(this.chars, 0, n) : new String(this.chars, 0, n);
            }
            return string;
        }
        if (this.version == 2) {
            try {
                String string = new String(this.bytes, this.offset, n, this.getEncoding());
                this.offset += n;
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                StringBuffer stringBuffer = new StringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((char)this.bytes[this.offset + i]);
                }
                String string = stringBuffer.toString();
                throw new RuntimeException("Debug of #12932: If this bug occurs, please send the stacktrace as attachment to Issuezilla's #12932.\nhttp://www.netbeans.org/issues/show_bug.cgi?id=12932\ndebug 2\nFile:" + this.toString() + "\n" + "File Version:" + this.version + "\n" + "Offest: " + this.offset + "\n" + "Read length: " + n + "\n" + "bytes.length: " + this.bytes.length + "\n" + "String:" + string + "\n" + "Error:" + arrayIndexOutOfBoundsException);
            }
        }
        return "";
    }

    public void putInteger(int n) {
        if (this.version == 1) {
            this.checkBytesSize(this.offset + 4);
            this.bytes[this.offset + 3] = (byte)(n & 0xFF);
            this.bytes[this.offset + 2] = (byte)((n >>>= 8) & 0xFF);
            this.bytes[this.offset + 1] = (byte)((n >>>= 8) & 0xFF);
            this.bytes[this.offset] = (byte)(n >>>= 8);
            this.offset += 4;
        }
        if (this.version == 2) {
            this.encodeInteger(n);
        }
    }

    public void putString(String string) {
        if (string == null) {
            return;
        }
        if (this.version == 1) {
            int n = string.length();
            this.putInteger(n);
            if (n > 0) {
                this.checkBytesSize(this.offset + n * 2);
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    this.bytes[this.offset + 1] = (byte)(c & 0xFF);
                    c = (char)(c >>> 8);
                    this.bytes[this.offset] = (byte)(c & 0xFF);
                    this.offset += 2;
                }
            }
        } else if (this.version == 2) {
            byte[] byArray;
            try {
                byArray = string.getBytes(this.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            int n = Array.getLength(byArray);
            if (n < 0) {
                return;
            }
            this.putInteger(n);
            this.checkBytesSize(this.offset + n);
            System.arraycopy(byArray, 0, this.bytes, this.offset, n);
            this.offset += n;
        }
    }

    private int decodeInteger() {
        int n;
        if (((n = this.bytes[this.offset++] & 0xFF) & 0x80) == 0) {
            return n;
        }
        int n2 = 1;
        if ((n & 0x40) != 0) {
            n2 += 2;
        }
        if ((n & 0x20) != 0) {
            ++n2;
        }
        n &= 0xFFFFFF1F;
        for (int i = 1; i <= n2; ++i) {
            n = (n << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        return n;
    }

    private void encodeInteger(int n) {
        int n2 = 0;
        if (n >= 0x20000000) {
            n2 += 4;
        } else if (n >= 0x200000) {
            n2 += 3;
        } else if (n >= 8192) {
            n2 += 2;
        } else if (n >= 128) {
            ++n2;
        }
        this.checkBytesSize(this.offset + n2 + 1);
        for (int i = n2; i > 0; --i) {
            this.bytes[this.offset + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        this.bytes[this.offset] = (byte)n;
        switch (n2) {
            case 2: {
                int n3 = this.offset;
                this.bytes[n3] = (byte)(this.bytes[n3] | 0x20);
                break;
            }
            case 3: {
                int n4 = this.offset;
                this.bytes[n4] = (byte)(this.bytes[n4] | 0x40);
                break;
            }
            case 4: {
                int n5 = this.offset;
                this.bytes[n5] = (byte)(this.bytes[n5] | 0x20);
                int n6 = this.offset;
                this.bytes[n6] = (byte)(this.bytes[n6] | 0x40);
            }
        }
        if (n2 > 0) {
            int n7 = this.offset;
            this.bytes[n7] = (byte)(this.bytes[n7] | 0x80);
        }
        this.offset += ++n2;
    }

    private String getEncoding() {
        switch (this.version) {
            case 1: {
                return "UTF-16BE";
            }
            case 2: {
                return "UTF-8";
            }
        }
        return "UTF-16BE";
    }

    public final synchronized void lockFile() {
        if (this.currentLock == null || Thread.currentThread() != this.currentLock) {
            try {
                if (this.currentLock == null) {
                    this.currentLock = Thread.currentThread();
                    this.lockDeep = 0;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException.toString());
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                throw new RuntimeException(illegalMonitorStateException.toString());
            }
        } else {
            ++this.lockDeep;
        }
    }

    public final synchronized void unlockFile() {
        if (Thread.currentThread() != this.currentLock) {
            throw new RuntimeException(WRITE_LOCK_MISSING);
        }
        if (this.lockDeep == 0) {
            this.resetBytes();
            this.notify();
            this.currentLock = null;
        } else {
            --this.lockDeep;
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

