/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.callouts;

import com.jaspersoft.ireport.addons.callouts.CalloutWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalloutInplaceEditorProvider
implements InplaceEditorProvider<JTextArea> {
    private TextFieldInplaceEditor editor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public CalloutInplaceEditorProvider(TextFieldInplaceEditor editor) {
        this.editor = editor;
        this.expansionDirections = EnumSet.of(InplaceEditorProvider.ExpansionDirection.BOTTOM);
    }

    public JTextArea createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        if (!this.editor.isEnabled(widget)) {
            return null;
        }
        final JTextArea field = new JTextArea(this.editor.getText(widget));
        final Widget widget2 = widget;
        field.setWrapStyleWord(true);
        field.setLineWrap(true);
        double zoomFactor = widget.getScene().getZoomFactor();
        if (zoomFactor != 1.0 && field.getFont() != null) {
            Font font = field.getFont();
            font = font.deriveFont((float)((double)font.getSize2D() * zoomFactor));
            field.setFont(font);
        }
        field.setBorder(new EmptyBorder(0, (int)(2.0 * zoomFactor), 0, (int)(2.0 * zoomFactor)));
        field.selectAll();
        field.setBackground(new Color(253, 255, 127));
        field.setOpaque(true);
        field.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CalloutInplaceEditorProvider.this.recalculateBounds(field, widget2);
            }

            public void removeUpdate(DocumentEvent e) {
                CalloutInplaceEditorProvider.this.recalculateBounds(field, widget2);
            }

            public void changedUpdate(DocumentEvent e) {
                CalloutInplaceEditorProvider.this.recalculateBounds(field, widget2);
            }
        });
        return field;
    }

    public void recalculateBounds(JTextArea field, Widget w) {
        ((CalloutWidget)w).setText(field.getText());
        Dimension d = field.getPreferredSize();
        w.getScene().validate();
        w.getScene().repaint();
        Rectangle r = this.getInitialEditorComponentBounds(null, w, field, null);
        field.setSize(r.width, r.height);
    }

    private Font getFont(Widget widget) {
        Scene scene = widget.getScene();
        Font font = widget.getFont();
        if (scene.getZoomFactor() != 1.0) {
            font = font.deriveFont((float)((double)font.getSize2D() * scene.getZoomFactor()));
        }
        return font;
    }

    public void notifyOpened(final InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor) {
        final JTextArea editor2 = editor;
        final Widget widget2 = widget;
        editor.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case '\u001b': {
                        e.consume();
                        controller.closeEditor(false);
                        break;
                    }
                    case '\n': {
                        break;
                    }
                    case 'H': {
                        System.out.println("JTextArea: " + editor2.getFont());
                        System.out.println("JTextArea: " + ((Graphics2D)editor2.getGraphics()).getRenderingHints());
                        System.out.flush();
                        System.out.println("Widget  " + widget2.getFont());
                        System.out.flush();
                    }
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                controller.closeEditor(true);
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }
        };
        editor.addKeyListener(this.keyListener);
        editor.addFocusListener(this.focusListener);
        editor.getDocument().addDocumentListener(this.documentListener);
        editor.selectAll();
    }

    public void notifyClosing(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor, boolean commit) {
        editor.getDocument().removeDocumentListener(this.documentListener);
        editor.removeFocusListener(this.focusListener);
        editor.removeKeyListener(this.keyListener);
        if (commit) {
            this.editor.setText(widget, editor.getText());
            if (widget != null) {
                widget.getScene().validate();
            }
        }
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor, Rectangle viewBounds) {
        return new Rectangle((int)((double)(widget.getLocation().x + widget.getBorder().getInsets().left + 10) * widget.getScene().getZoomFactor()), (int)((double)(widget.getLocation().y + widget.getBorder().getInsets().top + 10) * widget.getScene().getZoomFactor()), (int)((double)(widget.getBounds().width - widget.getBorder().getInsets().left - widget.getBorder().getInsets().right) * widget.getScene().getZoomFactor()), (int)((double)(widget.getBounds().height - widget.getBorder().getInsets().top - widget.getBorder().getInsets().bottom) * widget.getScene().getZoomFactor()));
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor) {
        return null;
    }
}

