/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewDBTable {
    private final DBTable[] dbTables;
    private final List<DBColumn> columns;
    private String[] columnTooltipStr;

    public DataViewDBTable(Collection<DBTable> collection) {
        assert (collection != null);
        this.dbTables = new DBTable[collection.size()];
        ArrayList<DBColumn> arrayList = new ArrayList<DBColumn>();
        for (DBTable dBTable : collection.toArray(this.dbTables)) {
            arrayList.addAll(dBTable.getColumnList());
        }
        Collections.sort(arrayList, new ColumnOrderComparator());
        this.columns = Collections.unmodifiableList(arrayList);
    }

    public DBTable geTable(int n) {
        return this.dbTables[n];
    }

    public int geTableCount() {
        return this.dbTables.length;
    }

    public boolean hasOneTable() {
        return this.dbTables != null && this.dbTables.length == 1 && !this.dbTables[0].getName().equals("");
    }

    public String getFullyQualifiedName(int n) {
        return this.dbTables[n].getFullyQualifiedName();
    }

    public DBColumn getColumn(int n) {
        return this.columns.get(n);
    }

    public int getColumnType(int n) {
        return this.columns.get(n).getJdbcType();
    }

    public String getColumnName(int n) {
        return this.columns.get(n).getName();
    }

    public String getQualifiedName(int n) {
        return this.columns.get(n).getQualifiedName();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public synchronized Map getColumns() {
        HashMap<String, DBColumn> hashMap = new HashMap<String, DBColumn>();
        for (DBTable dBTable : this.dbTables) {
            hashMap.putAll(dBTable.getColumns());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public synchronized String[] getColumnToolTips() {
        if (this.columnTooltipStr == null) {
            this.columnTooltipStr = new String[this.columns.size()];
            int n = 0;
            for (DBColumn dBColumn : this.columns) {
                this.columnTooltipStr[n++] = DataViewUtils.getColumnToolTip(dBColumn);
            }
        }
        return this.columnTooltipStr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ColumnOrderComparator
    implements Comparator<DBColumn> {
        private ColumnOrderComparator() {
        }

        @Override
        public int compare(DBColumn dBColumn, DBColumn dBColumn2) {
            return dBColumn.getOrdinalPosition() - dBColumn2.getOrdinalPosition();
        }
    }
}

