/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.GenericDesignerPanel;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.crosstab.CellInfo;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.sheet.GenericProperty;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static JRDesignCrosstabParameter cloneCrosstabParameter(JRDesignCrosstabParameter param) {
        JRDesignCrosstabParameter newParam = new JRDesignCrosstabParameter();
        newParam.setName(param.getName());
        newParam.setForPrompting(param.isForPrompting());
        newParam.setSystemDefined(param.isSystemDefined());
        newParam.setValueClassName(param.getValueClassName());
        newParam.setDescription(param.getDescription());
        if (param.getDefaultValueExpression() != null) {
            newParam.setDefaultValueExpression((JRExpression)ModelUtils.cloneExpression((JRExpression)((JRDesignExpression)param.getDefaultValueExpression())));
        }
        ModelUtils.replacePropertiesMap(param.getPropertiesMap(), newParam.getPropertiesMap());
        return newParam;
    }

    public static JRDesignStyle cloneStyle(JRDesignStyle style) {
        JRDesignStyle newStyle = (JRDesignStyle)style.clone();
        return newStyle;
    }

    public static List<JRDesignElement> getAllElements(JasperDesign jd, boolean includeCrosstabs) {
        ArrayList<JRDesignElement> list = new ArrayList<JRDesignElement>();
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand band : bands) {
            list.addAll(ModelUtils.getAllElements((JRElementGroup)band));
        }
        if (includeCrosstabs) {
            ArrayList<JRDesignElement> list2 = new ArrayList<JRDesignElement>();
            for (int i = 0; i < list.size(); ++i) {
                JRDesignElement ele = (JRDesignElement)list.get(i);
                if (!(ele instanceof JRDesignCrosstab)) continue;
                list2.addAll(ModelUtils.getAllElements((JRDesignCrosstab)ele));
            }
            list.addAll(list2);
        }
        return list;
    }

    public static List<JRDesignElement> getAllElements(JRDesignCrosstab crosstab) {
        ArrayList<JRDesignElement> list = new ArrayList<JRDesignElement>();
        List<JRDesignCellContents> cells = ModelUtils.getAllCells(crosstab);
        for (JRDesignCellContents content : cells) {
            list.addAll(ModelUtils.getAllElements((JRElementGroup)content));
        }
        return list;
    }

    public static List<JRDesignElement> getAllElements(JasperDesign jd) {
        return ModelUtils.getAllElements(jd, true);
    }

    public static List<JRDesignElement> getAllElements(JRElementGroup group) {
        ArrayList<JRDesignElement> list = new ArrayList<JRDesignElement>();
        if (group == null) {
            return list;
        }
        List elements = group.getChildren();
        for (Object ele : elements) {
            if (ele instanceof JRElementGroup) {
                list.addAll(ModelUtils.getAllElements((JRElementGroup)ele));
            }
            if (!(ele instanceof JRDesignElement)) continue;
            list.add((JRDesignElement)ele);
            if (!(ele instanceof JRDesignCrosstab)) continue;
            JRDesignCrosstab crosstab = (JRDesignCrosstab)ele;
            List cells = crosstab.getCellsList();
            for (int i = 0; i < cells.size(); ++i) {
                JRCrosstabCell cell = (JRCrosstabCell)cells.get(i);
                list.addAll(ModelUtils.getAllElements((JRElementGroup)cell.getContents()));
            }
        }
        return list;
    }

    public static List<JRBand> getBands(JasperDesign jd) {
        int k;
        int i;
        ArrayList<JRBand> list = new ArrayList<JRBand>();
        if (jd == null) {
            return list;
        }
        JRGroup[] groups = jd.getGroups();
        if (null != jd.getTitle()) {
            list.add(jd.getTitle());
        }
        if (null != jd.getPageHeader()) {
            list.add(jd.getPageHeader());
        }
        if (null != jd.getColumnHeader()) {
            list.add(jd.getColumnHeader());
        }
        for (i = 0; i < groups.length; ++i) {
            if (groups[i].getGroupHeaderSection() == null) continue;
            JRBand[] bandsList = groups[i].getGroupHeaderSection().getBands();
            for (k = 0; bandsList != null && k < bandsList.length; ++k) {
                if (bandsList[k] == null) continue;
                list.add(bandsList[k]);
            }
        }
        if (jd.getDetailSection() != null) {
            JRBand[] bandsList = jd.getDetailSection().getBands();
            for (int k2 = 0; bandsList != null && k2 < bandsList.length; ++k2) {
                if (bandsList[k2] == null) continue;
                list.add(bandsList[k2]);
            }
        }
        for (i = groups.length - 1; i >= 0; --i) {
            if (groups[i].getGroupFooterSection() == null) continue;
            JRBand[] bandsList = groups[i].getGroupFooterSection().getBands();
            for (k = 0; bandsList != null && k < bandsList.length; ++k) {
                if (bandsList[k] == null) continue;
                list.add(bandsList[k]);
            }
        }
        if (null != jd.getColumnFooter()) {
            list.add(jd.getColumnFooter());
        }
        if (null != jd.getPageFooter()) {
            list.add(jd.getPageFooter());
        }
        if (null != jd.getLastPageFooter()) {
            list.add(jd.getLastPageFooter());
        }
        if (null != jd.getSummary()) {
            list.add(jd.getSummary());
        }
        if (null != jd.getNoData()) {
            list.add(jd.getNoData());
        }
        if (null != jd.getBackground()) {
            list.add(jd.getBackground());
        }
        return list;
    }

    public static int getHeaderCellWidth(JRDesignCrosstab crosstab) {
        if (crosstab == null) {
            return 0;
        }
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        int tot = 0;
        for (int i = 0; i < row_groups.length; ++i) {
            tot += row_groups[i].getWidth();
        }
        return tot;
    }

    public static int getHeaderCellHeight(JRDesignCrosstab crosstab) {
        if (crosstab == null) {
            return 0;
        }
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        int tot = 0;
        for (int i = 0; i < col_groups.length; ++i) {
            tot += col_groups[i].getHeight();
        }
        return tot;
    }

    public static int findRowHeight(JRCrosstabCell[][] cells, int rowIndex) {
        for (int i = 0; i < cells[rowIndex].length; ++i) {
            if (cells[rowIndex][i] == null || cells[rowIndex][i].getContents() == null) continue;
            return cells[rowIndex][i].getContents().getHeight();
        }
        return 0;
    }

    public static int findColumnWidth(JRCrosstabCell[][] cells, int colIndex) {
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i][colIndex] == null || cells[i][colIndex].getContents() == null) continue;
            return cells[i][colIndex].getContents().getWidth();
        }
        return 0;
    }

    public static JRDesignCellContents getCellAt(JRDesignCrosstab crosstab, Point point) {
        return ModelUtils.getCellAt(crosstab, point, false);
    }

    public static JRDesignCellContents getCellAt(JRDesignCrosstab crosstab, Point point, boolean createIt) {
        Rectangle rect3;
        Rectangle rect2;
        Rectangle rect1;
        int i;
        List<CellInfo> cellInfos = ModelUtils.getCellInfos(crosstab);
        int header_width = 0;
        int header_height = 0;
        for (int i2 = 0; i2 < cellInfos.size(); ++i2) {
            CellInfo ci = cellInfos.get(i2);
            Rectangle rect = new Rectangle(ci.getLeft(), ci.getTop(), ci.getCellContents().getWidth(), ci.getCellContents().getHeight());
            if (rect.contains(point)) {
                return ci.getCellContents();
            }
            if (ci.getY() == crosstab.getColumnGroups().length) {
                header_height = ci.getTop();
            }
            if (ci.getX() != crosstab.getRowGroups().length) continue;
            header_width = ci.getLeft();
        }
        if (!createIt) {
            return null;
        }
        Rectangle rectHeaderCell = new Rectangle(0, 0, header_width, header_height);
        if (rectHeaderCell.contains(point)) {
            crosstab.setHeaderCell(new JRDesignCellContents());
            return (JRDesignCellContents)crosstab.getHeaderCell();
        }
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = ModelUtils.normalizeCell(crosstab.getCells(), row_groups, col_groups);
        int x = header_width;
        int y = header_height;
        Rectangle r1 = new Rectangle(0, 0, header_width, header_height);
        if (r1.contains(point)) {
            return (JRDesignCellContents)crosstab.getHeaderCell();
        }
        for (int i3 = cells.length - 1; i3 >= 0; --i3) {
            x = header_width;
            for (int k = cells[i3].length - 1; k >= 0; --k) {
                JRCrosstabCell cell = cells[i3][k];
                if (cell == null) continue;
                Rectangle rect = new Rectangle(x, y, cell.getContents().getWidth(), cell.getContents().getHeight());
                if (rect.contains(point)) {
                    if (cell.getContents() == null && createIt) {
                        ((JRDesignCrosstabCell)cell).setContents(new JRDesignCellContents());
                    }
                    return (JRDesignCellContents)cell.getContents();
                }
                x += ModelUtils.findColumnWidth(cells, k);
            }
            y += ModelUtils.findRowHeight(cells, i3);
        }
        int data_width = x - header_width;
        int data_height = y - header_height;
        x = 0;
        y = header_height;
        for (i = 0; i < row_groups.length; ++i) {
            switch (row_groups[i].getTotalPositionValue()) {
                case START: {
                    rect1 = new Rectangle(x, y, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight());
                    if (rect1.contains(point)) {
                        if ((JRDesignCellContents)row_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)row_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)row_groups[i].getTotalHeader();
                    }
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                    y += row_groups[i].getTotalHeader().getHeight();
                    break;
                }
                case END: {
                    int y_loc = y + data_height - row_groups[i].getTotalHeader().getHeight();
                    rect2 = new Rectangle(x, y_loc, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight());
                    if (rect2.contains(point)) {
                        if ((JRDesignCellContents)row_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)row_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)row_groups[i].getTotalHeader();
                    }
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                }
            }
            rect3 = new Rectangle(x, y, row_groups[i].getHeader().getWidth(), row_groups[i].getHeader().getHeight());
            if (rect3.contains(point)) {
                if ((JRDesignCellContents)row_groups[i].getHeader() == null && createIt) {
                    ((JRDesignCrosstabGroup)row_groups[i]).setHeader(new JRDesignCellContents());
                }
                return (JRDesignCellContents)row_groups[i].getHeader();
            }
            x += row_groups[i].getHeader().getWidth();
        }
        x = header_width;
        y = 0;
        for (i = 0; i < col_groups.length; ++i) {
            switch (col_groups[i].getTotalPositionValue()) {
                case START: {
                    rect1 = new Rectangle(x, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight());
                    if (rect1.contains(point)) {
                        if ((JRDesignCellContents)col_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)col_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)col_groups[i].getTotalHeader();
                    }
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    x += col_groups[i].getTotalHeader().getWidth();
                    break;
                }
                case END: {
                    int x_loc = x + data_width - col_groups[i].getTotalHeader().getWidth();
                    rect2 = new Rectangle(x_loc, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight());
                    if (rect2.contains(point)) {
                        if ((JRDesignCellContents)col_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)col_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)col_groups[i].getTotalHeader();
                    }
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    break;
                }
            }
            rect3 = new Rectangle(x, y, col_groups[i].getHeader().getWidth(), col_groups[i].getHeader().getHeight());
            if (rect3.contains(point)) {
                if ((JRDesignCellContents)col_groups[i].getHeader() == null && createIt) {
                    ((JRDesignCrosstabGroup)col_groups[i]).setHeader(new JRDesignCellContents());
                }
                return (JRDesignCellContents)col_groups[i].getHeader();
            }
            y += col_groups[i].getHeader().getHeight();
        }
        return null;
    }

    public static List<CellInfo> getCellInfos(JRDesignCrosstab crosstab) {
        CellInfo ci;
        CellInfo ci2;
        CellInfo ci3;
        JRCrosstabColumnGroup group;
        int i;
        ArrayList<CellInfo> cellInfos = new ArrayList<CellInfo>();
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        if (crosstab.getHeaderCell() != null) {
            CellInfo ci4 = new CellInfo(x, y, row_groups.length, col_groups.length, crosstab.getHeaderCell());
            cellInfos.add(ci4);
        }
        x = row_groups.length;
        y = 0;
        int w = 1;
        for (int i2 = 0; i2 < col_groups.length; ++i2) {
            JRCrosstabColumnGroup group2 = col_groups[i2];
            if (group2.getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) continue;
            ++w;
        }
        int h = col_groups.length;
        for (i = 0; i < col_groups.length; ++i) {
            group = col_groups[i];
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                ci3 = new CellInfo(x, y, 1, h, group.getTotalHeader());
                cellInfos.add(ci3);
                ++x;
                --w;
            }
            ci2 = new CellInfo(x, y, w, 1, group.getHeader());
            cellInfos.add(ci2);
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.END) {
                ci = new CellInfo(x + w - 1, y, 1, h, group.getTotalHeader());
                cellInfos.add(ci);
                --w;
            }
            --h;
            ++y;
        }
        x = 0;
        y = col_groups.length;
        w = row_groups.length;
        h = 1;
        for (i = 0; i < row_groups.length; ++i) {
            group = row_groups[i];
            if (group.getTotalPosition() == 0) continue;
            ++h;
        }
        for (i = 0; i < row_groups.length; ++i) {
            group = row_groups[i];
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                ci3 = new CellInfo(x, y, w, 1, group.getTotalHeader());
                cellInfos.add(ci3);
                ++y;
                --h;
            }
            ci2 = new CellInfo(x, y, 1, h, group.getHeader());
            cellInfos.add(ci2);
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.END) {
                ci = new CellInfo(x, y + h - 1, w, 1, group.getTotalHeader());
                cellInfos.add(ci);
                --h;
            }
            --w;
            ++x;
        }
        x = row_groups.length;
        y = col_groups.length;
        JRCrosstabCell[][] cells = crosstab.getCells();
        cells = ModelUtils.normalizeCell(cells, row_groups, col_groups);
        for (int i3 = 0; i3 < cells.length; ++i3) {
            for (int k = 0; k < cells[i3].length; ++k) {
                int cx = x + cells[i3].length - k - 1;
                int cy = y + cells.length - i3 - 1;
                if (cells[i3][k] == null) continue;
                CellInfo ci5 = new CellInfo(cx, cy, 1, 1, cells[i3][k].getContents());
                cellInfos.add(ci5);
            }
        }
        Integer[][] separators = ModelUtils.getColumnWidths(crosstab, cells);
        for (int i4 = 0; i4 < cellInfos.size(); ++i4) {
            CellInfo ci6 = (CellInfo)cellInfos.get(i4);
            ci6.setTop(separators[0][ci6.getY()]);
            ci6.setLeft(separators[1][ci6.getX()]);
        }
        return cellInfos;
    }

    private static Integer[][] getColumnWidths(JRDesignCrosstab designCrosstab, JRCrosstabCell[][] cells) {
        int i;
        int i2;
        ArrayList<JRDesignCellContents> cellContents = new ArrayList<JRDesignCellContents>();
        cellContents.add((JRDesignCellContents)designCrosstab.getHeaderCell());
        ArrayList<Integer> verticalSeparator = new ArrayList<Integer>();
        ArrayList<Integer> horizontalSeparator = new ArrayList<Integer>();
        verticalSeparator.add(0);
        horizontalSeparator.add(0);
        JRCrosstabColumnGroup[] col_groups = designCrosstab.getColumnGroups();
        JRCrosstabRowGroup[] row_groups = designCrosstab.getRowGroups();
        int current_x = 0;
        for (i2 = 0; i2 < row_groups.length; ++i2) {
            verticalSeparator.add(current_x += row_groups[i2].getHeader().getWidth());
            cellContents.add((JRDesignCellContents)row_groups[i2].getHeader());
            if (row_groups[i2].getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) continue;
            cellContents.add((JRDesignCellContents)row_groups[i2].getTotalHeader());
        }
        for (i2 = cells[0].length - 1; i2 >= 0; --i2) {
            verticalSeparator.add(current_x += ModelUtils.findColumnWidth(cells, i2));
        }
        int current_y = 0;
        for (i = 0; i < col_groups.length; ++i) {
            horizontalSeparator.add(current_y += col_groups[i].getHeader().getHeight());
            cellContents.add((JRDesignCellContents)col_groups[i].getHeader());
            if (col_groups[i].getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) continue;
            cellContents.add((JRDesignCellContents)col_groups[i].getTotalHeader());
        }
        for (i = cells.length - 1; i >= 0; --i) {
            horizontalSeparator.add(current_y += ModelUtils.findRowHeight(cells, i));
        }
        Integer[] hs = horizontalSeparator.toArray(new Integer[horizontalSeparator.size()]);
        Integer[] vs = verticalSeparator.toArray(new Integer[verticalSeparator.size()]);
        Integer[][] result = new Integer[][]{hs, vs};
        return result;
    }

    public static Point getCellLocation(JRDesignCrosstab crosstab, JRDesignCellContents content) {
        if (content == null || content == crosstab.getHeaderCell()) {
            return new Point(0, 0);
        }
        List<CellInfo> cellInfos = ModelUtils.getCellInfos(crosstab);
        for (int i = 0; i < cellInfos.size(); ++i) {
            CellInfo ci = cellInfos.get(i);
            if (ci.getCellContents() != content) continue;
            return new Point(ci.getLeft(), ci.getTop());
        }
        return new Point(0, 0);
    }

    public static boolean isValidNewCrosstabObjectName(JRDesignCrosstab crosstab, String new_name) {
        if (crosstab.getRowGroupIndicesMap().containsKey(new_name)) {
            return false;
        }
        if (crosstab.getColumnGroupIndicesMap().containsKey(new_name)) {
            return false;
        }
        return !crosstab.getMeasureIndicesMap().containsKey(new_name);
    }

    public static String nameOf(JRCrosstabOrigin origin) {
        String title = I18n.getString("ModelUtils.Title.unknow");
        if (origin != null) {
            switch (origin.getType()) {
                case 1: {
                    title = I18n.getString("ModelUtils.Title.Header");
                    break;
                }
                case 7: {
                    title = (origin.getRowGroupName() == null ? I18n.getString("ModelUtils.Title.Detail") : origin.getRowGroupName()) + " / " + (origin.getColumnGroupName() == null ? I18n.getString("ModelUtils.Title.Detail") : origin.getColumnGroupName());
                    break;
                }
                case 5: {
                    title = origin.getColumnGroupName() + I18n.getString("ModelUtils.Column.header");
                    break;
                }
                case 6: {
                    title = origin.getColumnGroupName() + I18n.getString("ModelUtils.Title.Totalheader");
                    break;
                }
                case 3: {
                    title = origin.getRowGroupName() + I18n.getString("ModelUtils.Title.HeaderH");
                    break;
                }
                case 4: {
                    title = origin.getRowGroupName() + I18n.getString("ModelUtils.Title.Totalheader");
                    break;
                }
                case 2: {
                    title = I18n.getString("ModelUtils.Title.WhenNoData");
                }
            }
        }
        return title;
    }

    public static String nameOf(JRDesignCellContents contents) {
        JRCrosstabOrigin origin = contents.getOrigin();
        return ModelUtils.nameOf(origin);
    }

    public static List<JRDesignCellContents> getAllCells(JRDesignCrosstab designCrosstab) {
        ArrayList<JRDesignCellContents> list = new ArrayList<JRDesignCellContents>();
        list.add((JRDesignCellContents)designCrosstab.getHeaderCell());
        List cells = designCrosstab.getCellsList();
        for (int i = 0; i < cells.size(); ++i) {
            JRCrosstabCell cell = (JRCrosstabCell)cells.get(i);
            if (cell == null || (JRDesignCellContents)cell.getContents() == null) continue;
            list.add((JRDesignCellContents)cell.getContents());
        }
        JRCrosstabRowGroup[] row_groups = designCrosstab.getRowGroups();
        for (int i = 0; i < row_groups.length; ++i) {
            switch (row_groups[i].getTotalPositionValue()) {
                case START: 
                case END: {
                    list.add((JRDesignCellContents)row_groups[i].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)row_groups[i].getHeader());
        }
        JRCrosstabColumnGroup[] col_groups = designCrosstab.getColumnGroups();
        for (int i = 0; i < col_groups.length; ++i) {
            switch (col_groups[i].getTotalPositionValue()) {
                case START: 
                case END: {
                    list.add((JRDesignCellContents)col_groups[i].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)col_groups[i].getHeader());
        }
        return list;
    }

    public static JRDesignDataset getElementDataset(JRDesignElement element, JasperDesign jd) {
        JRDesignDataset dataset = null;
        JRElementGroup group = ModelUtils.getTopElementGroup(element);
        if (group != null && group instanceof JRDesignCellContents) {
            JRCrosstabDataset elementDataset;
            JRDesignCellContents cellContent = (JRDesignCellContents)group;
            if (cellContent.getOrigin().getCrosstab().getDataset() != null && (elementDataset = cellContent.getOrigin().getCrosstab().getDataset()).getDatasetRun() != null) {
                String datasetName = elementDataset.getDatasetRun().getDatasetName();
                return (JRDesignDataset)jd.getDatasetMap().get(datasetName);
            }
        } else if (!(group instanceof JRBand)) {
            JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
            if (view != null) {
                List<GenericDesignerPanel> panels = view.getReportDesignerPanel().getDeisgnPanels();
                for (GenericDesignerPanel panel : panels) {
                    dataset = panel.getElementDataset(element);
                    if (dataset == null) continue;
                    return dataset;
                }
            }
            for (Node enode = ModelUtils.findElementNode(view.getExplorerManager().getRootContext(), (JRElement)element); enode != null && enode instanceof ElementNode; enode = enode.getParentNode()) {
                if (!(((ElementNode)enode).getElement() instanceof JRDesignComponentElement)) continue;
                JRDesignComponentElement component = (JRDesignComponentElement)((ElementNode)enode).getElement();
                Component componentImpl = component.getComponent();
                if (componentImpl == null) break;
                try {
                    JRDatasetRun dr;
                    Method m = componentImpl.getClass().getMethod("getDatasetRun", new Class[0]);
                    if (m != null && (dr = (JRDatasetRun)m.invoke((Object)componentImpl, new Object[0])) != null && jd.getDatasetMap().containsKey(dr.getDatasetName())) {
                        return (JRDesignDataset)jd.getDatasetMap().get(dr.getDatasetName());
                    }
                }
                catch (Throwable t) {}
                break;
            }
        }
        return jd.getMainDesignDataset();
    }

    public static JRDesignDataset getCrosstabDataset(JRDesignCrosstab element, JasperDesign jd) {
        JRCrosstabDataset elementDataset = element.getDataset();
        if (elementDataset != null && elementDataset.getDatasetRun() != null) {
            String datasetName = elementDataset.getDatasetRun().getDatasetName();
            return (JRDesignDataset)jd.getDatasetMap().get(datasetName);
        }
        return (JRDesignDataset)jd.getMainDataset();
    }

    public static JRDesignGroup getGroupFromBand(JasperDesign jd, JRDesignBand band) {
        if (band == null || jd == null || band.getOrigin().getGroupName() == null) {
            return null;
        }
        String s = band.getOrigin().getGroupName();
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].getName().equals(s)) continue;
            return (JRDesignGroup)groups[i];
        }
        return null;
    }

    public static boolean isAncestorElemenetGroup(JRElementGroup parent, JRElementGroup g) {
        while (g != null) {
            if (g instanceof JRDesignBand || g instanceof JRDesignCellContents) {
                return false;
            }
            if (g == parent) {
                return true;
            }
            g = g.getElementGroup();
        }
        return false;
    }

    public static boolean isChildOf(JRDesignElement element, JRElement[] elements) {
        return ModelUtils.isChildOf(element, Arrays.asList(elements));
    }

    public static boolean isChildOf(JRDesignElement element, List childrenElements) {
        if (childrenElements == null) {
            return false;
        }
        for (int i = 0; i < childrenElements.size(); ++i) {
            if (!(childrenElements.get(i) instanceof JRDesignElement) || !ModelUtils.isChildOf(element, (JRDesignElement)childrenElements.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChildOf(JRDesignElement element, JRDesignElement elementParent) {
        if (element == elementParent) {
            return true;
        }
        if (elementParent instanceof JRDesignFrame) {
            if (ModelUtils.isChildOf(element, ((JRDesignFrame)elementParent).getElements())) {
                return true;
            }
        } else if (elementParent instanceof JRDesignComponentElement) {
            try {
                JRDesignElementWidget w = (JRDesignElementWidget)IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene().findWidget(elementParent);
                if (w != null && w.getChildrenElements() != null && ModelUtils.isChildOf(element, w.getChildrenElements())) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isGroupHeader(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        return ((JRDesignBand)b).getOrigin().getBandType() == 5;
    }

    public static boolean isGroupFooter(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        return ((JRDesignBand)b).getOrigin().getBandType() == 7;
    }

    public static String nameOf(JROrigin origin) {
        if (origin != null) {
            switch (origin.getBandType()) {
                case 1: {
                    return I18n.getString("band.name.background");
                }
                case 2: {
                    return I18n.getString("band.name.title");
                }
                case 3: {
                    return I18n.getString("band.name.pageHeader");
                }
                case 4: {
                    return I18n.getString("band.name.columnHeader");
                }
                case 6: {
                    return I18n.getString("band.name.detail");
                }
                case 8: {
                    return I18n.getString("band.name.columnFooter");
                }
                case 9: {
                    return I18n.getString("band.name.pageFooter");
                }
                case 10: {
                    return I18n.getString("band.name.lastPageFooter");
                }
                case 11: {
                    return I18n.getString("band.name.summary");
                }
                case 12: {
                    return I18n.getString("band.name.noData");
                }
                case 5: {
                    return I18n.getString("band.name.GroupHeader", (Object)origin.getGroupName());
                }
                case 7: {
                    return I18n.getString("band.name.GroupFooter", (Object)origin.getGroupName());
                }
            }
        }
        return I18n.getString("ModelUtils.Title.unknow");
    }

    public static String nameOf(JRBand b, JasperDesign jd) {
        JROrigin origin = ((JRDesignBand)b).getOrigin();
        if (origin.getBandType() == 5) {
            JRGroup group = (JRGroup)jd.getGroupsMap().get(origin.getGroupName());
            int index = ModelUtils.getBandIndex(group.getGroupHeaderSection(), b);
            return I18n.getString("band.name.GroupHeaderSection", (Object)origin.getGroupName(), index + 1);
        }
        if (origin.getBandType() == 6) {
            int index = ModelUtils.getBandIndex(jd.getDetailSection(), b);
            return I18n.getString("band.name.detailSection", index + 1);
        }
        if (origin.getBandType() == 7) {
            JRGroup group = (JRGroup)jd.getGroupsMap().get(origin.getGroupName());
            int index = ModelUtils.getBandIndex(group.getGroupFooterSection(), b);
            return I18n.getString("band.name.GroupFooterSection", (Object)origin.getGroupName(), index + 1);
        }
        return ModelUtils.nameOf(((JRDesignBand)b).getOrigin());
    }

    public static int getBandIndex(JRSection section, JRBand band) {
        JRBand[] bands = section.getBands();
        for (int i = 0; bands != null && i < bands.length; ++i) {
            if (bands[i] != band) continue;
            return i;
        }
        return -1;
    }

    public static JRBand getPreviousBand(JRBand b, JasperDesign jd) {
        if (b == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        JRBand previous = null;
        for (JRBand tmpBand : bands) {
            if (tmpBand == b) {
                return previous;
            }
            previous = tmpBand;
        }
        return previous;
    }

    public static int getBandLocation(JRBand b, JasperDesign jd) {
        int yLocation = jd.getTopMargin();
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            if (tmpBand instanceof JRDesignBand && ((JRDesignBand)tmpBand).getOrigin().getBandType() == 1 && IReportManager.getInstance().isBackgroundSeparated()) {
                yLocation += jd.getTopMargin();
                yLocation += jd.getBottomMargin();
                yLocation += 40;
            }
            if (tmpBand == b) {
                return yLocation;
            }
            yLocation += tmpBand.getHeight();
        }
        return yLocation;
    }

    public static int getBandHeight(JRBand b) {
        return b != null ? b.getHeight() : 0;
    }

    public static int getMaxBandHeight(JRDesignBand b, JasperDesign jd) {
        int titleHeight;
        int k;
        if (b == null || jd == null) {
            return 0;
        }
        JROrigin origin = b.getOrigin();
        int topBottomMargins = jd.getTopMargin() + jd.getBottomMargin();
        if (origin.getBandType() == 2 && jd.isTitleNewPage() || origin.getBandType() == 11 || origin.getBandType() == 1 || origin.getBandType() == 12) {
            return jd.getPageHeight() - topBottomMargins;
        }
        int basicBandsHeight = 0;
        basicBandsHeight += topBottomMargins;
        basicBandsHeight += jd.getPageHeader() != null ? jd.getPageHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnHeader() != null ? jd.getColumnHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnFooter() != null ? jd.getColumnFooter().getHeight() : 0;
        if (b.getOrigin().getBandType() == 10) {
            return jd.getPageHeight() - basicBandsHeight;
        }
        basicBandsHeight += jd.getPageFooter() != null ? jd.getPageFooter().getHeight() : 0;
        int heighestGroupHeader = 0;
        int heighestGroupFooter = 0;
        for (int i = 0; i < jd.getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)jd.getGroupsList().get(i);
            JRBand[] bands = grp.getGroupHeaderSection().getBands();
            for (k = 0; bands != null && k < bands.length; ++k) {
                heighestGroupHeader = Math.max(heighestGroupHeader, bands[k].getHeight());
            }
            bands = grp.getGroupFooterSection().getBands();
            for (k = 0; bands != null && k < bands.length; ++k) {
                heighestGroupFooter = Math.max(heighestGroupFooter, bands[k].getHeight());
            }
        }
        if (b.getOrigin().getBandType() == 2) {
            return jd.getPageHeight() - basicBandsHeight - Math.max(heighestGroupFooter, heighestGroupHeader);
        }
        if (b.getOrigin().getBandType() == 6) {
            return jd.getPageHeight() - basicBandsHeight;
        }
        int n = titleHeight = jd.getTitle() != null ? jd.getTitle().getHeight() : 0;
        if (jd.isTitleNewPage()) {
            titleHeight = 0;
        }
        if (origin.getBandType() == 7 || origin.getBandType() == 5) {
            return jd.getPageHeight() - basicBandsHeight - titleHeight;
        }
        int detailHeight = 0;
        if (jd.getDetailSection() != null) {
            JRBand[] bandsList = jd.getDetailSection().getBands();
            for (k = 0; bandsList != null && k < bandsList.length; ++k) {
                detailHeight = Math.max(detailHeight, bandsList[k].getHeight());
            }
        }
        int maxAlternativeSection = Math.max(detailHeight, Math.max(heighestGroupFooter, heighestGroupHeader) + titleHeight);
        int res = jd.getPageHeight() - (basicBandsHeight += maxAlternativeSection) + b.getHeight();
        res = Math.min(res, jd.getPageHeight() - topBottomMargins);
        res = Math.max(res, 0);
        return res;
    }

    public static JRBand bandOfElement(JRElement element, JasperDesign jd) {
        if (element == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            JRElement[] elements = tmpBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (element != elements[i]) continue;
                return tmpBand;
            }
        }
        return null;
    }

    public static int getDesignHeight(JasperDesign jd) {
        int designHeight = 0;
        if (jd != null) {
            designHeight += jd.getTopMargin();
            List<JRBand> bands = ModelUtils.getBands(jd);
            for (JRBand b : bands) {
                designHeight += b.getHeight();
            }
            designHeight += jd.getBottomMargin();
        }
        if (IReportManager.getInstance().isBackgroundSeparated() && jd.getBackground() != null && jd.getBackground().getHeight() > 0) {
            designHeight += jd.getTopMargin();
            designHeight += jd.getBottomMargin();
            designHeight += 40;
        }
        return designHeight;
    }

    public static int getMaximumDesignHeight(JasperDesign jd) {
        int maxDesignHeight = 3 * jd.getPageHeight();
        if (jd.isTitleNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        if (jd.isSummaryNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        return maxDesignHeight;
    }

    public static Node findElementNode(Node rootNode, JRElement element) {
        if (rootNode instanceof ElementNode && ((ElementNode)rootNode).getElement().equals(element)) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        Children children = rootNode.getChildren();
        Node[] nodes = children.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = ModelUtils.findElementNode(nodes[i], element);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static JRDesignParameter cloneParameter(JRDesignParameter param) {
        JRDesignParameter newParam = new JRDesignParameter();
        newParam.setName(param.getName());
        newParam.setForPrompting(param.isForPrompting());
        newParam.setSystemDefined(param.isSystemDefined());
        newParam.setValueClassName(param.getValueClassName());
        newParam.setDescription(param.getDescription());
        if (param.getDefaultValueExpression() != null) {
            newParam.setDefaultValueExpression((JRExpression)ModelUtils.cloneExpression((JRExpression)((JRDesignExpression)param.getDefaultValueExpression())));
        }
        ModelUtils.replacePropertiesMap(param.getPropertiesMap(), newParam.getPropertiesMap());
        return newParam;
    }

    public static JRCrosstabCell[][] normalizeCell(JRCrosstabCell[][] cells, JRCrosstabRowGroup[] row_groups, JRCrosstabColumnGroup[] col_groups) {
        int i;
        JRCrosstabCell[][] newCells = new JRCrosstabCell[row_groups.length + 1][col_groups.length + 1];
        int minRow = 0;
        int maxRow = row_groups.length;
        int minCol = 0;
        int maxCol = col_groups.length;
        int[] rowsConversion = new int[row_groups.length + 1];
        int[] colsConversion = new int[col_groups.length + 1];
        for (i = 0; i < row_groups.length; ++i) {
            rowsConversion[i] = row_groups[i].getTotalPositionValue() == CrosstabTotalPositionEnum.START ? maxRow-- : minRow++;
        }
        rowsConversion[row_groups.length] = minRow;
        for (i = 0; i < col_groups.length; ++i) {
            colsConversion[i] = col_groups[i].getTotalPositionValue() == CrosstabTotalPositionEnum.START ? maxCol-- : minCol++;
        }
        colsConversion[col_groups.length] = minCol;
        for (i = 0; i < rowsConversion.length; ++i) {
            for (int j = 0; j < colsConversion.length; ++j) {
                int x = rowsConversion[i];
                int y = colsConversion[j];
                try {
                    JRCrosstabCell cell;
                    newCells[x][y] = cell = cells[i][j];
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return newCells;
    }

    public static void fixElementsExpressions(JasperDesign jd, String oldName, String newName, byte chunckType, String newClassName) {
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand b : bands) {
            if (b == null || !(b instanceof JRDesignBand)) continue;
            ModelUtils.fixElementsExpressions((JRDesignElementGroup)((JRDesignBand)b), oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementsExpressions(JRDesignCrosstab crosstab, String oldName, String newName, byte chunckType, String newClassName) {
        List<JRDesignCellContents> cells = ModelUtils.getAllCells(crosstab);
        for (JRDesignCellContents cell : cells) {
            if (cell == null || !(cell instanceof JRDesignCellContents)) continue;
            ModelUtils.fixElementsExpressions((JRDesignElementGroup)cell, oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementsExpressions(JRDesignElementGroup group, String oldName, String newName, byte chunckType, String newClassName) {
        List list = group.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            if (obj instanceof JRDesignElementGroup) {
                ModelUtils.fixElementsExpressions((JRDesignElementGroup)obj, oldName, newName, chunckType, newClassName);
                continue;
            }
            if (obj instanceof JRDesignTextField) {
                ModelUtils.fixElementExpressionText((JRDesignTextField)obj, oldName, newName, chunckType, newClassName);
                continue;
            }
            if (!(obj instanceof JRDesignImage)) continue;
            ModelUtils.fixElementExpressionImage((JRDesignImage)obj, oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementExpressionText(JRDesignTextField textfield, String oldName, String newName, byte chunckType, String newClassName) {
        JRDesignExpression exp = (JRDesignExpression)textfield.getExpression();
        ModelUtils.replaceChunkText(exp, oldName, newName, chunckType, newClassName);
        if (exp != null && exp.getValueClassName() != null && newClassName != null) {
            CreateTextFieldAction.setMatchingClassExpression(exp, exp.getValueClassName(), true);
            textfield.getEventSupport().firePropertyChange("expression", null, (Object)exp);
        }
    }

    public static void fixElementExpressionImage(JRDesignImage imageelement, String oldName, String newName, byte chunckType, String newClassName) {
        JRDesignExpression exp = (JRDesignExpression)imageelement.getExpression();
        ModelUtils.replaceChunkText(exp, oldName, newName, chunckType, newClassName);
        if (exp != null) {
            imageelement.getEventSupport().firePropertyChange("expression", null, (Object)exp);
        }
    }

    public static void replaceChunkText(JRDesignExpression exp, String oldName, String newName, byte chunckType, String newClassName) {
        if (exp == null) {
            return;
        }
        if (oldName == null || newName == null) {
            return;
        }
        if (oldName.equals(newName)) {
            return;
        }
        String oldString = "";
        String pre = "";
        String post = "";
        switch (chunckType) {
            case 3: {
                pre = "$F{";
                post = "}";
                break;
            }
            case 4: {
                pre = "$V{";
                post = "}";
                break;
            }
            case 2: {
                pre = "$P{";
                post = "}";
                break;
            }
            case 5: {
                pre = "$R{";
                post = "}";
                break;
            }
        }
        oldName = pre + oldName + post;
        newName = pre + newName + post;
        if (exp.getText() == null || exp.getText().indexOf(oldName) < 0) {
            return;
        }
        exp.setText(Misc.string_replace(newName, oldName, exp.getText()));
        if (exp.getValueClassName() != null && newClassName != null && !exp.getValueClassName().equals(newClassName)) {
            exp.setValueClassName(newClassName);
        }
    }

    public static void replacePropertiesMap(JRPropertiesMap source, JRPropertiesMap dest) {
        int i;
        String[] propertyNames = source.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                dest.setProperty(propertyNames[i], source.getProperty(propertyNames[i]));
            }
        }
        if ((propertyNames = dest.getPropertyNames()) != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                if (source.containsProperty(propertyNames[i])) continue;
                dest.removeProperty(propertyNames[i]);
            }
        }
    }

    public static void replaceExpressionProperties(JRDesignElement element, List<GenericProperty> newExpressionProperties) {
        ArrayList usedProps = new ArrayList();
        List propertyExpressions = element.getPropertyExpressionsList();
        for (int i = 0; i < propertyExpressions.size(); ++i) {
            element.removePropertyExpression((JRPropertyExpression)propertyExpressions.get(i));
        }
        if (newExpressionProperties == null) {
            return;
        }
        for (GenericProperty prop : newExpressionProperties) {
            if (!prop.isUseExpression()) continue;
            JRDesignPropertyExpression newProp = new JRDesignPropertyExpression();
            newProp.setName(prop.getKey());
            newProp.setValueExpression((JRExpression)prop.getExpression());
            element.addPropertyExpression((JRPropertyExpression)newProp);
        }
    }

    public static JRDesignExpression cloneExpression(JRExpression exp) {
        if (exp == null) {
            return null;
        }
        JRDesignExpression newExp = new JRDesignExpression();
        newExp.setValueClassName(exp.getValueClassName());
        newExp.setText(exp.getText());
        return newExp;
    }

    public static Point getParentLocation(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Widget wx;
        if (widget == null && IReportManager.getInstance().getActiveVisualView() != null && IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel() != null && IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene() != null && (wx = IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene().findWidget(element)) != null && wx instanceof JRDesignElementWidget) {
            widget = (JRDesignElementWidget)wx;
        }
        if (widget != null && widget.getScene() instanceof AbstractReportObjectScene) {
            return ((AbstractReportObjectScene)widget.getScene()).getParentLocation(jd, element, widget);
        }
        return ModelUtils.getParentLocationImpl(jd, element, widget);
    }

    public static Point getParentLocationImpl(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Point base = null;
        if (element == null) {
            return new Point(0, 0);
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof JRDesignBand) {
                JRDesignBand band = (JRDesignBand)grp;
                base = new Point(jd.getLeftMargin(), ModelUtils.getBandLocation((JRBand)band, jd));
                break;
            }
            if (grp instanceof JRDesignCellContents) {
                JRDesignCellContents cell = (JRDesignCellContents)grp;
                base = ModelUtils.getCellLocation(cell.getOrigin().getCrosstab(), cell);
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            base = ModelUtils.getParentLocation(jd, (JRDesignElement)frame, widget);
            base.x += frame.getX();
            base.y += frame.getY();
            break;
        }
        if (base == null) {
            JRDesignElementWidget owner;
            base = new Point(0, 0);
            if (widget != null && widget.getScene() instanceof ReportObjectScene && (owner = ((ReportObjectScene)widget.getScene()).findCustomComponentOwner(element)) != null) {
                base = ModelUtils.getParentLocation(jd, owner.getElement(), owner);
                base.x += owner.getElement().getX();
                base.y += owner.getElement().getY();
            }
        }
        return base;
    }

    public static Rectangle getParentBounds(JasperDesign jd, JRDesignElement element) {
        return ModelUtils.getParentBounds(jd, element, null);
    }

    public static Rectangle getParentBounds(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Widget wx;
        if (widget == null && IReportManager.getInstance().getActiveVisualView() != null && IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel() != null && IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene() != null && (wx = IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene().findWidget(element)) != null && wx instanceof JRDesignElementWidget) {
            widget = (JRDesignElementWidget)wx;
        }
        if (widget != null && widget.getScene() instanceof AbstractReportObjectScene) {
            return ((AbstractReportObjectScene)widget.getScene()).getParentBounds(jd, element, widget);
        }
        return ModelUtils.getParentBoundsImpl(jd, element, widget);
    }

    public static Rectangle getParentBoundsImpl(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Point p;
        Rectangle base = null;
        if (element == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof JRDesignBand) {
                JRDesignBand band = (JRDesignBand)grp;
                base = new Rectangle(jd.getLeftMargin(), ModelUtils.getBandLocation((JRBand)band, jd), jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin(), band.getHeight());
                break;
            }
            if (grp instanceof JRDesignCellContents) {
                JRDesignCellContents cell = (JRDesignCellContents)grp;
                p = ModelUtils.getCellLocation(cell.getOrigin().getCrosstab(), cell);
                base = new Rectangle(p.x, p.y, cell.getWidth(), cell.getHeight());
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            p = ModelUtils.getParentLocation(jd, (JRDesignElement)frame, widget);
            base = new Rectangle();
            base.x = p.x + frame.getX();
            base.y = p.y + frame.getY();
            base.width = frame.getWidth();
            base.height = frame.getHeight();
            break;
        }
        if (base == null) {
            JRDesignElementWidget owner;
            base = new Rectangle(0, 0, 0, 0);
            if (widget != null && widget.getScene() instanceof ReportObjectScene && (owner = ((ReportObjectScene)widget.getScene()).findCustomComponentOwner(element)) != null) {
                p = ModelUtils.getParentLocation(jd, owner.getElement(), owner);
                base.x += owner.getElement().getX();
                base.y += owner.getElement().getY();
                base.width += owner.getElement().getWidth();
                base.height += owner.getElement().getHeight();
            }
        }
        return base;
    }

    public static JRDesignField cloneField(JRDesignField field) throws CloneNotSupportedException {
        return (JRDesignField)field.clone();
    }

    public static JRDesignVariable cloneVariable(JRDesignVariable variable) {
        return ModelUtils.cloneVariable(variable, null);
    }

    public static JRDesignVariable cloneVariable(JRDesignVariable variable, JRDesignDataset ds) {
        JRDesignVariable newVariable = new JRDesignVariable();
        newVariable.setName(variable.getName());
        newVariable.setValueClassName(variable.getValueClassName());
        newVariable.setCalculation(variable.getCalculation());
        newVariable.setExpression((JRExpression)ModelUtils.cloneExpression(variable.getExpression()));
        newVariable.setIncrementGroup(variable.getIncrementGroup());
        newVariable.setIncrementType(variable.getIncrementType());
        newVariable.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        newVariable.setInitialValueExpression((JRExpression)ModelUtils.cloneExpression(variable.getInitialValueExpression()));
        newVariable.setResetType(variable.getResetType());
        JRGroup group = variable.getIncrementGroup();
        if (group != null && ds != null) {
            if (ds.getGroupsMap().containsKey(group.getName())) {
                newVariable.setIncrementGroup((JRGroup)ds.getGroupsMap().get(group.getName()));
            } else if (newVariable.getIncrementType() == 4) {
                newVariable.setIncrementType((byte)1);
                newVariable.setIncrementGroup(null);
            }
        } else {
            newVariable.setIncrementGroup(group);
        }
        group = variable.getResetGroup();
        if (group != null && ds != null) {
            if (ds.getGroupsMap().containsKey(group.getName())) {
                newVariable.setResetGroup((JRGroup)ds.getGroupsMap().get(group.getName()));
            } else if (newVariable.getResetType() == 4) {
                newVariable.setResetType((byte)1);
                newVariable.setResetGroup(null);
            }
        } else {
            newVariable.setResetGroup(group);
        }
        newVariable.setSystemDefined(variable.isSystemDefined());
        return newVariable;
    }

    public static JRDesignGroup cloneGroup(JRDesignGroup group) {
        JRDesignGroup newGroup = new JRDesignGroup();
        newGroup.setName(group.getName());
        newGroup.setExpression((JRExpression)ModelUtils.cloneExpression(group.getExpression()));
        return newGroup;
    }

    public static boolean containsProperty(Node.PropertySet[] sets, String propertyName) {
        for (int i = 0; i < sets.length; ++i) {
            Node.Property[] pp = sets[i].getProperties();
            for (int j = 0; j < pp.length; ++j) {
                String name = pp[j].getName();
                if (name == null || !name.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Node.Property findProperty(Node.PropertySet[] sets, String propertyName) {
        for (int i = 0; i < sets.length; ++i) {
            Node.Property[] pp = sets[i].getProperties();
            for (int j = 0; j < pp.length; ++j) {
                String name = pp[j].getName();
                if (name == null || !name.equals(propertyName)) continue;
                return pp[j];
            }
        }
        return null;
    }

    public static boolean isElementChildOf(JRDesignElement element, JRElementGroup group) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (g1 != group) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrphan(JRDesignElement element, JasperDesign jd) {
        JRElementGroup group = ModelUtils.getTopElementGroup(element);
        if (group == null) {
            return true;
        }
        if (group instanceof JRBand && !ModelUtils.getBands(jd).contains(group)) {
            return true;
        }
        if (group instanceof JRDesignCellContents) {
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)group;
        }
        return false;
    }

    public static JRElementGroup getTopElementGroup(JRDesignElement element) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (!(g1 instanceof JRDesignBand) && !(g1 instanceof JRDesignCellContents)) continue;
            return g1;
        }
        return null;
    }

    public static JRDesignBand getBandAt(JasperDesign jd, Point p) {
        if (p.x < jd.getLeftMargin()) {
            return null;
        }
        if (p.x > jd.getPageWidth() - jd.getRightMargin()) {
            return null;
        }
        if (p.y < jd.getTopMargin()) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        int currentHeight = jd.getTopMargin();
        for (JRBand tmpBand : bands) {
            if (tmpBand instanceof JRDesignBand && ((JRDesignBand)tmpBand).getOrigin().getBandType() == 1 && IReportManager.getInstance().isBackgroundSeparated() || p.y >= (currentHeight += tmpBand.getHeight())) continue;
            return (JRDesignBand)tmpBand;
        }
        if (IReportManager.getInstance().isBackgroundSeparated() && jd.getBackground() != null && jd.getBackground().getHeight() > 0 && p.y >= (currentHeight += 40 + jd.getTopMargin() + jd.getBottomMargin()) && p.y < jd.getBackground().getHeight() + currentHeight) {
            return (JRDesignBand)jd.getBackground();
        }
        return null;
    }

    public static JRDesignDataset getDatasetFromChartDataset(JRDesignChartDataset dataset, JasperDesign jd) {
        JRDesignDataset ds = (JRDesignDataset)jd.getMainDataset();
        if (dataset.getDatasetRun() != null && dataset.getDatasetRun().getDatasetName() != null) {
            ds = (JRDesignDataset)jd.getDatasetMap().get(dataset.getDatasetRun().getDatasetName());
        }
        return ds;
    }

    public static JRDesignDataset getDatasetFromCrosstabDataset(JRDesignCrosstabDataset dataset, JasperDesign jd) {
        JRDesignDataset ds = (JRDesignDataset)jd.getMainDataset();
        if (dataset.getDatasetRun() != null && dataset.getDatasetRun().getDatasetName() != null) {
            ds = (JRDesignDataset)jd.getDatasetMap().get(dataset.getDatasetRun().getDatasetName());
        }
        return ds;
    }

    public static void copyHyperlink(JRHyperlink from, JRHyperlink to) {
        if (from == null || to == null) {
            return;
        }
        try {
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkAnchorExpression", JRExpression.class, from.getHyperlinkAnchorExpression() == null ? null : from.getHyperlinkAnchorExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkPageExpression", JRExpression.class, from.getHyperlinkPageExpression() == null ? null : from.getHyperlinkPageExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkReferenceExpression", JRExpression.class, from.getHyperlinkReferenceExpression() == null ? null : from.getHyperlinkReferenceExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "LinkTarget", String.class, from.getLinkTarget());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTarget", Byte.TYPE, from.getHyperlinkTarget());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTooltipExpression", JRExpression.class, from.getHyperlinkTooltipExpression() == null ? null : from.getHyperlinkTooltipExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "LinkType", String.class, from.getLinkType() == null ? null : from.getLinkType());
            JRHyperlinkParameter[] params = from.getHyperlinkParameters();
            List parameters = ModelUtils.getHyperlinkParametersList(to);
            parameters.clear();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    parameters.add(params[i].clone());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static boolean isNephewOf(Node node, JRDesignCrosstab designCrosstab) {
        if (node == null || designCrosstab == null) {
            return false;
        }
        if (node.getLookup().lookup(JRDesignCrosstab.class) == designCrosstab) {
            return true;
        }
        if (node.getParentNode() != null) {
            return ModelUtils.isNephewOf(node.getParentNode(), designCrosstab);
        }
        return false;
    }

    private static List getHyperlinkParametersList(JRHyperlink hyperlink) {
        if (hyperlink == null) {
            return null;
        }
        try {
            Method m = hyperlink.getClass().getMethod("getHyperlinkParametersList", new Class[0]);
            return (List)m.invoke((Object)hyperlink, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void setHyperlinkAttribute(JRHyperlink hyperlink, String attribute, Class clazz, Object value) {
        if (hyperlink == null) {
            return;
        }
        try {
            Method m = hyperlink.getClass().getMethod("set" + attribute, clazz);
            m.invoke((Object)hyperlink, value);
            IReportManager.getInstance().notifyReportChange();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void applyBoxProperties(JRLineBox to, JRLineBox from) {
        to.setPadding(from.getOwnPadding());
        to.setLeftPadding(from.getOwnLeftPadding());
        to.setRightPadding(from.getOwnRightPadding());
        to.setBottomPadding(from.getOwnBottomPadding());
        to.setTopPadding(from.getOwnTopPadding());
        ModelUtils.applyPenProperties((JRPen)to.getPen(), (JRPen)from.getPen());
        ModelUtils.applyPenProperties((JRPen)to.getTopPen(), (JRPen)from.getTopPen());
        ModelUtils.applyPenProperties((JRPen)to.getLeftPen(), (JRPen)from.getLeftPen());
        ModelUtils.applyPenProperties((JRPen)to.getBottomPen(), (JRPen)from.getBottomPen());
        ModelUtils.applyPenProperties((JRPen)to.getRightPen(), (JRPen)from.getRightPen());
    }

    public static void applyPenProperties(JRPen to, JRPen from) {
        to.setLineColor(from.getOwnLineColor());
        to.setLineWidth(from.getOwnLineWidth());
        to.setLineStyle(from.getOwnLineStyle());
    }

    public static void applyDiff(JRLineBox main, JRLineBox box) {
        if (main.getOwnPadding() != box.getOwnPadding()) {
            main.setPadding(null);
        }
        if (main.getOwnLeftPadding() != box.getOwnLeftPadding()) {
            main.setLeftPadding(null);
        }
        if (main.getOwnRightPadding() != box.getOwnRightPadding()) {
            main.setRightPadding(null);
        }
        if (main.getOwnBottomPadding() != box.getOwnBottomPadding()) {
            main.setBottomPadding(null);
        }
        if (main.getOwnTopPadding() != box.getOwnTopPadding()) {
            main.setTopPadding(null);
        }
        ModelUtils.applyDiff((JRPen)main.getPen(), (JRPen)box.getPen());
        ModelUtils.applyDiff((JRPen)main.getTopPen(), (JRPen)box.getTopPen());
        ModelUtils.applyDiff((JRPen)main.getLeftPen(), (JRPen)box.getLeftPen());
        ModelUtils.applyDiff((JRPen)main.getBottomPen(), (JRPen)box.getBottomPen());
        ModelUtils.applyDiff((JRPen)main.getRightPen(), (JRPen)box.getRightPen());
    }

    public static void applyDiff(JRPen main, JRPen from) {
        if (main.getOwnLineColor() != null && !main.getOwnLineColor().equals(from.getOwnLineColor())) {
            main.setLineColor(null);
        }
        if (main.getOwnLineWidth() != null && !main.getOwnLineWidth().equals(from.getOwnLineWidth())) {
            main.setLineWidth(null);
        }
        if (main.getOwnLineStyleValue() != null && main.getOwnLineStyleValue() != from.getOwnLineStyleValue()) {
            main.setLineStyle((LineStyleEnum)null);
        }
    }

    public static JRBand getGroupFooter(JRGroup group) {
        JRBand[] footers;
        if (group.getGroupFooterSection() != null && (footers = group.getGroupFooterSection().getBands()) != null && footers.length > 0) {
            return footers[0];
        }
        return null;
    }
}

