/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.charts.ScrollableList;
import com.jaspersoft.ireport.designer.templates.TemplateCategory;
import com.jaspersoft.ireport.designer.templates.TemplateDescriptor;
import com.jaspersoft.ireport.designer.templates.TemplateRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;

public class TemplatesPanel
extends JPanel
implements Runnable {
    public static final String PROP_SELECTED_TEMPLATE = "selectedTemplate";
    TemplateRenderer renderer = null;
    private boolean fullPageView = false;
    List<TemplateCategory> categories = new ArrayList<TemplateCategory>();
    List<TemplateDescriptor> templates = new ArrayList<TemplateDescriptor>();
    private JList jList1;
    private JScrollPane jScrollPane1;

    public TemplatesPanel() {
        this.initComponents();
        this.jList1.setLayoutOrientation(2);
        this.renderer = new TemplateRenderer();
        this.jList1.setCellRenderer(this.renderer);
        this.jList1.setModel(new DefaultListModel());
        for (int i = 0; i < 40; ++i) {
            ((DefaultListModel)this.jList1.getModel()).addElement("" + i);
        }
        this.jScrollPane1.getViewport().setBackground(Color.WHITE);
        this.clearPreview();
        new Thread(this).start();
    }

    public TemplateDescriptor getSelectedTamplate() {
        return (TemplateDescriptor)this.jList1.getSelectedValue();
    }

    public void setSelectedTamplate(FileObject obj) {
        File f = FileUtil.toFile((FileObject)obj);
        for (int i = 0; i < this.jList1.getModel().getSize(); ++i) {
            TemplateDescriptor td = (TemplateDescriptor)this.jList1.getModel().getElementAt(i);
            if (!f.equals(td.getFile())) continue;
            this.jList1.setSelectedIndex(i);
            return;
        }
    }

    public void setIconsSize(int size) {
        this.setIconsSize(size, false, true);
    }

    public int getIconsSize() {
        return this.renderer.getIconSize();
    }

    private void setIconsSize(int size, boolean fullPage, boolean ensureVisible) {
        this.fullPageView = fullPage;
        this.renderer.setIconSize(size);
        if (ensureVisible) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    TemplatesPanel.this.jList1.ensureIndexIsVisible(TemplatesPanel.this.jList1.getSelectedIndex());
                }
            });
        }
        this.jList1.updateUI();
    }

    public TemplateCategory addCategory(String category, String subCategory) {
        TemplateCategory c = new TemplateCategory();
        c.setCategory(category);
        c.setSubCategory(subCategory);
        if (!this.categories.contains(c)) {
            this.categories.add(c);
        } else {
            c = this.categories.get(this.categories.indexOf(c));
        }
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                TemplatesPanel.this.updateCategories();
            }
        });
        return c;
    }

    public void addTemplate(final TemplateDescriptor td) {
        if (!this.templates.contains(td)) {
            this.templates.add(td);
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    DefaultListModel model = (DefaultListModel)TemplatesPanel.this.jList1.getModel();
                    if (model.contains(td)) {
                        return;
                    }
                    model.addElement(td);
                    if (model.size() == 1) {
                        TemplatesPanel.this.jList1.setSelectedIndex(0);
                    }
                }
            });
        }
    }

    public void clearPreview() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DefaultListModel model = (DefaultListModel)TemplatesPanel.this.jList1.getModel();
                model.removeAllElements();
                TemplatesPanel.this.jList1.updateUI();
            }
        });
    }

    public void updatePreviews() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DefaultListModel model = (DefaultListModel)TemplatesPanel.this.jList1.getModel();
                model.removeAllElements();
                for (TemplateDescriptor td : TemplatesPanel.this.templates) {
                    model.addElement(td);
                }
                if (model.getSize() > 0) {
                    TemplatesPanel.this.jList1.setSelectedIndex(0);
                }
                TemplatesPanel.this.jList1.updateUI();
            }
        });
    }

    public void updateCategories() {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new ScrollableList();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBackground(new Color(37, 37, 37));
        this.jScrollPane1.setBorder(null);
        this.jList1.setForeground(new Color(51, 51, 51));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.setSelectionMode(0);
        this.jList1.setOpaque(false);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TemplatesPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TemplatesPanel.this.jList1ComponentResized(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.firePropertyChange(PROP_SELECTED_TEMPLATE, this.jList1.getSelectedValue(), this.jList1.getSelectedValue());
    }

    private void jList1ComponentResized(ComponentEvent evt) {
        if (this.isFullPageView()) {
            int showingIndex = this.jList1.getSelectedIndex();
            if (showingIndex < 0 || showingIndex < this.jList1.getFirstVisibleIndex() || showingIndex > this.jList1.getLastVisibleIndex()) {
                showingIndex = this.jList1.getFirstVisibleIndex();
            }
            final int ensureIndexVisible = showingIndex;
            this.setIconsSize((int)(this.getSize().getHeight() / 1.2), true, false);
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    TemplatesPanel.this.jList1.ensureIndexIsVisible(0);
                    if (ensureIndexVisible != 0) {
                        TemplatesPanel.this.jList1.ensureIndexIsVisible(ensureIndexVisible);
                    }
                }
            });
        }
    }

    public JList getList() {
        return this.jList1;
    }

    public void run() {
        String pathsString;
        File templatesDirectory = InstalledFileLocator.getDefault().locate("templates", null, false);
        if (templatesDirectory != null && templatesDirectory.exists()) {
            this.loadTemplatesFromFile(templatesDirectory);
        }
        if ((pathsString = IReportManager.getPreferences().get("TEMPLATE_PATH", "")).length() > 0) {
            String[] paths = pathsString.split("\\n");
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                this.loadTemplatesFromFile(f);
            }
        }
        if (((DefaultListModel)this.jList1.getModel()).getSize() > 0) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    TemplatesPanel.this.jList1.setSelectedIndex(0);
                }
            });
        }
    }

    public void loadTemplatesFromFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.loadTemplatesFromDirectory(file);
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
                JasperDesign jd = JRXmlLoader.load((File)file);
                TemplateDescriptor td = new TemplateDescriptor();
                td.setDisplayName(jd.getName());
                td.setFile(file);
                TemplateCategory cat = this.addCategory(jd.getProperty("categoty") != null ? jd.getProperty("categoty") : "Others", jd.getProperty("subCategory") != null ? jd.getProperty("subCategory") : "Custom");
                td.setCategory(cat);
                td.setPageSize(new Dimension(jd.getPageWidth(), jd.getPageHeight()));
                this.addTemplate(td);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void loadTemplatesFromDirectory(File folder) {
        if (folder != null && folder.exists()) {
            File[] files = folder.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".jrxml");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                this.loadTemplatesFromFile(files[i]);
            }
        }
    }

    public boolean isFullPageView() {
        return this.fullPageView;
    }

    public void setFullPageView(boolean fullPageView) {
        this.fullPageView = fullPageView;
        if (fullPageView) {
            this.jList1ComponentResized(null);
            this.jList1.ensureIndexIsVisible(0);
            this.jList1.ensureIndexIsVisible(this.jList1.getSelectedIndex());
        }
    }
}

