/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.AbstractLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InheritanceTree
implements Serializable,
AbstractLookup.Storage<ArrayList<Class>> {
    private static final long serialVersionUID = 1L;
    private transient Node object = new Node(Object.class);
    private transient Map<Class, Object> interfaces;
    private transient Map<Class, AbstractLookup.ReferenceToResult> reg;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.object);
        if (this.interfaces != null) {
            for (Map.Entry<Class, Object> entry : this.interfaces.entrySet()) {
                Class clazz = entry.getKey();
                objectOutputStream.writeObject(clazz.getName());
                Object object = entry.getValue();
                if (!(object instanceof Collection) && !(object instanceof AbstractLookup.Pair)) {
                    throw new ClassCastException(String.valueOf(object));
                }
                objectOutputStream.writeObject(object);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        this.object = (Node)objectInputStream.readObject();
        this.interfaces = new WeakHashMap<Class, Object>();
        ClassLoader classLoader = Lookup.getDefault().lookup(ClassLoader.class);
        while ((string = (String)objectInputStream.readObject()) != null) {
            Object object = objectInputStream.readObject();
            if (!(object instanceof Collection) && !(object instanceof AbstractLookup.Pair)) {
                throw new ClassCastException(String.valueOf(object));
            }
            Class<?> clazz = Class.forName(string, false, classLoader);
            this.interfaces.put(clazz, object);
        }
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> pair, ArrayList<Class> arrayList) {
        Node node = InheritanceTree.registerClass(this.object, pair);
        arrayList.add(node.getType());
        if (!node.assignItem(this, pair)) {
            return false;
        }
        boolean bl = this.registerInterface(pair, arrayList);
        return bl;
    }

    @Override
    public void remove(AbstractLookup.Pair pair, ArrayList<Class> arrayList) {
        Node node = InheritanceTree.removeClass(this.object, pair);
        if (node != null) {
            arrayList.add(node.getType());
        }
        this.removeInterface(pair, arrayList);
    }

    @Override
    public void retainAll(Map map, ArrayList<Class> arrayList) {
        this.retainAllInterface(map, arrayList);
        this.retainAllClasses(this.object, map, arrayList);
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(Class<T> clazz) {
        if (clazz != null && clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return this.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration enumeration) {
        return enumeration instanceof NeedsSortEnum;
    }

    public void print(PrintStream printStream, boolean bl) {
        InheritanceTree.printNode(this.object, "", printStream, bl);
    }

    private static Node registerClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.children != null) {
            Node node2;
            Iterator<Node> iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.registerClass(node2, pair);
                if (node3 == null) continue;
                return node3;
            }
        }
        return node;
    }

    private static Node removeClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.items != null && node.items.remove(pair)) {
            return node;
        }
        if (node.children != null) {
            Node node2;
            Iterator<Node> iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.removeClass(node2, pair);
                if ((node2.items == null || node2.items.isEmpty()) && (node2.children == null || node2.children.isEmpty())) {
                    iterator.remove();
                }
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    private Node classToNode(final Node node, final Class<?> clazz) {
        Object object;
        if (!node.accepts(clazz)) {
            return null;
        }
        if (node.getType() == clazz) {
            return node;
        }
        if (node.children != null) {
            Node node2;
            object = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(object)) != null) {
                Node node3 = this.classToNode(node2, clazz);
                if (node3 != null && node2.deserialized()) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class VerifyJob
                    implements AbstractLookup.ISE.Job {
                        private AbstractLookup.Pair<?>[] pairs;
                        private boolean[] answers;

                        public VerifyJob(Collection<AbstractLookup.Pair> collection) {
                            if (collection != null) {
                                this.pairs = collection.toArray(new AbstractLookup.Pair[0]);
                            }
                        }

                        @Override
                        public void before() {
                            node2.deserialized();
                            if (this.pairs != null) {
                                this.answers = new boolean[this.pairs.length];
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    this.answers[i] = this.pairs[i].instanceOf(clazz);
                                }
                            }
                        }

                        @Override
                        public void inside() {
                            if (this.pairs != null) {
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    if (!this.answers[i]) continue;
                                    node2.assignItem(this, this.pairs[i]);
                                    node.items.remove(this.pairs[i]);
                                }
                            }
                            if (node.children != null) {
                                HashMap hashMap = new HashMap(node.children.size() * 3);
                                Iterator<Node> iterator = node.children.iterator();
                                while (iterator.hasNext()) {
                                    Node node3;
                                    Node node22 = InheritanceTree.extractNode(iterator);
                                    if (node22 == null || (node3 = hashMap.put(node22.getType(), node22)) == null) continue;
                                    iterator.remove();
                                    hashMap.put(node22.getType(), node3);
                                    node3.markDeserialized();
                                    if (node3.children == null) {
                                        node3.children = node22.children;
                                    } else if (node22.children != null) {
                                        node3.children.addAll(node22.children);
                                    }
                                    if (node22.items == null) continue;
                                    for (AbstractLookup.Pair pair : node22.items) {
                                        node3.assignItem(this, pair);
                                    }
                                }
                            }
                        }
                    }
                    VerifyJob verifyJob = new VerifyJob(node.items);
                    try {
                        verifyJob.before();
                    }
                    catch (AbstractLookup.ISE iSE) {
                        node2.markDeserialized();
                        iSE.registerJob(verifyJob);
                        throw iSE;
                    }
                    verifyJob.inside();
                    node3 = this.classToNode(node2, clazz);
                }
                if (node3 == null) continue;
                return node3;
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TwoJobs
        implements AbstractLookup.ISE.Job {
            private AbstractLookup.Pair[] pairs;
            private boolean[] answers;
            private Node newNode;

            TwoJobs() {
            }

            @Override
            public void before() {
                AbstractLookup.Pair[] pairArray = null;
                boolean[] blArray = null;
                if (node.items != null) {
                    pairArray = new AbstractLookup.Pair[node.items.size()];
                    blArray = new boolean[node.items.size()];
                    int n = 0;
                    Iterator<AbstractLookup.Pair> iterator = node.items.iterator();
                    while (iterator.hasNext()) {
                        AbstractLookup.Pair pair;
                        pairArray[n] = pair = iterator.next();
                        blArray[n] = pair.instanceOf(clazz);
                        ++n;
                    }
                }
                this.pairs = pairArray;
                this.answers = blArray;
            }

            @Override
            public void inside() {
                if (this.pairs != null && !Arrays.equals(node.items.toArray(), this.pairs)) {
                    return;
                }
                this.internal();
            }

            public void internal() {
                Iterator<Serializable> iterator;
                ArrayList<Node> arrayList = null;
                if (node.children == null) {
                    node.children = new ArrayList();
                } else {
                    Node node2;
                    iterator = node.children.iterator();
                    while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                        if (!clazz.isAssignableFrom(node2.getType())) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Node>();
                        }
                        arrayList.add(node2);
                        iterator.remove();
                    }
                }
                this.newNode = new Node(clazz);
                node.children.add(this.newNode);
                if (arrayList != null) {
                    this.newNode.children = arrayList;
                }
                if (node.items != null) {
                    iterator = node.items.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        AbstractLookup.Pair pair = (AbstractLookup.Pair)iterator.next();
                        if (this.answers[n]) {
                            iterator.remove();
                            this.newNode.assignItem(InheritanceTree.this, this.pairs[n]);
                        }
                        ++n;
                    }
                }
            }
        }
        object = new TwoJobs();
        try {
            ((TwoJobs)object).before();
        }
        catch (AbstractLookup.ISE iSE) {
            iSE.registerJob((AbstractLookup.ISE.Job)object);
            throw iSE;
        }
        ((TwoJobs)object).internal();
        return ((TwoJobs)object).newNode;
    }

    private Enumeration<AbstractLookup.Pair> searchClass(Node node, Class<?> clazz) {
        if (clazz != null) {
            node = this.classToNode(node, clazz);
        }
        if (node == null) {
            return Enumerations.empty();
        }
        return InheritanceTree.nodeToEnum(node);
    }

    private boolean retainAllClasses(Node node, Map map, Collection<Class> collection) {
        Serializable serializable;
        Iterator<Serializable> iterator;
        boolean bl = false;
        if (node.items != null && map != null) {
            iterator = node.items.iterator();
            while (iterator.hasNext()) {
                serializable = (AbstractLookup.Pair)iterator.next();
                AbstractLookup.Info info = (AbstractLookup.Info)map.remove(serializable);
                if (info == null) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                if (((AbstractLookup.Pair)serializable).getIndex() == info.index) continue;
                ((AbstractLookup.Pair)serializable).setIndex(null, info.index);
            }
            if (bl && collection != null) {
                collection.add(node.getType());
            }
        }
        if (node.children != null) {
            iterator = node.children.iterator();
            while ((serializable = InheritanceTree.extractNode(iterator)) != null) {
                boolean bl2 = this.retainAllClasses((Node)serializable, map, collection);
                if (!bl2) continue;
                iterator.remove();
            }
        }
        return bl && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration<AbstractLookup.Pair> nodeToEnum(Node node) {
        if (node.children == null) {
            Enumeration<AbstractLookup.Pair> enumeration = node.items == null ? Enumerations.empty() : Collections.enumeration(node.items);
            return enumeration;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeepAndItems
        implements Enumerations.Processor<Node, Enumeration<AbstractLookup.Pair>> {
            DeepAndItems() {
            }

            @Override
            public Enumeration<AbstractLookup.Pair> process(Node node, Collection<Node> collection) {
                if (node.children != null) {
                    collection.addAll(node.children);
                }
                if (node.items == null || node.items.isEmpty()) {
                    return Enumerations.empty();
                }
                return Collections.enumeration(node.items);
            }
        }
        Enumeration<Enumeration<AbstractLookup.Pair>> enumeration = Enumerations.queue(Enumerations.singleton(node), new DeepAndItems());
        Enumeration<AbstractLookup.Pair> enumeration2 = Enumerations.concat(enumeration);
        return new NeedsSortEnum<AbstractLookup.Pair>(enumeration2);
    }

    private boolean registerInterface(AbstractLookup.Pair<?> pair, Collection<Class> collection) {
        if (this.interfaces == null) {
            return true;
        }
        for (Map.Entry<Class, Object> entry : this.interfaces.entrySet()) {
            ArrayList arrayList;
            Class clazz = entry.getKey();
            if (!pair.instanceOf(clazz)) continue;
            Object object = entry.getValue();
            if (object instanceof Collection) {
                arrayList = (ArrayList)object;
                if (!arrayList.add(pair)) {
                    return false;
                }
            } else {
                if (object.equals(pair)) {
                    return false;
                }
                arrayList = new ArrayList(3);
                arrayList.add((AbstractLookup.Pair<?>)object);
                arrayList.add(pair);
                entry.setValue(arrayList);
            }
            collection.add(clazz);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair pair, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator<Map.Entry<Class, Object>> iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class, Object> entry = iterator.next();
            Object object = entry.getValue();
            if (object instanceof Collection) {
                Collection collection2 = (Collection)object;
                if (!collection2.remove(pair)) continue;
                if (collection2.size() == 1) {
                    entry.setValue(collection2.iterator().next());
                }
                collection.add(entry.getKey());
                continue;
            }
            if (!object.equals(pair)) continue;
            iterator.remove();
            collection.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map map, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator<Map.Entry<Class, Object>> iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry<Class, Object> entry = iterator.next();
            Object object2 = entry.getValue();
            HashMap hashMap = new HashMap(map);
            boolean bl = object2 instanceof Collection;
            Iterator<Object> iterator2 = bl ? ((Collection)object2).iterator() : Collections.singleton(object2).iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator2.hasNext()) {
                object = (AbstractLookup.Pair)iterator2.next();
                AbstractLookup.Info info = (AbstractLookup.Info)hashMap.remove(object);
                if (info == null) {
                    if (bl) {
                        iterator2.remove();
                    }
                    bl2 = true;
                    continue;
                }
                if (((AbstractLookup.Pair)object).getIndex() == info.index) continue;
                ((AbstractLookup.Pair)object).setIndex(null, info.index);
                bl3 = true;
            }
            if (bl3 && object2 instanceof List) {
                object = (List)object2;
                Collections.sort(object, ALPairComparator.DEFAULT);
            }
            if (!bl2) continue;
            if (bl) {
                object = (Collection)object2;
                if (object.size() == 1) {
                    entry.setValue(object.iterator().next());
                }
            } else {
                iterator.remove();
            }
            collection.add(entry.getKey());
        }
    }

    private Enumeration<AbstractLookup.Pair> searchInterface(Class<?> clazz) {
        Object object;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap<Class, Object>();
        }
        if ((object = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair<Object> pair = null;
            ArrayList<AbstractLookup.Pair<Object>> arrayList = null;
            Enumeration<AbstractLookup.Pair<Object>> enumeration = this.lookup(Object.class);
            while (enumeration.hasMoreElements()) {
                AbstractLookup.Pair<Object> pair2 = enumeration.nextElement();
                if (!pair2.instanceOf(clazz)) continue;
                if (pair == null) {
                    pair = pair2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList(3);
                    arrayList.add(pair);
                }
                arrayList.add(pair2);
            }
            if (arrayList == null && pair != null) {
                this.interfaces.put(clazz, pair);
                return Enumerations.singleton(pair);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<AbstractLookup.Pair<Object>>(2);
            }
            this.interfaces.put(clazz, arrayList);
            return Collections.enumeration(arrayList);
        }
        if (object instanceof Collection) {
            return Collections.enumeration((Collection)object);
        }
        return Enumerations.singleton((AbstractLookup.Pair)object);
    }

    private static Node extractNode(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.get() == null) {
                iterator.remove();
                continue;
            }
            return node;
        }
        return null;
    }

    private static void printNode(Node node, String string, PrintStream printStream, boolean bl) {
        int n;
        Class<?> clazz = node.getType();
        printStream.print(string);
        printStream.println("Node for: " + clazz + "\t" + (clazz == null ? null : clazz.getClassLoader()));
        if (node.items != null) {
            n = 0;
            for (AbstractLookup.Pair serializable : new ArrayList<AbstractLookup.Pair>(node.items)) {
                printStream.print(string);
                printStream.print("  item (" + n++ + "): ");
                printStream.print(serializable);
                printStream.print(" id: " + Integer.toHexString(System.identityHashCode(serializable)));
                printStream.print(" index: ");
                printStream.print(serializable.getIndex());
                if (bl) {
                    printStream.print(" I: " + serializable.getInstance());
                }
                printStream.println();
            }
        }
        if (node.children != null) {
            n = 0;
            for (Node node2 : node.children) {
                InheritanceTree.printNode(node2, string + "  ", printStream, bl);
            }
        }
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult<?> referenceToResult) {
        if (this.reg == null) {
            this.reg = new HashMap<Class, AbstractLookup.ReferenceToResult>();
        }
        Class clazz = referenceToResult.template.getType();
        this.lookup(clazz);
        return this.reg.put(clazz, referenceToResult);
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template template) {
        this.collectListeners(null, template.getType());
        return this.reg == null ? null : this.reg.get(template.getType());
    }

    @Override
    public ArrayList<Class> beginTransaction(int n) {
        return new ArrayList<Class>();
    }

    @Override
    public void endTransaction(ArrayList<Class> arrayList, Set<AbstractLookup.R> set) {
        if (arrayList.size() == 1) {
            this.collectListeners(set, arrayList.get(0));
        } else {
            Iterator<Class> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.collectListeners(set, iterator.next());
            }
        }
    }

    private void collectListeners(Set<AbstractLookup.R> set, Class clazz) {
        if (this.reg == null) {
            return;
        }
        while (clazz != null) {
            AbstractLookup.ReferenceToResult referenceToResult = this.reg.get(clazz);
            AbstractLookup.ReferenceIterator referenceIterator = new AbstractLookup.ReferenceIterator(referenceToResult);
            while (referenceIterator.next()) {
                AbstractLookup.R<?> r = referenceIterator.current().getResult();
                if (set == null) continue;
                set.add(r);
            }
            if (referenceToResult != referenceIterator.first()) {
                if (referenceIterator.first() == null) {
                    this.reg.remove(clazz);
                } else {
                    this.reg.put(clazz, referenceIterator.first());
                }
            }
            clazz = clazz.getSuperclass();
        }
        if (this.reg.isEmpty()) {
            this.reg = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NeedsSortEnum<T>
    implements Enumeration<T> {
        private Enumeration<T> en;

        public NeedsSortEnum(Enumeration<T> enumeration) {
            this.en = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        @Override
        public T nextElement() {
            return this.en.nextElement();
        }
    }

    private static final class R
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static ClassLoader l;
        private String clazzName;
        private transient Class<?> clazz;
        private ArrayList<Node> children;
        private Collection<AbstractLookup.Pair> items;

        public R(Node node) {
            this.clazzName = node.getType().getName();
            this.children = node.children;
            this.items = node.items instanceof LinkedHashSet || node.items == null ? node.items : new LinkedHashSet<AbstractLookup.Pair>(node.items);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (l == null) {
                l = Lookup.getDefault().lookup(ClassLoader.class);
            }
            this.clazz = Class.forName(this.clazzName, false, l);
        }

        private Object readResolve() throws ObjectStreamException {
            Node node = new Node(this.clazz);
            node.children = this.children;
            node.items = this.items;
            node.markDeserialized();
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node
    extends WeakReference<Class>
    implements Serializable {
        static final long serialVersionUID = 3L;
        public ArrayList<Node> children;
        public Collection<AbstractLookup.Pair> items;

        public Node(Class clazz) {
            super(clazz);
        }

        public boolean deserialized() {
            if (this.items == null || this.items instanceof LinkedHashSet) {
                return false;
            }
            this.items = this.items.isEmpty() ? null : new LinkedHashSet<AbstractLookup.Pair>(this.items);
            return true;
        }

        public void markDeserialized() {
            this.items = this.items == null || this.items == Collections.EMPTY_LIST ? Collections.emptyList() : Collections.synchronizedCollection(this.items);
        }

        public Class<?> getType() {
            Class clazz = (Class)this.get();
            return clazz == null ? Void.TYPE : clazz;
        }

        public boolean accepts(Class<?> clazz) {
            if (this.getType() == Object.class) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair<?> pair) {
            if (this.getType() == Object.class) {
                return true;
            }
            return pair.instanceOf(this.getType());
        }

        public boolean assignItem(InheritanceTree inheritanceTree, AbstractLookup.Pair<?> pair) {
            if (this.items == null || this.items == Collections.EMPTY_LIST) {
                this.items = new LinkedHashSet<AbstractLookup.Pair>();
                this.items.add(pair);
                return true;
            }
            if (this.items.contains(pair)) {
                AbstractLookup.Pair pair2;
                Iterator<AbstractLookup.Pair> iterator = this.items.iterator();
                while (!pair.equals(pair2 = iterator.next())) {
                }
                if (pair2 != pair) {
                    pair.setIndex(inheritanceTree, pair2.getIndex());
                }
                iterator.remove();
                this.items.add(pair);
                return false;
            }
            this.items.add(pair);
            return true;
        }

        private Object writeReplace() {
            return new R(this);
        }

        public String toString() {
            return "Node for " + this.get();
        }
    }
}

